/*
 * Decompiled with CFR 0.152.
 */
package io.aether.net.fastMeta.nio;

import io.aether.logger.LNode;
import io.aether.logger.Log;
import io.aether.net.fastMeta.FastFutureContext;
import io.aether.net.fastMeta.FastMetaApi;
import io.aether.net.fastMeta.FastMetaClient;
import io.aether.net.fastMeta.FastMetaNet;
import io.aether.net.fastMeta.RemoteApi;
import io.aether.net.fastMeta.nio.NioEventHandler;
import io.aether.net.fastMeta.nio.NioReactor;
import io.aether.net.fastMeta.nio.NioTcpConnection;
import io.aether.utils.Destroyer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.interfaces.AFunction;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

class NioTcpFastMetaClient<LT, RT extends RemoteApi>
implements FastMetaClient<LT, RT>,
NioEventHandler {
    private static final long INITIAL_RECONNECT_DELAY_MS = 300L;
    private static final long RECONNECT_DELAY_INCREMENT_MS = 100L;
    private static final long MAX_RECONNECT_DELAY_MS = 2000L;
    private long currentReconnectDelayMs = 300L;
    private final NioReactor reactor;
    private final URI uri;
    private final FastMetaApi<LT, ?> localApiMeta;
    private final FastMetaApi<?, RT> remoteApiMeta;
    private final AFunction<RT, LT> localApiProvider;
    private final FastMetaNet.WritableConsumer writableConsumer;
    private final LNode logContext;
    private final Destroyer destroyer;
    private final AtomicReference<NioTcpConnection<LT, RT>> connection = new AtomicReference();
    private final ScheduledExecutorService reconnectScheduler;
    private volatile boolean active = true;
    private volatile SelectionKey connectKey;

    NioTcpFastMetaClient(NioReactor reactor, URI uri, FastMetaApi<LT, ?> lt, FastMetaApi<?, RT> rt, AFunction<RT, LT> localApiProvider, FastMetaNet.WritableConsumer writableConsumer) {
        this.reactor = reactor;
        this.uri = uri;
        this.localApiMeta = lt;
        this.remoteApiMeta = rt;
        this.localApiProvider = localApiProvider;
        this.writableConsumer = writableConsumer;
        this.logContext = Log.of((Object[])new Object[]{"clientUri", uri, "socket", "client nio"});
        this.destroyer = new Destroyer("NioTcpFastMetaClient-" + uri.getPort());
        this.reconnectScheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            String threadName = "fastmeta-client-reconnect-" + uri.getPort();
            Thread t = new Thread(r, threadName);
            t.setDaemon(true);
            return t;
        });
        this.destroyer.add(() -> this.reconnectScheduler.shutdownNow());
        this.tryConnect();
    }

    private void tryConnect() {
        if (!this.active) {
            return;
        }
        this.reactor.addTask(() -> {
            if (!this.active || this.connection.get() != null) {
                return;
            }
            try (LNode.AutoCloseable _l = this.logContext.context();){
                Log.info((String)"Attempting to connect...", (LNode[])new LNode[0]);
                SocketChannel channel = SocketChannel.open();
                channel.configureBlocking(false);
                boolean connecting = channel.connect(new InetSocketAddress(this.uri.getHost(), this.uri.getPort()));
                if (connecting) {
                    Log.info((String)"Connected immediately", (LNode[])new LNode[0]);
                    this.finishConnection(channel);
                } else {
                    Log.trace((String)"Connection pending...", (LNode[])new LNode[0]);
                    this.reactor.register(channel, 8, this);
                }
            }
            catch (Exception e) {
                this.scheduleReconnect();
            }
        });
    }

    private void scheduleReconnect() {
        if (!this.active) {
            return;
        }
        this.writableConsumer.apply(false);
        long delayToUse = this.currentReconnectDelayMs;
        this.currentReconnectDelayMs = Math.min(this.currentReconnectDelayMs + 100L, 2000L);
        Log.info((String)"Scheduling reconnect...", (Object[])new Object[]{this.logContext, "delayMs", delayToUse, "nextDelayMs", this.currentReconnectDelayMs});
        this.reconnectScheduler.schedule(this::tryConnect, delayToUse, TimeUnit.MILLISECONDS);
    }

    @Override
    public void handleEvent(SelectionKey key) {
        block11: {
            try (LNode.AutoCloseable _l = this.logContext.context();){
                this.connectKey = key;
                if (!key.isValid()) {
                    return;
                }
                if (!key.isConnectable()) break block11;
                SocketChannel channel = (SocketChannel)key.channel();
                try {
                    if (channel.finishConnect()) {
                        key.interestOps(0);
                        this.connectKey = null;
                        this.finishConnection(channel);
                    }
                }
                catch (Exception e) {
                    Log.warn((String)"Failed to finish connection", (Throwable)e, (Object[])new Object[]{this.logContext});
                    this.closeConnection(e);
                }
            }
        }
    }

    private void finishConnection(SocketChannel channel) {
        try (LNode.AutoCloseable _l = this.logContext.context();){
            Log.info((String)"Connection established", (Object[])new Object[]{"local", channel.getLocalAddress()});
            this.currentReconnectDelayMs = 300L;
            NioTcpConnection<Object, RT> conn = new NioTcpConnection<Object, RT>(this.reactor, channel, this.localApiMeta, this.remoteApiMeta, this::onConnectionClosed);
            Object localApi = this.localApiProvider.apply(conn.getRemoteApi());
            conn.setLocalApi(localApi);
            NioTcpConnection<LT, RT> oldConn = this.connection.getAndSet(conn);
            if (oldConn != null) {
                Log.warn((String)"Replacing an existing connection unexpectedly.", (LNode[])new LNode[0]);
                this.destroyer.remove(oldConn);
                oldConn.destroy(true);
            }
            this.destroyer.add(conn);
            this.writableConsumer.apply(true);
            this.reactor.register(channel, 1, conn);
        }
        catch (Exception e) {
            Log.error((String)"Failed to finalize connection setup", (Throwable)e, (Object[])new Object[0]);
            try {
                channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.scheduleReconnect();
        }
    }

    private void onConnectionClosed(NioTcpConnection<LT, RT> closedConn) {
        if (this.connection.compareAndSet(closedConn, null)) {
            Log.warn((String)"Client connection lost", (LNode)this.logContext);
            this.scheduleReconnect();
        }
    }

    @Override
    public void closeConnection(Exception e) {
        SelectionKey key = this.connectKey;
        this.connectKey = null;
        if (key != null) {
            key.cancel();
            try {
                key.channel().close();
            }
            catch (IOException ex) {
                Log.warn((String)"Error closing channel during connect failure", (Throwable)ex, (Object[])new Object[]{this.logContext});
            }
        }
        this.scheduleReconnect();
    }

    public void flush(AFuture sendFuture) {
        NioTcpConnection<LT, RT> conn = this.connection.get();
        if (conn != null) {
            conn.getMetaContext().flush(sendFuture);
        } else {
            sendFuture.tryCancel();
        }
    }

    public void read() {
    }

    public void stopRead() {
    }

    public AFuture write(byte[] data) {
        NioTcpConnection<LT, RT> conn = this.connection.get();
        return conn != null ? conn.write(data) : AFuture.canceled();
    }

    public LT getLocalApi() {
        NioTcpConnection<LT, RT> conn = this.connection.get();
        return conn != null ? (LT)conn.getLocalApi() : null;
    }

    public RT getRemoteApi() {
        NioTcpConnection<LT, RT> conn = this.connection.get();
        return conn != null ? (RT)conn.getRemoteApi() : null;
    }

    public boolean isWritable() {
        NioTcpConnection<LT, RT> conn = this.connection.get();
        return conn != null && conn.isWritable();
    }

    public FastFutureContext getMetaContext() {
        NioTcpConnection<LT, RT> conn = this.connection.get();
        return conn != null ? conn.getMetaContext() : FastFutureContext.STUB;
    }

    public AFuture destroy(boolean force) {
        Log.info((String)"Destroying client", (LNode)this.logContext);
        this.active = false;
        SelectionKey key = this.connectKey;
        this.connectKey = null;
        if (key != null) {
            this.reactor.addTask(() -> {
                key.cancel();
                try {
                    key.channel().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        return this.destroyer.destroy(force);
    }
}

