/*
 * Decompiled with CFR 0.152.
 */
package io.aether.net.fastMeta.nio;

import io.aether.logger.LNode;
import io.aether.logger.Log;
import io.aether.net.fastMeta.FastMetaApi;
import io.aether.net.fastMeta.FastMetaNet;
import io.aether.net.fastMeta.FastMetaServer;
import io.aether.net.fastMeta.RemoteApi;
import io.aether.net.fastMeta.nio.NioEventHandler;
import io.aether.net.fastMeta.nio.NioReactor;
import io.aether.net.fastMeta.nio.NioTcpConnection;
import io.aether.utils.Destroyer;
import io.aether.utils.futures.AFuture;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class NioTcpFastMetaServer<LT, RT extends RemoteApi>
implements FastMetaServer<LT, RT>,
NioEventHandler {
    private final NioReactor reactor;
    private final FastMetaApi<LT, ?> localApiMeta;
    private final FastMetaApi<?, RT> remoteApiMeta;
    private final FastMetaServer.Handler<LT, RT> handler;
    private final ServerSocketChannel serverChannel;
    private final LNode logContext;
    private final Destroyer destroyer;
    private final Map<NioTcpConnection<LT, RT>, Boolean> connections = new ConcurrentHashMap<NioTcpConnection<LT, RT>, Boolean>();

    NioTcpFastMetaServer(NioReactor reactor, URI uri, FastMetaApi<LT, ?> localApiMeta, FastMetaApi<?, RT> remoteApiMeta, FastMetaServer.Handler<LT, RT> handler) {
        this.reactor = reactor;
        this.localApiMeta = localApiMeta;
        this.remoteApiMeta = remoteApiMeta;
        this.handler = handler;
        this.logContext = Log.of((Object[])new Object[]{"serverUri", uri, "socket", "server nio"});
        this.destroyer = new Destroyer("NioTcpFastMetaServer-" + uri.getPort());
        try (LNode.AutoCloseable _l = this.logContext.context();){
            Log.info((String)"Starting TCP server...", (LNode[])new LNode[0]);
            this.serverChannel = ServerSocketChannel.open();
            this.serverChannel.bind(new InetSocketAddress(uri.getHost(), uri.getPort()));
            this.serverChannel.configureBlocking(false);
            this.destroyer.add((AutoCloseable)this.serverChannel);
            reactor.register(this.serverChannel, 16, this);
            Log.info((String)"TCP server started and listening", (LNode[])new LNode[0]);
        }
        catch (IOException e) {
            Log.error((String)"Failed to start TCP server", (Throwable)e, (Object[])new Object[0]);
            throw new RuntimeException("Failed to start TCP server", e);
        }
    }

    @Override
    public void handleEvent(SelectionKey key) {
        try (LNode.AutoCloseable _l = this.logContext.context();){
            if (key.isAcceptable()) {
                this.handleAccept();
            }
        }
    }

    private void handleAccept() {
        try (LNode.AutoCloseable _l = this.logContext.context();){
            SocketChannel clientChannel = this.serverChannel.accept();
            if (clientChannel == null) {
                return;
            }
            clientChannel.configureBlocking(false);
            Log.info((String)"Accepted new connection", (Object[])new Object[]{"remote", clientChannel.getRemoteAddress()});
            NioTcpConnection<Object, RT> connection = new NioTcpConnection<Object, RT>(this.reactor, clientChannel, this.localApiMeta, this.remoteApiMeta, this::onConnectionClosed);
            Object localApi = this.handler.onNewConnection(connection);
            connection.setLocalApi(localApi);
            this.connections.put(connection, true);
            this.destroyer.add(connection);
            this.reactor.register(clientChannel, 1, connection);
        }
        catch (Exception e) {
            Log.warn((String)"Failed to accept new connection", (Throwable)e, (Object[])new Object[0]);
        }
    }

    private void onConnectionClosed(NioTcpConnection<LT, RT> connection) {
        if (this.connections.remove(connection) != null) {
            Log.info((String)"Connection removed from server", (LNode)connection.getLogContext());
            this.handler.onConnectionClose(connection);
        }
    }

    @Override
    public void closeConnection(Exception e) {
        Log.error((String)"Server socket failed, stopping server...", (Throwable)e, (Object[])new Object[]{this.logContext});
        this.destroy(true);
    }

    public AFuture stop() {
        return this.destroy(false);
    }

    public AFuture destroy(boolean force) {
        Log.info((String)"Destroying TCP server...", (LNode)this.logContext);
        this.connections.clear();
        return this.destroyer.destroy(force);
    }

    public Iterable<FastMetaNet.Connection<LT, RT>> handlers() {
        return new HashSet<FastMetaNet.Connection<LT, RT>>(this.connections.keySet());
    }
}

