/*
 * Decompiled with CFR 0.152.
 */
package io.aether.logger;

import io.aether.logger.Log;
import io.aether.utils.AString;
import io.aether.utils.RU;
import io.aether.utils.ToString;
import io.aether.utils.interfaces.ABiConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.lang.ref.Reference;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class LNode
implements ToString {
    public final long id = Log.ID_COUNTER.getAndIncrement();
    public static final LNode EMPTY = new LNode(null){

        @Override
        public int count0() {
            return 0;
        }

        @Override
        protected Object get0(String key) {
            return null;
        }

        @Override
        protected void foreach0(Set<String> exclude, ABiConsumer<String, Object> c) {
        }

        @Override
        public LNode add(Object ... data) {
            return EMPTY;
        }

        @Override
        public LNode add(LNode data) {
            return EMPTY;
        }

        @Override
        public LNode add(LNode ... data) {
            return EMPTY;
        }

        @Override
        public LNode addMap(Map<String, ?> vals) {
            return EMPTY;
        }

        @Override
        public LNode add(String[] keys, Object[] vals) {
            return EMPTY;
        }

        @Override
        public void log(LNode node) {
        }

        @Override
        public LNode trace(String msg, Object ... data) {
            return EMPTY;
        }

        @Override
        public LNode trace(ToString msg, Object ... data) {
            return EMPTY;
        }

        @Override
        public LNode trace(String msg, LNode ... data) {
            return EMPTY;
        }

        @Override
        public LNode trace(String msg, LNode data) {
            return EMPTY;
        }

        @Override
        public LNode debug(String msg, Object ... data) {
            return EMPTY;
        }

        @Override
        public LNode debug(ToString msg, Object ... data) {
            return EMPTY;
        }

        @Override
        public LNode debug(String msg, LNode ... data) {
            return EMPTY;
        }

        @Override
        public LNode debug(String msg, LNode data) {
            return EMPTY;
        }

        @Override
        public LNode info(String msg, Object ... data) {
            return EMPTY;
        }

        @Override
        public LNode info(ToString msg, Object ... data) {
            return EMPTY;
        }

        @Override
        public LNode info(String msg, LNode ... data) {
            return EMPTY;
        }

        @Override
        public LNode info(String msg, LNode data) {
            return EMPTY;
        }

        @Override
        public LNode warn(String msg, Object ... data) {
            return EMPTY;
        }

        @Override
        public LNode warn(ToString msg, Object ... data) {
            return EMPTY;
        }

        @Override
        public LNode warn(String msg, LNode ... data) {
            return EMPTY;
        }

        @Override
        public LNode warn(String msg, LNode data) {
            return EMPTY;
        }

        @Override
        public LNode warn(String msg, Throwable throwable, Object ... data) {
            return EMPTY;
        }

        @Override
        public LNode error(String msg, Object ... data) {
            return EMPTY;
        }

        @Override
        public LNode error(String msg, Throwable throwable, Object ... data) {
            return EMPTY;
        }

        @Override
        public LNode error(Throwable throwable, Object ... data) {
            return EMPTY;
        }
    };
    public final LNode parent;

    public LNode(LNode parent) {
        this.parent = parent;
    }

    public boolean msgContains(String testData) {
        String m = this.getMsg();
        if (m == null || m.isBlank()) {
            return false;
        }
        return m.contains(testData);
    }

    public LNode add(Object ... data) {
        return LNode.of2(this, data);
    }

    public LNode add(LNode data) {
        return LNode.of2(this, data);
    }

    public LNode add(LNode ... data) {
        return LNode.of2(this, data);
    }

    public LNode addMap(Map<String, ?> vals) {
        return LNode.ofMap(this, vals);
    }

    public LNode add(String[] keys, Object[] vals) {
        return LNode.of2(this, keys, vals);
    }

    public AutoCloseable context() {
        Log.push(this);
        return new AutoCloseable(){

            @Override
            public void close() {
                Log.pop(LNode.this);
            }

            @Override
            public LNode node() {
                return LNode.this;
            }
        };
    }

    @Override
    public void toString(AString sb) {
        Log.Level l = (Log.Level)((Object)this.getCast("logLevel"));
        if (l != null) {
            sb.add((String)this.get("logLevel"));
            sb.add(" ");
        }
        HashSet<String> exclude = new HashSet<String>();
        exclude.add("logLevel");
        exclude.add("logMessage");
        this.printMessage(sb, exclude, null, null);
        sb.add(" ");
        this.foreach(exclude, (k, v) -> {
            sb.add((String)k).add(" = ");
            sb.add(v);
            sb.add(", ");
        });
    }

    protected abstract Object get0(String var1);

    public final <T> T get(String key) {
        Object val = this.get0(key);
        if (val instanceof Reference) {
            val = ((Reference)val).get();
        }
        if (val != null) {
            return (T)val;
        }
        if (this.parent != null) {
            return this.parent.get(key);
        }
        return null;
    }

    protected abstract void foreach0(Set<String> var1, ABiConsumer<String, Object> var2);

    public void foreach(Set<String> exclude, ABiConsumer<String, Object> c) {
        this.foreach0(exclude, c);
        if (this.parent != null) {
            this.parent.foreach(exclude, c);
        }
    }

    protected abstract int count0();

    public int count() {
        int res = this.count0();
        if (this.parent != null) {
            res += this.parent.count();
        }
        return res;
    }

    public boolean isEmpty() {
        return this.count() == 0;
    }

    public String toString() {
        return this.toString2();
    }

    public Map<String, Object> toMap() {
        Object2ObjectArrayMap map = new Object2ObjectArrayMap();
        HashSet<String> s = new HashSet<String>();
        this.foreach(s, ((Map)map)::put);
        return map;
    }

    public <T> T getCast(String key) {
        return RU.cast(this.get(key));
    }

    public boolean contains(String key) {
        return this.get(key) != null;
    }

    public String getMsg() {
        return String.valueOf(this.get("logMessage"));
    }

    public AString getMessage() {
        return this.getMessage(Set.of());
    }

    public AString getMessage(Set<String> keys) {
        AString sb = AString.of();
        this.printMessage(sb, keys, null, null);
        return sb;
    }

    public void printMessage(AString w, Set<String> keys, String color, String defaultColor) {
        try {
            String msg = (String)this.getCast("logMessage");
            if (msg == null) {
                return;
            }
            w.addVars((CharSequence)msg, k -> {
                String kk = k.toString();
                keys.add(k.toString());
                return this.get(kk);
            });
            Throwable e = this.getException();
            if (e != null) {
                w.add(" [");
                w.addStackTrace(e);
                w.add("]");
            }
        }
        catch (Exception e) {
            w.add("error print message: ").addStackTrace(e);
        }
    }

    public Object getSystemComponent() {
        return this.get("SystemComponent");
    }

    public boolean checkSystemComponent(Object val) {
        return Objects.equals(this.getSystemComponent(), val);
    }

    public boolean isTrace() {
        return this.check("logLevel", (Object)Log.Level.TRACE);
    }

    public boolean isDebug() {
        return this.check("logLevel", (Object)Log.Level.DEBUG);
    }

    public boolean isInfo() {
        return this.check("logLevel", (Object)Log.Level.INFO);
    }

    public boolean isWarn() {
        return this.check("logLevel", (Object)Log.Level.WARN);
    }

    public boolean isError() {
        return this.check("logLevel", (Object)Log.Level.ERROR);
    }

    public boolean check(String key, Object value) {
        return Objects.equals(this.get(String.valueOf(key)), value);
    }

    public Throwable getException() {
        return (Throwable)this.getCast("exception");
    }

    public Log.Level getLevel() {
        return (Log.Level)((Object)this.getCast("logLevel"));
    }

    public void log(LNode node) {
        if (!Log.ENABLED) {
            return;
        }
        Log.fire(node);
    }

    public LNode trace(ToString msg, Object ... data) {
        return this.trace(msg.toString2(), data);
    }

    public LNode trace(String msg, LNode ... data) {
        return this.trace(msg, LNode.of2(EMPTY, data));
    }

    public LNode trace(String msg, LNode data) {
        if (!Log.ENABLED) {
            return EMPTY;
        }
        LNode msgNode = LNode.of2(EMPTY, new Object[]{"logTime", System.currentTimeMillis(), "logLevel", Log.Level.TRACE, "logMessage", msg});
        LNode logNode = this.add(msgNode, data);
        Log.fire(logNode);
        return logNode;
    }

    public LNode trace(String msg, Object ... data) {
        if (!Log.ENABLED) {
            return EMPTY;
        }
        Object[] d2 = new Object[6 + data.length];
        d2[0] = "logTime";
        d2[1] = System.currentTimeMillis();
        d2[2] = "logLevel";
        d2[3] = Log.Level.TRACE;
        d2[4] = "logMessage";
        d2[5] = msg;
        System.arraycopy(data, 0, d2, 6, data.length);
        LNode logNode = this.add(d2);
        Log.fire(logNode);
        return logNode;
    }

    public LNode debug(ToString msg, Object ... data) {
        return this.debug(msg.toString2(), data);
    }

    public LNode debug(String msg, Object ... data) {
        if (!Log.ENABLED) {
            return EMPTY;
        }
        Object[] d2 = new Object[6 + data.length];
        d2[0] = "logTime";
        d2[1] = System.currentTimeMillis();
        d2[2] = "logLevel";
        d2[3] = Log.Level.DEBUG;
        d2[4] = "logMessage";
        d2[5] = msg;
        System.arraycopy(data, 0, d2, 6, data.length);
        LNode logNode = this.add(d2);
        Log.fire(logNode);
        return logNode;
    }

    public LNode debug(String msg, LNode ... data) {
        return this.debug(msg, LNode.of2(EMPTY, data));
    }

    public LNode debug(String msg, LNode data) {
        if (!Log.ENABLED) {
            return EMPTY;
        }
        LNode msgNode = LNode.of2(EMPTY, new Object[]{"logTime", System.currentTimeMillis(), "logLevel", Log.Level.DEBUG, "logMessage", msg});
        LNode logNode = this.add(msgNode, data);
        Log.fire(logNode);
        return logNode;
    }

    public LNode info(ToString msg, Object ... data) {
        return this.info(msg.toString2(), data);
    }

    public LNode info(String msg, Object ... data) {
        if (!Log.ENABLED) {
            return EMPTY;
        }
        Object[] d2 = new Object[6 + data.length];
        d2[0] = "logTime";
        d2[1] = System.currentTimeMillis();
        d2[2] = "logLevel";
        d2[3] = Log.Level.INFO;
        d2[4] = "logMessage";
        d2[5] = msg;
        System.arraycopy(data, 0, d2, 6, data.length);
        LNode logNode = this.add(d2);
        Log.fire(logNode);
        return logNode;
    }

    public LNode info(String msg, LNode ... data) {
        return this.info(msg, LNode.of2(EMPTY, data));
    }

    public LNode info(String msg, LNode data) {
        if (!Log.ENABLED) {
            return EMPTY;
        }
        LNode msgNode = LNode.of2(EMPTY, new Object[]{"logTime", System.currentTimeMillis(), "logLevel", Log.Level.INFO, "logMessage", msg});
        LNode logNode = this.add(msgNode, data);
        Log.fire(logNode);
        return logNode;
    }

    public LNode warn(ToString msg, Object ... data) {
        return this.warn(msg.toString2(), data);
    }

    public LNode warn(String msg, Object ... data) {
        if (!Log.ENABLED) {
            return EMPTY;
        }
        Object[] d2 = new Object[6 + data.length];
        d2[0] = "logTime";
        d2[1] = System.currentTimeMillis();
        d2[2] = "logLevel";
        d2[3] = Log.Level.WARN;
        d2[4] = "logMessage";
        d2[5] = msg;
        System.arraycopy(data, 0, d2, 6, data.length);
        LNode logNode = this.add(d2);
        Log.fire(logNode);
        return logNode;
    }

    public LNode warn(String msg, LNode ... data) {
        return this.warn(msg, LNode.of2(EMPTY, data));
    }

    public LNode warn(String msg, LNode data) {
        if (!Log.ENABLED) {
            return EMPTY;
        }
        LNode msgNode = LNode.of2(EMPTY, new Object[]{"logTime", System.currentTimeMillis(), "logLevel", Log.Level.WARN, "logMessage", msg});
        LNode logNode = this.add(msgNode, data);
        Log.fire(logNode);
        return logNode;
    }

    public LNode warn(String msg, Throwable throwable, Object ... data) {
        if (!Log.ENABLED) {
            return EMPTY;
        }
        Object[] d2 = new Object[8 + data.length];
        d2[0] = "logTime";
        d2[1] = System.currentTimeMillis();
        d2[2] = "logLevel";
        d2[3] = Log.Level.WARN;
        d2[4] = "exception";
        d2[5] = throwable;
        d2[6] = "logMessage";
        d2[7] = msg;
        System.arraycopy(data, 0, d2, 8, data.length);
        LNode logNode = this.add(d2);
        Log.fire(logNode);
        return logNode;
    }

    public LNode error(String msg, Throwable throwable, Object ... data) {
        if (!Log.ENABLED) {
            return EMPTY;
        }
        Object[] d2 = new Object[8 + data.length];
        d2[0] = "logTime";
        d2[1] = System.currentTimeMillis();
        d2[2] = "logLevel";
        d2[3] = Log.Level.ERROR;
        d2[4] = "exception";
        d2[5] = throwable;
        d2[6] = "logMessage";
        d2[7] = msg;
        System.arraycopy(data, 0, d2, 8, data.length);
        LNode logNode = this.add(d2);
        Log.fire(logNode);
        return logNode;
    }

    public LNode error(String msg, Object ... data) {
        if (!Log.ENABLED) {
            return EMPTY;
        }
        Object[] d2 = new Object[6 + data.length];
        d2[0] = "logTime";
        d2[1] = System.currentTimeMillis();
        d2[2] = "logLevel";
        d2[3] = Log.Level.ERROR;
        d2[4] = "logMessage";
        d2[5] = msg;
        System.arraycopy(data, 0, d2, 6, data.length);
        LNode logNode = this.add(d2);
        Log.fire(logNode);
        return logNode;
    }

    public LNode error(Throwable throwable, Object ... data) {
        return this.error(throwable.getMessage(), throwable, data);
    }

    public static LNode of2(LNode parent, final LNode ... data) {
        if (data == null || data.length == 0) {
            return parent;
        }
        return new LNode(parent){

            @Override
            protected Object get0(String key) {
                for (LNode n : data) {
                    Object r;
                    if (n == null || (r = n.get(key)) == null) continue;
                    return r;
                }
                return null;
            }

            @Override
            protected void foreach0(Set<String> exclude, ABiConsumer<String, Object> c) {
                for (LNode n : data) {
                    if (n == null) continue;
                    n.foreach(exclude, c);
                }
            }

            @Override
            protected int count0() {
                int c = 0;
                for (LNode n : data) {
                    if (n == null) continue;
                    c += n.count();
                }
                return c;
            }
        };
    }

    public static LNode of2(LNode parent, final Object ... data) {
        if (data == null || data.length == 0) {
            return parent;
        }
        if (data.length % 2 != 0) {
            throw new IllegalArgumentException("LNode.of data must be key-value pairs.");
        }
        for (int i = 0; i < data.length; i += 2) {
            if (data[i] == null) {
                throw new IllegalArgumentException("LNode key cannot be null.");
            }
            if (data[i] instanceof String) continue;
            throw new IllegalStateException("LNode key must be a String.");
        }
        return new LNode(parent){

            @Override
            protected Object get0(String key) {
                for (int i = 0; i < data.length; i += 2) {
                    if (!data[i].equals(key)) continue;
                    return data[i + 1];
                }
                return null;
            }

            @Override
            protected void foreach0(Set<String> exclude, ABiConsumer<String, Object> c) {
                for (int i = 0; i < data.length; i += 2) {
                    String key = String.valueOf(data[i]);
                    if (!exclude.add(key)) continue;
                    c.accept(key, data[i + 1]);
                }
            }

            @Override
            protected int count0() {
                return data.length / 2;
            }
        };
    }

    public static LNode ofMap(LNode parent, final Map<String, ?> map) {
        if (map == null || map.isEmpty()) {
            return parent;
        }
        return new LNode(parent){

            @Override
            protected Object get0(String key) {
                return map.get(key);
            }

            @Override
            protected void foreach0(Set<String> exclude, ABiConsumer<String, Object> c) {
                for (Map.Entry e : map.entrySet()) {
                    if (!exclude.add((String)e.getKey())) continue;
                    c.accept((String)e.getKey(), e.getValue());
                }
            }

            @Override
            protected int count0() {
                return map.size();
            }
        };
    }

    public static LNode of2(LNode parent, final String[] keys, final Object[] vals) {
        if (keys == null || vals == null || keys.length == 0 || keys.length != vals.length) {
            Log.warn("bad node", "keys", keys, "vals", vals);
            return EMPTY;
        }
        return new LNode(parent){

            @Override
            protected Object get0(String key) {
                for (int i = 0; i < keys.length; ++i) {
                    if (!keys[i].equals(key)) continue;
                    return vals[i];
                }
                return null;
            }

            @Override
            protected void foreach0(Set<String> exclude, ABiConsumer<String, Object> c) {
                for (int i = 0; i < keys.length; ++i) {
                    if (!exclude.add(keys[i])) continue;
                    c.accept(keys[i], vals[i]);
                }
            }

            @Override
            protected int count0() {
                return keys.length;
            }
        };
    }

    public static LNode of(Object ... data) {
        return LNode.of2(Log.get(), data);
    }

    public static LNode of(LNode ... data) {
        return LNode.of2(Log.get(), data);
    }

    public static LNode ofMap(Map<String, ?> map) {
        return LNode.ofMap(Log.get(), map);
    }

    public static LNode of2(String[] keys, Object[] vals) {
        return LNode.of2(Log.get(), keys, vals);
    }

    public static interface AutoCloseable
    extends java.lang.AutoCloseable {
        @Override
        public void close();

        public LNode node();
    }
}

