/*
 * Decompiled with CFR 0.152.
 */
package io.aether.logger;

import io.aether.logger.LNode;
import io.aether.logger.LogFilter;
import io.aether.logger.LogPrinter;
import io.aether.logger.LogWrapper;
import io.aether.utils.AString;
import io.aether.utils.CTypeI;
import io.aether.utils.RU;
import io.aether.utils.ToString;
import io.aether.utils.interfaces.ABiConsumer;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.interfaces.AFunction;
import io.aether.utils.interfaces.APredicate;
import io.aether.utils.interfaces.ARunnable;
import io.aether.utils.interfaces.ASupplier;
import io.aether.utils.interfaces.ObjectFind;
import io.aether.utils.slots.EventConsumer;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.Date;
import java.util.Deque;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class Log {
    public static final boolean TRACE = true;
    public static final String TIME = "logTime";
    public static final String LEVEL = "logLevel";
    public static final String SYSTEM_COMPONENT = "SystemComponent";
    public static final String MSG = "logMessage";
    public static final String EXCEPTION_STR = "exception";
    public static final LogFilter filter = new LogFilter();
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("MM:dd:HH:mm:ss.SSSS");
    public static boolean ENABLED = true;
    public static final ThreadLocal<Deque<LNode>> stack = ThreadLocal.withInitial(ArrayDeque::new);
    public static final AtomicLong ID_COUNTER = new AtomicLong();
    static final AtomicReference<LogPrinter[]> consolePrinter = new AtomicReference();
    public static final EventConsumer<LNode> onEvent = new EventConsumer();

    public static void push(LNode n) {
        if (!ENABLED) {
            return;
        }
        if (n == null) {
            throw new IllegalStateException("Cannot push null LNode");
        }
        stack.get().addFirst(n);
    }

    public static LNode get() {
        if (!ENABLED) {
            return LNode.EMPTY;
        }
        Deque<LNode> q = stack.get();
        if (q == null || q.isEmpty()) {
            LNode res = new LNode(null){

                @Override
                protected Object get0(String key) {
                    return null;
                }

                @Override
                protected void foreach0(Set<String> exclude, ABiConsumer<String, Object> c) {
                }

                @Override
                protected int count0() {
                    return 0;
                }
            };
            Log.push(res);
            return res;
        }
        return q.getFirst();
    }

    public static void pop(LNode n) {
        if (!ENABLED) {
            return;
        }
        Deque<LNode> q = stack.get();
        if (q == null || q.isEmpty()) {
            throw new IllegalStateException("Pop called on empty stack, expected " + n.id);
        }
        if (q.removeFirst() != n) {
            throw new IllegalStateException("Logger stack corruption. Popped wrong node.");
        }
    }

    public static void fire(LNode node) {
        if (!ENABLED) {
            return;
        }
        if (Log.filter.predicate.test(node)) {
            onEvent.fire(node);
        }
    }

    public static AutoCloseable addListener(LogFilter filter, AConsumer<LNode> consumer) {
        AConsumer<LNode> c = n -> {
            if (filter.predicate.test((LNode)n)) {
                consumer.accept(filter.dropFields((LNode)n));
            }
        };
        onEvent.add(c);
        return () -> onEvent.remove(c);
    }

    public static void addFilterNot(APredicate<LNode> p) {
        filter.not(p);
    }

    public static void addFilter(APredicate<LNode> p) {
        filter.filter(p);
    }

    public static void log(LNode node) {
        Log.get().log(node);
    }

    public static LNode trace(ToString msg, Object ... data) {
        return Log.get().trace(msg, data);
    }

    public static LNode trace(String msg, LNode ... data) {
        return Log.get().trace(msg, data);
    }

    public static LNode trace(String msg, LNode data) {
        return Log.get().trace(msg, data);
    }

    public static LNode trace(String msg, Object ... data) {
        return Log.get().trace(msg, data);
    }

    public static LNode debug(ToString msg, Object ... data) {
        return Log.get().debug(msg, data);
    }

    public static LNode debug(String msg, Object ... data) {
        return Log.get().debug(msg, data);
    }

    public static LNode debug(String msg, LNode ... data) {
        return Log.get().debug(msg, data);
    }

    public static LNode debug(String msg, LNode data) {
        return Log.get().debug(msg, data);
    }

    public static LNode info(ToString msg, Object ... data) {
        return Log.get().info(msg, data);
    }

    public static LNode info(String msg, Object ... data) {
        return Log.get().info(msg, data);
    }

    public static LNode info(String msg, LNode ... data) {
        return Log.get().info(msg, data);
    }

    public static LNode info(String msg, LNode data) {
        return Log.get().info(msg, data);
    }

    public static LNode warn(ToString msg, Object ... data) {
        return Log.get().warn(msg, data);
    }

    public static LNode warn(String msg, Object ... data) {
        return Log.get().warn(msg, data);
    }

    public static LNode warn(String msg, LNode ... data) {
        return Log.get().warn(msg, data);
    }

    public static LNode warn(String msg, LNode data) {
        return Log.get().warn(msg, data);
    }

    public static LNode warn(String msg, Throwable throwable, Object ... data) {
        return Log.get().warn(msg, throwable, data);
    }

    public static LNode error(String msg, Throwable throwable, Object ... data) {
        return Log.get().error(msg, throwable, data);
    }

    public static LNode error(String msg, Object ... data) {
        return Log.get().error(msg, data);
    }

    public static LNode error(Throwable throwable, Object ... data) {
        return Log.get().error(throwable, data);
    }

    public static LNode of(Object ... data) {
        return Log.get().add(data);
    }

    public static LNode of(LNode data) {
        return Log.get().add(data);
    }

    public static LNode of(LNode ... data) {
        return Log.get().add(data);
    }

    public static LNode ofMap(Map<String, ?> vals) {
        return Log.get().addMap(vals);
    }

    public static LNode of2(String[] keys, Object[] vals) {
        return Log.get().add(keys, vals);
    }

    public static LNode of() {
        return Log.get();
    }

    public static LogPrinter printConsoleColored() {
        return Log.printConsoleColored(new LogFilter());
    }

    public static LogPrinter printConsoleColored(LogFilter filter) {
        LogPrinter[] ar = consolePrinter.get();
        if (ar != null) {
            return ar[0];
        }
        ar = new LogPrinter[1];
        if (consolePrinter.compareAndSet(null, ar)) {
            LogPrinter printer;
            ar[0] = printer = new LogPrinter(new LogPrinter.Column[]{LogPrinter.col(TIME, v -> DATE_FORMAT.format(new Date((long)v))), LogPrinter.splitter(" "), LogPrinter.col(LEVEL).min(5), LogPrinter.splitter("\u2502"), LogPrinter.col(SYSTEM_COMPONENT).minAuto().min(10), LogPrinter.splitter("\u2502"), LogPrinter.col(MSG, (o, n, kk) -> n.printMessage(o, kk, null, null)).min(60), LogPrinter.splitter("  "), LogPrinter.colAll()}, filter){

                @Override
                public AString printNode(AString s, LNode n) {
                    s = s.limitByteArrays(50);
                    Level level = n.getLevel();
                    if (level != null) {
                        switch (level) {
                            case TRACE: {
                                s.styleForeground(null, 150, 150, 150);
                                break;
                            }
                            case DEBUG: {
                                s.styleForeground(null, 100, 255, 100);
                                break;
                            }
                            case INFO: {
                                s.styleForeground(null, 100, 100, 255);
                                break;
                            }
                            case WARN: {
                                s.styleForeground(null, 255, 50, 50);
                                break;
                            }
                            case ERROR: {
                                s.styleForeground(null, 255, 0, 0);
                            }
                        }
                    }
                    AString res = super.printNode(s, n);
                    s.styleClear();
                    return res;
                }
            };
            return printer;
        }
        return ar[0];
    }

    public static LogPrinter printPlainConsole(LogFilter filter) {
        LogPrinter[] ar = new LogPrinter[1];
        if (consolePrinter.compareAndSet(null, ar)) {
            LogPrinter printer;
            ar[0] = printer = new LogPrinter(new LogPrinter.Column[]{LogPrinter.col(TIME, v -> DATE_FORMAT.format(new Date((long)v))), LogPrinter.splitter(" "), LogPrinter.col(LEVEL).min(5), LogPrinter.splitter("\u2502"), LogPrinter.col(SYSTEM_COMPONENT).minAuto().min(10), LogPrinter.splitter("\u2502"), LogPrinter.col(MSG, (o, n, kk) -> n.printMessage(o, kk, null, null)).min(100), LogPrinter.colAll()}, filter);
            return printer;
        }
        return ar[0];
    }

    public static Executor wrapExecutor(Executor executor) {
        if (!ENABLED) {
            return executor;
        }
        return new LogExecutor(executor);
    }

    public static ARunnable wrapRunnable(ARunnable t, Object ... data) {
        if (!ENABLED) {
            return t;
        }
        LNode l = Log.of(data);
        if (l == null || l.isEmpty()) {
            return t;
        }
        return new ARunnableWrapper(l, t);
    }

    public static <T> ASupplier<T> wrapSupplier(ASupplier<T> t) {
        if (!ENABLED) {
            return t;
        }
        LNode l = Log.get();
        return new ASupplierWrapper<T>(l, t);
    }

    public static <T> ASupplier<T> wrap(ASupplier<T> t) {
        if (!ENABLED) {
            return t;
        }
        return Log.wrapSupplier(t);
    }

    public static ARunnable wrap(ARunnable t) {
        if (!ENABLED) {
            return t;
        }
        LNode l = Log.get();
        return new ARunnableWrapper(l, t);
    }

    public static <T> AConsumer<T> wrap(AConsumer<T> t) {
        if (!ENABLED) {
            return t;
        }
        LNode l = Log.get();
        return new AConsumerWrapper<T>(l, t);
    }

    public static <T, T2> ABiConsumer<T, T2> wrap(ABiConsumer<T, T2> t) {
        if (!ENABLED) {
            return t;
        }
        LNode l = Log.get();
        return new ABiConsumerWrapper<T, T2>(l, t);
    }

    public static <T, R> AFunction<T, R> wrap(AFunction<T, R> t) {
        if (!ENABLED) {
            return t;
        }
        LNode l = Log.get();
        return new AFunctionWrapper<T, R>(l, t);
    }

    public static void loggerOff() {
        ENABLED = false;
    }

    public static void loggerOn() {
        ENABLED = true;
    }

    private static class ASupplierWrapper<T>
    implements ASupplier<T>,
    LogWrapper {
        private final LNode l;
        private final ASupplier<T> t;

        public ASupplierWrapper(LNode l, ASupplier<T> t) {
            this.l = l;
            this.t = t;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ASupplierWrapper) {
                return this.t.equals(((ASupplierWrapper)obj).t);
            }
            return obj.equals(this.t);
        }

        public int hashCode() {
            return this.t.hashCode();
        }

        @Override
        public T get2() throws Exception {
            Log.push(this.l);
            try {
                T t = this.t.get();
                return t;
            }
            finally {
                Log.pop(this.l);
            }
        }
    }

    private static class ARunnableWrapper
    implements ARunnable,
    LogWrapper {
        private final LNode l;
        private final ARunnable t;

        public ARunnableWrapper(LNode l, ARunnable t) {
            this.l = l;
            this.t = t;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ARunnableWrapper) {
                return this.t.equals(((ARunnableWrapper)obj).t);
            }
            return obj.equals(this.t);
        }

        public int hashCode() {
            return this.t.hashCode();
        }

        @Override
        public void run2() throws Throwable {
            Log.push(this.l);
            try {
                this.t.run();
            }
            finally {
                Log.pop(this.l);
            }
        }
    }

    private static class AFunctionWrapper<T, R>
    implements AFunction<T, R>,
    LogWrapper {
        private final LNode l;
        private final AFunction<T, R> t;

        public AFunctionWrapper(LNode l, AFunction<T, R> t) {
            this.l = l;
            this.t = t;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof AFunctionWrapper) {
                return this.t.equals(((AFunctionWrapper)obj).t);
            }
            return obj.equals(this.t);
        }

        public int hashCode() {
            return this.t.hashCode();
        }

        @Override
        public R apply2(T v) throws Throwable {
            Log.push(this.l);
            try {
                R r = this.t.apply(v);
                return r;
            }
            finally {
                Log.pop(this.l);
            }
        }
    }

    private static class ABiConsumerWrapper<T, T2>
    implements ABiConsumer<T, T2>,
    LogWrapper {
        private final LNode l;
        private final ABiConsumer<T, T2> t;

        public ABiConsumerWrapper(LNode l, ABiConsumer<T, T2> t) {
            this.l = l;
            this.t = t;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ABiConsumerWrapper) {
                return this.t.equals(((ABiConsumerWrapper)obj).t);
            }
            return obj.equals(this.t);
        }

        public int hashCode() {
            return this.t.hashCode();
        }

        @Override
        public void accept2(T v, T2 v2) throws Throwable {
            Log.push(this.l);
            try {
                this.t.accept(v, v2);
            }
            finally {
                Log.pop(this.l);
            }
        }
    }

    private static class AConsumerWrapper<T>
    implements AConsumer<T>,
    LogWrapper {
        private final LNode l;
        private final AConsumer<T> t;

        public AConsumerWrapper(LNode l, AConsumer<T> t) {
            this.l = l;
            this.t = t;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof AConsumerWrapper) {
                return this.t.equals(((AConsumerWrapper)obj).t);
            }
            return obj.equals(this.t);
        }

        public int hashCode() {
            return this.t.hashCode();
        }

        @Override
        public void accept2(T v) throws Throwable {
            Log.push(this.l);
            try {
                this.t.accept(v);
            }
            finally {
                Log.pop(this.l);
            }
        }
    }

    private static class LogExecutor
    implements Executor,
    ObjectFind {
        private final Executor executor;

        public LogExecutor(Executor executor) {
            this.executor = executor;
        }

        @Override
        public <T> T find(Class<T> type) {
            if (type.isInstance(this)) {
                return RU.cast(this);
            }
            if (type.isInstance(this.executor)) {
                return type.cast(this.executor);
            }
            if (this.executor instanceof ObjectFind) {
                return ((ObjectFind)((Object)this.executor)).find(type);
            }
            return null;
        }

        @Override
        public <T> T find(CTypeI<T> type) {
            if (type.isInstance(this)) {
                return RU.cast(this);
            }
            if (type.isInstance(this.executor)) {
                return type.cast(this.executor);
            }
            if (this.executor instanceof ObjectFind) {
                return ((ObjectFind)((Object)this.executor)).find(type);
            }
            return null;
        }

        @Override
        public void execute(Runnable command) {
            LNode nn = Log.get();
            this.executor.execute(() -> {
                Log.push(nn);
                try {
                    command.run();
                }
                catch (Throwable e) {
                    Log.error(e, new Object[0]);
                }
                finally {
                    Log.pop(nn);
                }
            });
        }
    }

    public static interface LogAutoClose
    extends AutoCloseable {
        public static final LogAutoClose EMPTY = () -> {};

        @Override
        public void close();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Tag {
        public String value();
    }

    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

