/*
 * Decompiled with CFR 0.152.
 */
package io.aether.logger;

import io.aether.logger.LNode;
import io.aether.logger.Log;
import io.aether.utils.CTypeI;
import io.aether.utils.interfaces.A3Predicate;
import io.aether.utils.interfaces.ABiConsumer;
import io.aether.utils.interfaces.APredicate;
import java.lang.invoke.VarHandle;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class LogFilter {
    private static final VarHandle DROP_UPDATER = CTypeI.of(LogFilter.class).getFieldVarHandle("dropFields");
    private static final VarHandle PRED_UPDATER = CTypeI.of(LogFilter.class).getFieldVarHandle("predicate");
    volatile A3Predicate<LNode, String, Object> dropFields = A3Predicate.FALSE_STUB();
    volatile APredicate<LNode> predicate = APredicate.TRUE_STUB();

    public LNode dropFields(final LNode node) {
        if (this.dropFields == A3Predicate.TRUE_STUB()) {
            return node;
        }
        return new LNode(node){

            @Override
            protected Object get0(String key) {
                return null;
            }

            @Override
            protected void foreach0(Set<String> exclude, ABiConsumer<String, Object> c) {
            }

            public Object get(String key, Set<LNode> old) {
                if (old.add(node)) {
                    Object v = node.get(key);
                    if (LogFilter.this.dropFields.test2(node, key, v)) {
                        return null;
                    }
                    return v;
                }
                return null;
            }

            @Override
            public void foreach(Set<String> exclude, ABiConsumer<String, Object> c) {
                super.foreach(exclude, (k, v) -> {
                    if (LogFilter.this.dropFields.test(node, (String)k, v)) {
                        return;
                    }
                    c.accept((String)k, v);
                });
            }

            @Override
            protected int count0() {
                return 0;
            }
        };
    }

    public void drop(final A3Predicate<LNode, String, Object> p) {
        A3Predicate<LNode, String, Object> o;
        while (!DROP_UPDATER.compareAndSet(this, o = this.dropFields, new A3Predicate<LNode, String, Object>(){

            @Override
            public boolean test2(LNode value1, String value2, Object value3) {
                try {
                    if (o.test(value1, value2, value3)) {
                        return true;
                    }
                }
                catch (Exception e) {
                    Log.error(e, new Object[0]);
                }
                try {
                    if (p.test(value1, value2, value3)) {
                        return true;
                    }
                }
                catch (Exception e) {
                    Log.error(e, new Object[0]);
                }
                return false;
            }
        })) {
        }
    }

    public void not(String text) {
        this.not((LNode n) -> n.toString().contains(text));
    }

    public void filter(String text) {
        this.filter((LNode n) -> n.toString().contains(text));
    }

    public void not(APredicate<LNode> predicate) {
        this.filter((LNode n) -> !predicate.test((LNode)n));
    }

    public void reset() {
        this.predicate = APredicate.TRUE_STUB();
    }

    public void filterRegex(String expr) {
        Predicate<String> p = Pattern.compile(expr).asMatchPredicate();
        this.filter((LNode n) -> p.test(n.toString()));
    }

    public void notRegex(String expr) {
        Predicate<String> p = Pattern.compile(expr).asMatchPredicate();
        this.not((LNode n) -> p.test(n.toString()));
    }

    void debugOff() {
        this.not((LNode n) -> n.check("logLevel", (Object)Log.Level.DEBUG));
    }

    void traceOff() {
        this.not((LNode n) -> n.check("logLevel", (Object)Log.Level.TRACE));
    }

    void infoOff() {
        this.not((LNode n) -> n.check("logLevel", (Object)Log.Level.INFO));
    }

    void warnOff() {
        this.not((LNode n) -> n.check("logLevel", (Object)Log.Level.WARN));
    }

    void errorOff() {
        this.not((LNode n) -> n.check("logLevel", (Object)Log.Level.ERROR));
    }

    public void filter(final APredicate<LNode> predicate) {
        APredicate<LNode> old;
        while (!PRED_UPDATER.compareAndSet(this, old = this.predicate, new APredicate<LNode>(){
            Exception errorFlag;

            @Override
            public boolean test2(LNode n) {
                if (this.errorFlag != null) {
                    return true;
                }
                try {
                    if (!old.test(n)) {
                        return false;
                    }
                }
                catch (Exception e) {
                    if (this.errorFlag == null) {
                        this.errorFlag = e;
                        Log.error("logger filter exception", e, new Object[0]);
                    }
                    this.errorFlag = e;
                }
                try {
                    if (!predicate.test(n)) {
                        return false;
                    }
                }
                catch (Exception e) {
                    if (this.errorFlag == null) {
                        this.errorFlag = e;
                        Log.warn("logger filter exception", e, new Object[0]);
                    }
                    this.errorFlag = e;
                }
                return true;
            }
        })) {
        }
    }
}

