/*
 * Decompiled with CFR 0.152.
 */
package io.aether.logger;

import io.aether.logger.LNode;
import io.aether.logger.Log;
import io.aether.logger.LogFilter;
import io.aether.utils.AString;
import io.aether.utils.RU;
import io.aether.utils.interfaces.ABiConsumer;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.interfaces.AFunction;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;

public class LogPrinter
implements AutoCloseable {
    public final LogFilter filter;
    final Column[] columns;
    final Set<String> keys;
    final AutoCloseable closeable;

    public LogPrinter(Column[] columns) {
        this(columns, new LogFilter());
    }

    public LogPrinter(Column[] columns, LogFilter filter) {
        this.columns = columns;
        this.filter = filter;
        this.keys = new ObjectOpenHashSet();
        for (Column c : columns) {
            this.keys.add(c.getKey());
        }
        this.closeable = Log.addListener(filter, n -> this.printRow(AString.of(), (LNode)n));
    }

    public void printRow(AString s, LNode n) {
        String ss = this.printNode(s, n).toString();
        System.out.println(ss);
    }

    @Override
    public void close() {
        try {
            this.closeable.close();
        }
        catch (Exception e) {
            RU.error(e);
        }
    }

    public AString printNode(AString s, LNode n) {
        ObjectOpenHashSet kk = new ObjectOpenHashSet();
        for (Column c : this.columns) {
            c.print(this, s, n, (Set<String>)kk);
        }
        if (n.isError()) {
            s.add("\n");
            Throwable e = n.getException();
            if (e != null) {
                e.printStackTrace(s.toPrintWriter());
            }
        }
        return s;
    }

    public static Column col(final String key, final ColumnPrinter printer) {
        return new Column(){

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public void print(LogPrinter p, AString out, LNode value, Set<String> workKeys) {
                printer.print(out, value, workKeys);
                workKeys.add(key);
            }
        };
    }

    public static Column col(final String key, final ColumnPrinter2 printer) {
        return new Column(){

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public void print(LogPrinter p, AString out, LNode value, Set<String> workKeys) {
                printer.print(out, value);
                workKeys.add(key);
            }
        };
    }

    public static Column col(String key) {
        return Column.of(key);
    }

    public static Column splitter(final String text) {
        return new Column(){

            @Override
            public void print(LogPrinter printer, AString out, LNode value, Set<String> workKeys) {
                out.add(text);
            }

            @Override
            public String getKey() {
                return null;
            }
        };
    }

    public static <T> Column col(String key, AFunction<T, Object> mapper) {
        return Column.of(key, mapper);
    }

    public static Column colAll() {
        return new Column(){

            @Override
            public void print(LogPrinter printer, final AString out, LNode value, Set<String> workKeys) {
                out.add('{');
                value.foreach(workKeys, new ABiConsumer<String, Object>(){
                    boolean first = true;

                    @Override
                    public void accept2(String k, Object v) throws Throwable {
                        if (this.first) {
                            this.first = false;
                        } else {
                            out.add(", ");
                        }
                        out.add(k);
                        out.add('=');
                        if (v instanceof String) {
                            out.add('\"').add((String)v).add('\"');
                        } else {
                            out.add(v);
                        }
                    }
                });
                out.add('}');
            }

            @Override
            public String getKey() {
                return null;
            }
        };
    }

    public static interface Column {
        public void print(LogPrinter var1, AString var2, LNode var3, Set<String> var4);

        public String getKey();

        default public Column quote(final AConsumer<AString> begin, final AConsumer<AString> end) {
            final Column self = this;
            return new Column(){

                @Override
                public void print(LogPrinter printer, AString out, LNode value, Set<String> workKeys) {
                    begin.accept(out);
                    self.print(printer, out, value, workKeys);
                    end.accept(out);
                }

                @Override
                public String getKey() {
                    return self.getKey();
                }
            };
        }

        default public Column max(final int i) {
            final Column self = this;
            return new Column(){

                @Override
                public String getKey() {
                    return self.getKey();
                }

                @Override
                public void print(LogPrinter printer, AString out, LNode value, Set<String> workKeys) {
                    self.print(printer, out.limit(i), value, workKeys);
                }
            };
        }

        default public Column foregroundColorRGB(final int r, final int g, final int b) {
            final Column self = this;
            return new Column(){

                @Override
                public String getKey() {
                    return self.getKey();
                }

                @Override
                public void print(LogPrinter printer, AString out, LNode value, Set<String> workKeys) {
                    out.styleForeground(null, r, g, b);
                    self.print(printer, out, value, workKeys);
                    out.styleClear();
                }
            };
        }

        default public Column backgroundColorRGB(final int r, final int g, final int b) {
            final Column self = this;
            return new Column(){

                @Override
                public String getKey() {
                    return self.getKey();
                }

                @Override
                public void print(LogPrinter printer, AString out, LNode value, Set<String> workKeys) {
                    out.styleBackground(null, r, g, b);
                    self.print(printer, out, value, workKeys);
                    out.styleClear();
                }
            };
        }

        default public Column style(final AString.Style style, final AString.Color color) {
            final Column self = this;
            return new Column(){

                @Override
                public String getKey() {
                    return self.getKey();
                }

                @Override
                public void print(LogPrinter printer, AString out, LNode value, Set<String> workKeys) {
                    out.style(style, color);
                    self.print(printer, out, value, workKeys);
                    out.styleClear();
                }
            };
        }

        default public Column minAuto() {
            final Column self = this;
            return new Column(){
                int min = 0;

                @Override
                public String getKey() {
                    return self.getKey();
                }

                @Override
                public void print(LogPrinter printer, AString out, LNode value, Set<String> workKeys) {
                    int l = out.length();
                    self.print(printer, out, value, workKeys);
                    int l2 = out.length();
                    int d = l2 - l;
                    if (this.min <= d) {
                        this.min = d;
                    } else {
                        for (int i = 0; i < this.min - d; ++i) {
                            out.add(' ');
                        }
                    }
                }
            };
        }

        default public Column min(final int i) {
            final Column self = this;
            return new Column(){

                @Override
                public String getKey() {
                    return self.getKey();
                }

                @Override
                public void print(LogPrinter printer, AString out, LNode value, Set<String> workKeys) {
                    int l = out.length();
                    self.print(printer, out, value, workKeys);
                    int l2 = out.length();
                    int d = l2 - l;
                    if (d < i) {
                        for (int ii = 0; ii < i - d; ++ii) {
                            out.add(" ");
                        }
                    }
                }
            };
        }

        public static <T> Column of(final String key, final AFunction<T, Object> mapper) {
            return new Column(){

                @Override
                public void print(LogPrinter printer, AString out, LNode value, Set<String> workKeys) {
                    out.add(mapper.apply(RU.cast(value.get(key))));
                    workKeys.add(key);
                }

                @Override
                public String getKey() {
                    return key;
                }
            };
        }

        public static Column of(final String key) {
            return new Column(){

                @Override
                public void print(LogPrinter printer, AString out, LNode node, Set<String> workKeys) {
                    Object v = node.get(key);
                    if (v != null) {
                        out.add(v);
                    }
                    workKeys.add(key);
                }

                @Override
                public String getKey() {
                    return key;
                }
            };
        }
    }

    public static interface ColumnPrinter2 {
        public void print(AString var1, LNode var2);
    }

    public static interface ColumnPrinter {
        public void print(AString var1, LNode var2, Set<String> var3);
    }
}

