/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils;

import io.aether.utils.RU;
import io.aether.utils.WeakCollection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public final class AutoRun {
    public static final Map<Executor, WeakCollection<Task>> ALL = new ConcurrentHashMap<Executor, WeakCollection<Task>>();

    public static void add(Executor executor, Task task) {
        ALL.computeIfAbsent(executor, k -> new WeakCollection()).add(task);
    }

    static {
        AtomicBoolean flag = new AtomicBoolean();
        RU.scheduleAtFixedRate(10L, () -> {
            if (!flag.compareAndSet(false, true)) {
                return;
            }
            for (Map.Entry<Executor, WeakCollection<Task>> e : ALL.entrySet()) {
                WeakCollection<Task> tt = e.getValue();
                e.getKey().execute(() -> {
                    long currentTime = System.currentTimeMillis();
                    for (Task t : tt) {
                        t.runAutoRunTask(currentTime);
                    }
                });
            }
            flag.set(false);
        });
    }

    public static final class Multi
    implements io.aether.utils.AutoRun$Task {
        private final CopyOnWriteArrayList<Task> subTasks = new CopyOnWriteArrayList();
        private long totalLastWork = Long.MAX_VALUE;
        private long minTimeout;

        public Multi(Executor executor) {
            long mint = Long.MAX_VALUE;
            for (Task s : this.subTasks) {
                mint = Math.min(mint, s.timeout);
            }
            this.minTimeout = mint;
            AutoRun.add(executor, this);
        }

        public void addTask(Task task) {
            this.subTasks.add(task);
        }

        private void updateMinTimeout(long t) {
            this.minTimeout = Math.min(this.minTimeout, t);
        }

        public void free() {
            if (this.totalLastWork == Long.MAX_VALUE) {
                return;
            }
            for (Task s : this.subTasks) {
                s.free();
            }
            this.totalLastWork = Long.MAX_VALUE;
        }

        @Override
        public final void runAutoRunTask(long currentTime) {
            if (currentTime - this.totalLastWork > this.minTimeout) {
                this.totalLastWork = Long.MAX_VALUE;
                for (Task s2 : this.subTasks) {
                    s2.runAutoRunTask(currentTime);
                    this.totalLastWork = Math.min(s2.lastWork, this.totalLastWork);
                }
            }
        }

        public static abstract class Task {
            private final Multi multi;
            private long lastWork = Long.MAX_VALUE;
            private long timeout = 4L;

            public Task(Multi multi) {
                this.multi = multi;
                multi.addTask(this);
            }

            public abstract void work();

            public void free() {
                this.lastWork = Long.MAX_VALUE;
            }

            public void needWork() {
                if (RU.time() - this.lastWork > this.timeout) {
                    this.lastWork = Long.MAX_VALUE;
                    this.work();
                } else if (this.lastWork == Long.MAX_VALUE) {
                    this.refreshNeedWork();
                }
            }

            public void refreshNeedWork() {
                this.lastWork = System.currentTimeMillis();
                if (this.multi.totalLastWork == Long.MAX_VALUE) {
                    this.multi.totalLastWork = this.lastWork;
                }
            }

            public void setTimeout(long timeout) {
                this.timeout = timeout;
                this.multi.updateMinTimeout(timeout);
            }

            private void runAutoRunTask(long currentTime) {
                long old = this.lastWork;
                if (currentTime - old > this.timeout) {
                    this.work();
                    if (this.lastWork == old) {
                        this.lastWork = Long.MAX_VALUE;
                    }
                }
            }
        }
    }

    public static abstract class TaskImpl
    implements Task {
        public long lastWork = Long.MAX_VALUE;
        public long timeout = 4L;

        public TaskImpl(Executor executor) {
            AutoRun.add(executor, this);
        }

        public void setTimeout(long timeout) {
            this.timeout = timeout;
        }

        public abstract void work();

        public void free() {
            this.lastWork = Long.MAX_VALUE;
        }

        public void needWork() {
            this.lastWork = System.currentTimeMillis();
        }

        @Override
        public void runAutoRunTask(long currentTime) {
            if (currentTime - this.lastWork > this.timeout) {
                long old = this.lastWork;
                if (System.currentTimeMillis() - old > this.timeout) {
                    this.work();
                    if (this.lastWork == old) {
                        this.lastWork = 0L;
                    }
                }
            }
        }
    }

    public static interface Task {
        public void runAutoRunTask(long var1);
    }
}

