/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils;

import org.jetbrains.annotations.NotNull;

public class CharSequenceByArray
implements CharSequence {
    public final char[] data;
    public final int begin;
    public final int end;

    public CharSequenceByArray(char[] data) {
        this(data, 0, data.length);
    }

    public CharSequenceByArray(char[] data, int begin, int end) {
        this.data = data;
        this.begin = begin;
        this.end = end;
    }

    @Override
    public int length() {
        return this.end - this.begin;
    }

    @Override
    public char charAt(int index) {
        return this.data[this.begin + index];
    }

    @Override
    public String toString() {
        return new String(this.data, this.begin, this.end - this.begin);
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        assert (end < this.data.length - this.begin);
        return new CharSequenceByArray(this.data, this.begin + start, this.begin + end);
    }
}

