/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils;

import io.aether.logger.Log;
import io.aether.utils.futures.AFuture;
import io.aether.utils.interfaces.Destroyable;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class Destroyer
implements Destroyable {
    public final String name;
    private final Queue<Destroyable> queue = new ConcurrentLinkedQueue<Destroyable>();
    volatile AtomicReference<AFuture> destroyFuture = new AtomicReference();

    public Destroyer(String name) {
        this.name = name;
    }

    public boolean isDestroyed() {
        return this.destroyFuture.get() != null;
    }

    public String toString() {
        return this.name;
    }

    public void add(Destroyable destroyable) {
        this.queue.add(destroyable);
    }

    public void add(ScheduledFuture<?> os) {
        this.add(new ScheduledFutureDestroyable(os));
    }

    public void add(AutoCloseable os) {
        this.add(new AutoCloseableDestroyable(os));
    }

    public void remove(Destroyable destroyable) {
        this.queue.remove(destroyable);
    }

    public void remove(ScheduledFuture<?> os) {
        Iterator it = this.queue.iterator();
        while (it.hasNext()) {
            Destroyable d = (Destroyable)it.next();
            if (!(d instanceof ScheduledFutureDestroyable) || !((ScheduledFutureDestroyable)d).future.equals(os)) continue;
            it.remove();
            return;
        }
    }

    public void remove(AutoCloseable os) {
        Iterator it = this.queue.iterator();
        while (it.hasNext()) {
            Destroyable d = (Destroyable)it.next();
            if (!(d instanceof AutoCloseableDestroyable) || !((AutoCloseableDestroyable)d).closeable.equals(os)) continue;
            it.remove();
            return;
        }
    }

    @Override
    public AFuture destroy(boolean force) {
        Destroyable e;
        AFuture res = AFuture.make();
        if (!this.destroyFuture.compareAndSet(null, res)) {
            return this.destroyFuture.get();
        }
        AtomicInteger counter = new AtomicInteger();
        while ((e = this.queue.poll()) != null) {
            counter.incrementAndGet();
            try {
                ((AFuture)e.destroy(force).to(() -> {
                    if (counter.decrementAndGet() == 0) {
                        res.tryDone();
                    }
                })).timeout(9, () -> Log.warn("Timeout destroy: $unit", "unit", e));
            }
            catch (Exception ex) {
                Log.warn("destroy exception", ex, new Object[0]);
                if (counter.decrementAndGet() != 0) continue;
                res.tryDone();
            }
        }
        if (counter.get() == 0) {
            res.tryDone();
        }
        res.timeout(9, () -> Log.warn("Timeout destroy all: $unit", "unit", this));
        return res;
    }

    private static class AutoCloseableDestroyable
    implements Destroyable {
        final AutoCloseable closeable;

        public AutoCloseableDestroyable(AutoCloseable closeable) {
            this.closeable = closeable;
        }

        public String toString() {
            return this.closeable.toString();
        }

        @Override
        public AFuture destroy(boolean force) {
            if (force) {
                try {
                    this.closeable.close();
                }
                catch (Exception e) {
                    Log.warn("destroy exception", e, new Object[0]);
                }
                return AFuture.completed();
            }
            try {
                this.closeable.close();
                return AFuture.completed();
            }
            catch (Exception e) {
                return AFuture.doThrow(e);
            }
        }
    }

    private static class ScheduledFutureDestroyable
    implements Destroyable {
        final ScheduledFuture<?> future;

        public ScheduledFutureDestroyable(ScheduledFuture<?> future) {
            this.future = future;
        }

        public String toString() {
            return this.future.toString();
        }

        @Override
        public AFuture destroy(boolean force) {
            this.future.cancel(force);
            return AFuture.completed();
        }
    }
}

