/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils;

import io.aether.logger.LNode;
import io.aether.logger.Log;
import io.aether.utils.CTypeI;
import io.aether.utils.RU;
import io.aether.utils.interfaces.AConsumer;
import java.lang.invoke.VarHandle;

public abstract class TaskConsumer<T>
implements AConsumer<T> {
    private static final VarHandle OFFSET_FLAG = CTypeI.of(TaskConsumer.class).getFieldVarHandle("flag");
    private final LNode logContext = Log.of();
    private volatile boolean flag;

    @Override
    public void accept(T t) {
        this.accept2(t);
    }

    public boolean isExecuted() {
        return this.flag;
    }

    @Override
    public final void accept2(T v) {
        if (OFFSET_FLAG.compareAndSet(this, false, true)) {
            Log.push(this.logContext);
            try {
                this.runTask(v);
            }
            catch (Throwable e) {
                RU.error(e);
            }
            finally {
                Log.pop(this.logContext);
            }
        }
    }

    public final void cancel() {
        if (OFFSET_FLAG.compareAndSet(this, false, true)) {
            Log.push(this.logContext);
            try {
                this.cancelTask();
            }
            catch (Throwable e) {
                RU.error(e);
            }
            finally {
                Log.pop(this.logContext);
            }
        }
    }

    protected abstract void runTask(T var1);

    protected void cancelTask() {
    }
}

