/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.dataio;

import io.aether.utils.HexUtils;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataInOut;
import io.aether.utils.dataio.DataInOutStatic;

public interface DataOut {
    default public void write(byte[] b) {
        int r = this.write(b, 0, b.length);
        if (!1.$assertionsDisabled && r != b.length) {
            throw new AssertionError();
        }
    }

    default public void write(int[] b) {
        int r = this.write(b, 0, b.length);
        if (!1.$assertionsDisabled && r != b.length) {
            throw new AssertionError();
        }
    }

    default public int write(byte[] b, int off, int len) {
        for (int i = off; i < off + len; ++i) {
            if (!this.isWritable()) {
                return i - off;
            }
            this.writeByte(b[i]);
        }
        return len;
    }

    default public int write(int[] b, int off, int len) {
        for (int i = off; i < off + len; ++i) {
            if (this.getSizeForWrite() < 4) {
                return i - off;
            }
            this.writeInt(b[i]);
        }
        return len;
    }

    default public void clear() {
    }

    default public void writeBoolean(boolean v) {
        this.writeByte(v ? 1 : 0);
    }

    public void writeByte(int var1);

    default public void writeShort(int v) {
        this.writeShort((short)v);
    }

    default public void writeShort(short v) {
        this.writeByte((byte)v);
        this.writeByte((byte)(v >>> 8));
    }

    default public void writeChar(char v) {
        this.writeByte((byte)v);
    }

    default public void writeInt(int v) {
        this.writeShort((short)v);
        this.writeShort((short)(v >>> 16));
    }

    default public void writeLong(long v) {
        this.writeInt((int)v);
        this.writeInt((int)(v >>> 32));
    }

    default public void writeFloat(float v) {
        this.writeInt(Float.floatToIntBits(v));
    }

    default public void writeDouble(double v) {
        this.writeLong(Double.doubleToLongBits(v));
    }

    default public boolean isWritable() {
        return true;
    }

    default public int getSizeForWrite() {
        return Integer.MAX_VALUE;
    }

    default public void writeHexBytes(String hex) {
        this.write(HexUtils.hexToBytes(hex));
    }

    default public void write(DataInOut data) {
        int r = this.write(data.data, data.readPos, data.writePos);
        if (!1.$assertionsDisabled && r != data.getSizeForRead()) {
            throw new AssertionError();
        }
        data.readPos = 0;
        data.writePos = 0;
    }

    default public void write(DataInOutStatic data) {
        int r = this.write(data.data, data.readPos, data.writePos);
        if (!1.$assertionsDisabled && r != data.getSizeForRead()) {
            throw new AssertionError();
        }
        data.readPos = 0;
        data.writePos = 0;
    }

    default public void write(DataIn data) {
        this.write(data.toArray());
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

