/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.flow;

import io.aether.utils.AString;
import io.aether.utils.RU;
import io.aether.utils.flow.FlowBoolean;
import io.aether.utils.flow.FlowByte;
import io.aether.utils.flow.FlowCompleted;
import io.aether.utils.flow.FlowCompletedInt;
import io.aether.utils.flow.FlowInt;
import io.aether.utils.flow.FlowLong;
import io.aether.utils.flow.FlowShort;
import io.aether.utils.interfaces.ABiConsumer;
import io.aether.utils.interfaces.ABiPredicate;
import io.aether.utils.interfaces.AComparator;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.interfaces.AFunction;
import io.aether.utils.interfaces.AFunctionO2Array;
import io.aether.utils.interfaces.AFunctionO2Bool;
import io.aether.utils.interfaces.AFunctionO2I;
import io.aether.utils.interfaces.AFunctionO2Iterable;
import io.aether.utils.interfaces.AFunctionO2Iterator;
import io.aether.utils.interfaces.AFunctionO2L;
import io.aether.utils.interfaces.AFunctionO2S;
import io.aether.utils.interfaces.AFunctionO2Stream;
import io.aether.utils.interfaces.APredicate;
import io.aether.utils.interfaces.ARunnable;
import io.aether.utils.interfaces.ASupplier;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Flow<T>
extends Iterator<T>,
Iterable<T> {
    public static final Random RANDOM = new Random();
    public static final Flow<?> EMPTY = new FlowCompleted<Object>(){

        @Override
        public int count() {
            return 0;
        }

        @Override
        public Object random() {
            return null;
        }

        @Override
        @NotNull
        public List<Object> toList() {
            return new ObjectArrayList(0);
        }

        @Override
        @NotNull
        public Set<Object> toSet() {
            return ObjectSet.of();
        }

        @Override
        public String join() {
            return "";
        }

        @Override
        public void to(AConsumer<Object> consumer) {
        }

        @Override
        @NotNull
        public <K, V> Map<K, V> toMap(AFunction<Object, K> keyFactory, AFunction<Object, V> valFactory) {
            return Object2ObjectMaps.emptyMap();
        }

        @Override
        @NotNull
        public Object[] toArray(@NotNull Class<? super Object> arrayType) {
            return (Object[])RU.cast(Array.newInstance(arrayType, 0));
        }

        @Override
        @NotNull
        public Object[] toArray() {
            return new Object[0];
        }

        @Override
        @NotNull
        public Iterator<Object> iterator() {
            return (Iterator)RU.cast(ObjectIterators.EMPTY_ITERATOR);
        }

        @Override
        public boolean anyMatch(APredicate<Object> p) {
            return false;
        }

        @Override
        public boolean noneMatch(APredicate<Object> p) {
            return true;
        }

        @Override
        public boolean noneMatchObj(Object p) {
            return true;
        }

        @Override
        public boolean anyMatchObj(Object p) {
            return false;
        }

        @Override
        public Flow<Object> skip(int count) {
            return this;
        }

        @Override
        public Flow<Object> limit(int i) {
            return this;
        }

        @Override
        public Object getFirstOrNull(APredicate<Object> p) {
            return null;
        }

        @Override
        public void run() {
        }

        @Override
        public Flow<Object> ifError(AFunction<Throwable, Object> f) {
            return this;
        }

        @Override
        public String joinD() {
            return "";
        }

        @Override
        public String joinN() {
            return "";
        }

        @Override
        public Flow<Object> reverse() {
            return this;
        }

        @Override
        @NotNull
        public Flow<Object> filterNotNull() {
            return this;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void forEach(Consumer<? super Object> action) {
        }

        @Override
        public void forEachRemaining(Consumer<? super Object> action) {
        }

        @Override
        public boolean allMatch(APredicate<Object> p) {
            return true;
        }

        @Override
        @NotNull
        public <E> Flow<E> map(@NotNull AFunction<Object, E> f) {
            return this;
        }

        @Override
        @NotNull
        public Flow<Object> apply(AConsumer<Object> c) {
            return this;
        }

        @Override
        public Flow<Object> addAllEls(Object ... values) {
            return Flow.flow(values);
        }

        @Override
        @NotNull
        public <E> Flow<E> flatMap1(@NotNull AFunctionO2Iterable<Object, E> f) {
            return this;
        }

        @Override
        @NotNull
        public <E> Flow<E> flatMap2(@NotNull AFunctionO2Array<Object, E> f) {
            return this;
        }

        @Override
        public void foreach(AConsumer<Object> c) {
        }

        @Override
        @NotNull
        public <E> Flow<E> flatMap3(@NotNull AFunctionO2Stream<Object, E> f) {
            return this;
        }

        @Override
        @NotNull
        public <E> Flow<E> flatMap4(@NotNull AFunctionO2Iterator<Object, E> f) {
            return this;
        }

        @Override
        @NotNull
        public <E> Flow<E> flatMap(@NotNull ABiConsumer<Object, AConsumer<E>> f) {
            return this;
        }

        @Override
        public <E extends Collection<Object>> E toCollection(@NotNull E collection) {
            return collection;
        }

        @Override
        @NotNull
        public Flow<Object> filter(@Nullable APredicate<Object> predicate) {
            return this;
        }

        @Override
        @NotNull
        public Flow<Object> filterNot(@Nullable APredicate<Object> predicate) {
            return this;
        }

        @Override
        @NotNull
        public <E> Flow<E> filterByType(@NotNull Class<E> type) {
            return this;
        }

        @Override
        @NotNull
        public Flow<Object> ifEmpty(Exception error) {
            RU.error(error);
            throw new RuntimeException(error);
        }

        @Override
        @NotNull
        public Flow<Object> ifEmpty(ARunnable task) {
            task.run();
            return this;
        }

        @Override
        @NotNull
        public Flow<Object> ignoreError(Class<? extends Exception> ee) {
            return this;
        }

        @Override
        @NotNull
        public Flow<Object> sort(@NotNull AComparator<Object> comparator) {
            return this;
        }

        @Override
        @NotNull
        public Flow<Object> sort(@NotNull Comparator<Object> comparator) {
            return this;
        }

        @Override
        @NotNull
        public Iterable<Object> toIterable() {
            return ObjectList.of();
        }

        @Override
        @NotNull
        public Supplier<Object> toSupplier() {
            return () -> null;
        }

        @Override
        @NotNull
        public <V> Int2ObjectMap<V> toMapI2O(AFunctionO2I<Object> keyFactory, AFunction<Object, V> valFactory) {
            return Int2ObjectMaps.emptyMap();
        }

        @Override
        @NotNull
        public <K> Object2IntMap<K> toMapO2I(AFunction<Object, K> keyFactory, AFunctionO2I<Object> valFactory) {
            return Object2IntMaps.emptyMap();
        }

        @Override
        @NotNull
        public <V> Long2ObjectMap<V> toMapL2O(AFunctionO2L<Object> keyFactory, AFunction<Object, V> valFactory) {
            return Long2ObjectMaps.emptyMap();
        }

        @Override
        public Flow<Object> distinct() {
            return this;
        }

        @Override
        public String join(String delimer) {
            return "";
        }

        @Override
        public String join(AFunction<Object, Object> preparer, String delimer) {
            return "";
        }

        @Override
        public Object getFirstOrNull() {
            return null;
        }

        @Override
        public Object getFirst() {
            throw new NoSuchElementException();
        }

        @Override
        public Object getFirst(APredicate<Object> p) {
            throw new NoSuchElementException();
        }

        @Override
        public String join(String delim, String prefix, String postfix) {
            return "";
        }

        @Override
        public void crossSelf(ABiConsumer<Object, Object> consumer) {
        }

        @Override
        public void crossSelf(ABiPredicate<Object, Object> p, ABiConsumer<Object, Object> consumer) {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            return null;
        }
    };

    @Override
    @NotNull
    default public Iterator<T> iterator() {
        return this;
    }

    default public boolean anyMatch(APredicate<T> p) {
        while (this.hasNext()) {
            if (!p.test(this.next())) continue;
            return true;
        }
        return false;
    }

    default public boolean noneMatch(APredicate<T> p) {
        while (this.hasNext()) {
            if (!p.test(this.next())) continue;
            return false;
        }
        return true;
    }

    default public Flow<T> add(final T value) {
        final Flow oit = this;
        return new Flow<T>(){
            boolean parent = true;
            private boolean flag = true;

            @Override
            public boolean hasNext() {
                if (this.parent && oit.hasNext()) {
                    return true;
                }
                this.parent = false;
                return this.flag;
            }

            @Override
            public T next() {
                if (this.parent) {
                    return oit.next();
                }
                this.flag = false;
                return value;
            }
        };
    }

    default public boolean noneMatchObj(Object p) {
        while (this.hasNext()) {
            if (!Objects.equals(p, this.next())) continue;
            return false;
        }
        return true;
    }

    default public boolean anyMatchObj(T p) {
        while (this.hasNext()) {
            if (!Objects.equals(p, this.next())) continue;
            return true;
        }
        return false;
    }

    default public Optional<T> min(AFunction<T, Comparable> comparable) {
        return this.min((T a, T b) -> ((Comparable)comparable.apply(a)).compareTo(comparable.apply(b)));
    }

    default public boolean allMatch(APredicate<T> p) {
        while (this.hasNext()) {
            if (p.test(this.next())) continue;
            return false;
        }
        return true;
    }

    default public Flow<String> mapToString() {
        return this.map(Object::toString);
    }

    @NotNull
    default public T[] toArray(@NotNull Class<? super T> arrayType) {
        Object[] res = (Object[])RU.cast(Array.newInstance(arrayType, 10));
        int i = 0;
        while (this.hasNext()) {
            if (i == res.length) {
                res = Arrays.copyOf(res, (int)((double)res.length * 1.5));
            }
            res[i++] = this.next();
        }
        return Arrays.copyOf(res, i);
    }

    @NotNull
    default public Flow<T> sort(@NotNull Comparator<T> comparator) {
        Object[] arr = this.toArray();
        Arrays.sort(arr, comparator);
        return Flow.flow(arr);
    }

    @NotNull
    default public <E> Flow<E> flatMap1(@NotNull AFunctionO2Iterable<T, E> f) {
        return this.flatMap((e, c) -> {
            Iterable ii = f.apply(e);
            if (ii != null) {
                for (Object v : ii) {
                    c.accept(v);
                }
            }
        });
    }

    @NotNull
    default public Flow<Class<? extends T>> mapToType() {
        return this.filter(Objects::nonNull).map(v -> v.getClass());
    }

    default public <E> Flow<E> mapToType(Class<E> t) {
        return this;
    }

    @NotNull
    default public <E> Flow<E> map(final @NotNull AFunction<T, E> f) {
        final Flow self = this;
        return new Flow<E>(){

            @Override
            public boolean hasNext() {
                return self.hasNext();
            }

            @Override
            public E next() {
                return f.apply(self.next());
            }
        };
    }

    default public Flow<T> onDone(final Runnable t) {
        final Flow self = this;
        return new Flow<T>(){

            @Override
            public boolean hasNext() {
                return self.hasNext();
            }

            @Override
            public T next() {
                Object res = self.next();
                if (!this.hasNext()) {
                    t.run();
                }
                return res;
            }
        };
    }

    default public T random() {
        List<T> l = this.toList();
        if (l.isEmpty()) {
            return null;
        }
        return l.get(RANDOM.nextInt(l.size()));
    }

    @NotNull
    default public FlowLong mapToLong(final @NotNull AFunctionO2L<T> f) {
        final Flow self = this;
        return new FlowLong(){

            public boolean hasNext() {
                return self.hasNext();
            }

            public long nextLong() {
                return f.apply(self.next());
            }
        };
    }

    default public void split(Collection<T> ifTrue, Collection<T> ifFalse, Collection<T> ifCenter, SplitComparator<T> p) {
        while (this.hasNext()) {
            Object v = this.next();
            int i = p.test(v);
            if (i > 0) {
                ifTrue.add(v);
                continue;
            }
            if (i < 0) {
                ifFalse.add(v);
                continue;
            }
            ifCenter.add(v);
        }
    }

    @NotNull
    default public FlowBoolean mapToBoolean(final @NotNull AFunctionO2Bool<T> f) {
        final Flow self = this;
        return new FlowBoolean(){

            public boolean hasNext() {
                return self.hasNext();
            }

            public boolean nextBoolean() {
                return f.apply(self.next());
            }
        };
    }

    @NotNull
    default public FlowInt mapToInt(final @NotNull AFunctionO2I<T> f) {
        final Flow self = this;
        return new FlowInt(){

            public boolean hasNext() {
                return self.hasNext();
            }

            public int nextInt() {
                return f.apply(self.next());
            }
        };
    }

    @NotNull
    default public FlowShort mapToShort(final @NotNull AFunctionO2S<T> f) {
        final Flow self = this;
        return new FlowShort(){

            public boolean hasNext() {
                return self.hasNext();
            }

            public short nextShort() {
                return f.apply(self.next());
            }
        };
    }

    @NotNull
    default public Flow<T> apply(final AConsumer<T> c) {
        final Flow self = this;
        return new Flow<T>(){

            @Override
            public boolean hasNext() {
                return self.hasNext();
            }

            @Override
            public T next() {
                Object v = self.next();
                c.accept(v);
                return v;
            }
        };
    }

    @NotNull
    default public <E> Flow<E> filterByType(Class<E> predicate) {
        return this.filter(predicate::isInstance);
    }

    @NotNull
    default public Flow<T> filterNotType(Class<?> predicate) {
        return this.filterNot(predicate::isInstance);
    }

    default public <E extends T> Flow<T> addAllEls(final E ... values) {
        final Flow oit = this;
        return new Flow<T>(){
            boolean parent = true;
            private int index;

            @Override
            public boolean hasNext() {
                if (this.parent && oit.hasNext()) {
                    return true;
                }
                this.parent = false;
                return this.index < values.length;
            }

            @Override
            public T next() {
                if (this.parent) {
                    return oit.next();
                }
                return values[this.index++];
            }
        };
    }

    default public Flow<T> addAll(Flow<? extends T> values) {
        return this.addAll((Iterator<? extends T>)values);
    }

    default public Flow<T> addAll(final Iterator<? extends T> values) {
        if (!values.hasNext()) {
            return this;
        }
        final Flow oit = this;
        return new Flow<T>(){
            boolean parent = true;

            @Override
            public boolean hasNext() {
                if (this.parent && oit.hasNext()) {
                    return true;
                }
                this.parent = false;
                return values.hasNext();
            }

            @Override
            public T next() {
                if (this.parent) {
                    return oit.next();
                }
                return values.next();
            }
        };
    }

    default public Flow<T> addAll(Iterable<? extends T> values) {
        return this.addAll(values.iterator());
    }

    @NotNull
    default public <E> Flow<E> flatMap2(@NotNull AFunctionO2Array<T, E> f) {
        return this.flatMap((e, c) -> {
            E[] ii = f.apply(e);
            if (ii != null) {
                for (Object v : ii) {
                    c.accept(v);
                }
            }
        });
    }

    @NotNull
    default public <E> Flow<E> flatMap3(final @NotNull AFunctionO2Stream<T, E> f) {
        final Flow self = this;
        return new Flow<E>(){
            Flow<E> cur;

            @Override
            public boolean hasNext() {
                while (this.cur == null || !this.cur.hasNext()) {
                    if (this.cur != null) {
                        this.cur = null;
                    }
                    if (!self.hasNext()) {
                        return false;
                    }
                    this.cur = f.apply(self.next());
                }
                return true;
            }

            @Override
            public E next() {
                return this.cur.next();
            }
        };
    }

    @NotNull
    default public Flow<T> sort(@NotNull AComparator<T> comparator) {
        Object[] arr = this.toArray();
        Arrays.sort(arr, comparator);
        return Flow.flow(arr);
    }

    default public void run() {
        while (this.hasNext()) {
            this.next();
        }
    }

    default public void foreach(AConsumer<T> c) {
        while (this.hasNext()) {
            c.accept(this.next());
        }
    }

    default public Flow<T> ifError(final AFunction<Throwable, T> f) {
        final Flow self = this;
        return new Flow<T>(){

            @Override
            public boolean hasNext() {
                return self.hasNext();
            }

            @Override
            public T next() {
                try {
                    return self.next();
                }
                catch (Throwable e) {
                    return f.apply(e);
                }
            }
        };
    }

    @NotNull
    default public <E> Flow<E> flatMap4(@NotNull AFunctionO2Iterator<T, E> f) {
        return this.flatMap((e, c) -> {
            Iterator ii = f.apply(e);
            if (ii != null) {
                while (ii.hasNext()) {
                    c.accept(ii.next());
                }
            }
        });
    }

    default public Flow<T> reverse() {
        return Flow.flow(this.toArray());
    }

    @NotNull
    default public <E> Flow<E> flatMap(final @NotNull ABiConsumer<T, AConsumer<E>> f) {
        final Flow oit = this;
        final ObjectArrayList list = new ObjectArrayList();
        final AConsumer<Object> cc = arg_0 -> ((ObjectArrayList)list).add(arg_0);
        return new Flow<E>(){
            int pos;

            @Override
            public boolean hasNext() {
                while (list.isEmpty()) {
                    if (!oit.hasNext()) {
                        return false;
                    }
                    f.accept(oit.next(), cc);
                }
                return true;
            }

            @Override
            public E next() {
                Object res = list.get(this.pos++);
                if (this.pos == list.size()) {
                    this.pos = 0;
                    list.clear();
                }
                return res;
            }
        };
    }

    @NotNull
    default public Flow<T> setTo(AConsumer<Set<T>> c) {
        Set<T> set = this.toSet();
        c.accept(set);
        return this;
    }

    @NotNull
    default public Object[] toArray() {
        Object[] res = new Object[10];
        int i = 0;
        while (this.hasNext()) {
            if (i == res.length) {
                res = Arrays.copyOf(res, (int)((double)res.length * 1.5));
            }
            res[i++] = this.next();
        }
        return Arrays.copyOf(res, i);
    }

    default public <E extends Collection<T>> E toCollection(@NotNull E collection) {
        while (this.hasNext()) {
            collection.add(this.next());
        }
        return (E)collection;
    }

    default public <E extends Collection<T>> E removeFromCollection(@NotNull E collection) {
        while (this.hasNext()) {
            collection.remove(this.next());
        }
        return collection;
    }

    @NotNull
    default public Flow<T> filter(final @Nullable APredicate<T> predicate) {
        if (predicate == null) {
            return this;
        }
        final Flow oit = this;
        return new Flow<T>(){
            T last;
            boolean hasNext;

            @Override
            public boolean hasNext() {
                if (this.hasNext) {
                    return true;
                }
                while (oit.hasNext()) {
                    this.last = oit.next();
                    if (!predicate.test(this.last)) continue;
                    this.hasNext = true;
                    return true;
                }
                return false;
            }

            @Override
            public T next() {
                assert (this.hasNext);
                this.hasNext = false;
                return this.last;
            }
        };
    }

    default public Flow<T> limit(final int i) {
        final Flow self = this;
        return new Flow<T>(){
            int cc;

            @Override
            public boolean hasNext() {
                return this.cc < i && self.hasNext();
            }

            @Override
            public T next() {
                ++this.cc;
                return self.next();
            }
        };
    }

    @NotNull
    default public Flow<T> filterNotNull() {
        return this.filter(Objects::nonNull);
    }

    @NotNull
    default public Flow<T> filterExclude(T value) {
        return this.filterNot(v -> Objects.equals(v, value));
    }

    @NotNull
    default public Flow<T> filterNot(final @Nullable APredicate<T> predicate) {
        if (predicate == null) {
            return this;
        }
        final Flow oit = this;
        return new Flow<T>(){
            T last;
            boolean hasNext;

            @Override
            public boolean hasNext() {
                if (this.hasNext) {
                    return true;
                }
                while (oit.hasNext()) {
                    this.last = oit.next();
                    if (predicate.test(this.last)) continue;
                    this.hasNext = true;
                    return true;
                }
                return false;
            }

            @Override
            public T next() {
                assert (this.hasNext);
                this.hasNext = false;
                return this.last;
            }
        };
    }

    @NotNull
    default public Flow<T> ifEmpty(final ARunnable task) {
        if (task == null) {
            return this;
        }
        final Flow oit = this;
        return new Flow<T>(){
            boolean first = true;

            @Override
            public boolean hasNext() {
                boolean res = oit.hasNext();
                if (!res && this.first) {
                    task.run();
                }
                this.first = false;
                return res;
            }

            @Override
            public T next() {
                return oit.next();
            }
        };
    }

    default public void joinD(StringBuilder sb) {
        this.join(AString.of(sb), ", ");
    }

    default public void joinD(AString sb) {
        this.join(sb, ", ");
    }

    default public <E> Flow<E> cast(@NotNull Class<E> type) {
        return this;
    }

    default public Flow<T> errorIf(APredicate<T> conditions) {
        return this.apply(v -> {
            if (conditions.test(v)) {
                throw new RuntimeException(String.valueOf(v));
            }
        });
    }

    @NotNull
    default public Flow<T> ifEmpty(Exception error) {
        return this.ifEmpty(() -> {
            throw error;
        });
    }

    @NotNull
    default public Flow<T> shuffle() {
        List<T> l = this.toList();
        Collections.shuffle(l);
        return Flow.flow(l);
    }

    @NotNull
    default public Flow<T> ignoreError(final Class<? extends Exception> ee) {
        if (ee == null) {
            return this;
        }
        final Flow oit = this;
        return new Flow<T>(){
            T last;
            boolean hasNext;

            @Override
            public boolean hasNext() {
                if (this.hasNext) {
                    return true;
                }
                while (oit.hasNext()) {
                    try {
                        this.last = oit.next();
                        this.hasNext = true;
                        return true;
                    }
                    catch (Exception ex) {
                        if (ee.isInstance(ex)) continue;
                        RU.error(ex);
                    }
                }
                return false;
            }

            @Override
            public T next() {
                assert (this.hasNext);
                this.hasNext = false;
                return this.last;
            }
        };
    }

    @NotNull
    default public List<T> toList() {
        return new ObjectArrayList(this.toArray());
    }

    @NotNull
    default public Iterable<T> toIterable() {
        return () -> this;
    }

    @NotNull
    default public ObjectImmutableList<T> toImmutableList() {
        return ObjectImmutableList.of((Object[])this.toArray());
    }

    @NotNull
    default public Set<T> toSet() {
        return new ObjectOpenHashSet(this.toArray());
    }

    default public boolean isNotEmpty() {
        return this.hasNext();
    }

    default public Optional<T> max(AFunction<T, Comparable> comparable) {
        return this.max((T a, T b) -> ((Comparable)comparable.apply(a)).compareTo(comparable.apply(b)));
    }

    default public <T2> void to(T2 arg, ABiConsumer<T2, T> consumer) {
        while (this.hasNext()) {
            consumer.accept(arg, (T2)this.next());
        }
    }

    default public void to(AConsumer<T> consumer) {
        while (this.hasNext()) {
            consumer.accept(this.next());
        }
    }

    @NotNull
    default public Supplier<T> toSupplier() {
        return () -> {
            if (this.hasNext()) {
                return this.next();
            }
            return null;
        };
    }

    @NotNull
    default public <K> Map<K, T> toMapExtractKey(AFunction<T, K> keyFactory) {
        return this.toMapExtractKey((Map<K, T>)new Object2ObjectOpenHashMap(), keyFactory);
    }

    @NotNull
    default public <K> Map<K, T> toCMapExtractKey(AFunction<T, K> keyFactory) {
        return this.toMapExtractKey(new ConcurrentHashMap(), keyFactory);
    }

    @NotNull
    default public <K> Map<K, T> toMapExtractKey(Map<K, T> map, AFunction<T, K> keyFactory) {
        while (this.hasNext()) {
            Object val = this.next();
            map.put(keyFactory.apply(val), val);
        }
        return map;
    }

    @NotNull
    default public <K, V> Map<K, V> toMap(AFunction<T, K> keyFactory, AFunction<T, V> valFactory) {
        return this.toMap((Map<K, V>)new Object2ObjectOpenHashMap(), keyFactory, valFactory);
    }

    @NotNull
    default public <K, V> Map<K, V> toMap(Map<K, V> map, AFunction<T, K> keyFactory, AFunction<T, V> valFactory) {
        while (this.hasNext()) {
            Object val = this.next();
            map.put(keyFactory.apply(val), valFactory.apply(val));
        }
        return map;
    }

    @NotNull
    default public <V> Int2ObjectMap<V> toMapI2O(AFunctionO2I<T> keyFactory, AFunction<T, V> valFactory) {
        Int2ObjectOpenHashMap res = new Int2ObjectOpenHashMap();
        while (this.hasNext()) {
            Object val = this.next();
            res.put(keyFactory.apply(val), valFactory.apply(val));
        }
        return res;
    }

    @NotNull
    default public <K> Object2IntMap<K> toMapO2I(AFunction<T, K> keyFactory, AFunctionO2I<T> valFactory) {
        Object2IntOpenHashMap res = new Object2IntOpenHashMap();
        while (this.hasNext()) {
            Object val = this.next();
            res.put(keyFactory.apply(val), valFactory.apply(val));
        }
        return res;
    }

    @NotNull
    default public <V> Long2ObjectMap<V> toMapL2O(AFunctionO2L<T> keyFactory, AFunction<T, V> valFactory) {
        Long2ObjectOpenHashMap res = new Long2ObjectOpenHashMap();
        while (this.hasNext()) {
            Object val = this.next();
            res.put(keyFactory.apply(val), valFactory.apply(val));
        }
        return res;
    }

    default public String joinD() {
        StringBuilder sb = new StringBuilder();
        this.joinD(sb);
        return sb.toString();
    }

    default public String join(String delimer) {
        AString sb = AString.of();
        this.join(sb, delimer);
        return sb.toString();
    }

    default public String joinN() {
        return this.join("\n");
    }

    default public void join(AString sb, String delimer) {
        boolean first = true;
        while (this.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.add(delimer);
            }
            sb.add(this.next());
        }
    }

    default public Flow<T> errorIf(APredicate<T> conditions, Runnable throwCode) {
        return this.apply(v -> {
            if (conditions.test(v)) {
                throwCode.run();
            }
        });
    }

    default public Flow<T> errorIf(APredicate<T> conditions, Consumer<T> throwCode) {
        return this.apply(v -> {
            if (conditions.test(v)) {
                throwCode.accept(v);
            }
        });
    }

    default public Flow<T> errorIf(APredicate<T> conditions, Class<? extends Throwable> throwCode) {
        return this.apply(v -> {
            if (conditions.test(v)) {
                throw (Throwable)throwCode.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        });
    }

    default public Flow<T> distinct() {
        return this.filter(new APredicate<T>(){
            private final Set<T> old = new ObjectOpenHashSet();

            @Override
            public boolean test2(T value) {
                return this.old.add(value);
            }
        });
    }

    default public String join(AFunction<T, Object> preparer, String delimer) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        while (this.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(delimer);
            }
            sb.append(preparer.apply(this.next()));
        }
        return sb.toString();
    }

    default public T getFirstOrNull() {
        if (this.hasNext()) {
            return (T)this.next();
        }
        return null;
    }

    default public T getFirst() {
        if (this.hasNext()) {
            return (T)this.next();
        }
        throw new NoSuchElementException();
    }

    default public T getFirst(APredicate<T> p) {
        return this.filter(p).getFirst();
    }

    default public T getFirstOrNull(APredicate<T> p) {
        return this.filter(p).getFirstOrNull();
    }

    default public String join() {
        StringBuilder sb = new StringBuilder();
        while (this.hasNext()) {
            sb.append(this.next());
        }
        return sb.toString();
    }

    default public String join(String delim, String prefix, String postfix) {
        StringBuilder sb = new StringBuilder(prefix);
        boolean first = true;
        while (this.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(delim);
            }
            sb.append(this.next());
        }
        sb.append(postfix);
        return sb.toString();
    }

    default public void crossSelf(ABiConsumer<T, T> consumer) {
        Object[] ar;
        for (Object a : ar = this.toArray()) {
            for (Object b : ar) {
                if (a == b) continue;
                consumer.accept(a, b);
            }
        }
    }

    default public void crossSelf(ABiPredicate<T, T> p, ABiConsumer<T, T> consumer) {
        Object[] ar;
        for (Object a : ar = this.toArray()) {
            for (Object b : ar) {
                if (a == b || !p.test(a, b)) continue;
                consumer.accept(a, b);
            }
        }
    }

    default public Optional<T> min(AComparator<T> comparator) {
        Object min = null;
        while (this.hasNext()) {
            Object v = this.next();
            if (min == null) {
                min = v;
                continue;
            }
            if (comparator.compare(min, v) <= 0) continue;
            min = v;
        }
        return Optional.ofNullable(min);
    }

    default public Optional<T> max(AComparator<T> comparator) {
        Object max = null;
        while (this.hasNext()) {
            Object v = this.next();
            if (max == null) {
                max = v;
                continue;
            }
            if (comparator.compare(max, v) >= 0) continue;
            max = v;
        }
        return Optional.ofNullable(max);
    }

    default public boolean isEmpty() {
        return !this.hasNext();
    }

    default public Flow<T> skipLast(int count) {
        Object[] a = this.toArray();
        if (a.length < count) {
            return Flow.flow();
        }
        a = Arrays.copyOfRange(a, 0, a.length - count);
        return (Flow)RU.cast(Flow.flow(a));
    }

    default public Flow<T> skip(final int count) {
        if (count == 0) {
            return this;
        }
        final Flow self = this;
        return new Flow<T>(){
            private boolean skipped = false;

            private void skip() {
                if (!this.skipped) {
                    for (int i = 0; i < count && self.hasNext(); ++i) {
                        self.next();
                    }
                    this.skipped = true;
                }
            }

            @Override
            public boolean hasNext() {
                this.skip();
                return self.hasNext();
            }

            @Override
            public T next() {
                this.skip();
                return self.next();
            }
        };
    }

    default public int count() {
        int res = 0;
        while (this.hasNext()) {
            ++res;
            this.next();
        }
        return res;
    }

    default public <R> R allMap(AFunction<Flow<T>, R> f) {
        return f.apply(this);
    }

    default public void join(StringBuilder sb) {
        while (this.hasNext()) {
            sb.append(this.next());
        }
    }

    @NotNull
    public static <T> Flow<T> flow(@NotNull Flow<T> stream) {
        return stream;
    }

    @NotNull
    public static Flow<String> flow(String ... ss) {
        return (Flow)RU.cast(Flow.flow((Object[])ss));
    }

    @SafeVarargs
    public static <T> Flow<T> flowArray(T ... ss) {
        return (Flow)RU.cast(Flow.flow(ss));
    }

    @NotNull
    public static <T> Flow<T> flow(final @NotNull T[] array) {
        if (array == null || array.length == 0) {
            return Flow.flow();
        }
        return new FlowCompleted<T>(){
            int pos;

            @Override
            public int count() {
                return array.length;
            }

            @Override
            public T random() {
                return array[RANDOM.nextInt(array.length)];
            }

            @Override
            public boolean hasNext() {
                return this.pos < array.length;
            }

            @Override
            public T next() {
                return array[this.pos++];
            }

            @Override
            @NotNull
            public Object[] toArray() {
                return array;
            }

            @Override
            public void foreach(AConsumer<T> c) {
                for (Object v : array) {
                    c.accept(v);
                }
            }

            @Override
            @NotNull
            public List<T> toList() {
                return new ObjectArrayList(array);
            }

            @Override
            @NotNull
            public Supplier<T> toSupplier() {
                return new ASupplier<T>(){
                    int pos;

                    @Override
                    public T get2() {
                        if (this.pos == array.length) {
                            return null;
                        }
                        return array[this.pos++];
                    }
                };
            }

            @Override
            @NotNull
            public T[] toArray(@NotNull Class<? super T> arrayType) {
                Object[] res = (Object[])RU.cast(Array.newInstance(arrayType, array.length));
                System.arraycopy(array, 0, res, 0, array.length);
                return res;
            }
        };
    }

    @NotNull
    public static FlowLong flow(long @NotNull [] array) {
        return FlowLong.of(array);
    }

    public static FlowInt flow(final int number) {
        return new FlowCompletedInt(){
            int c = 0;

            @Override
            public int count() {
                return number;
            }

            public int nextInt() {
                return this.c++;
            }

            public boolean hasNext() {
                return this.c < number;
            }
        };
    }

    public static FlowInt flow(int @NotNull [] array) {
        return FlowInt.of(array);
    }

    public static FlowShort flow(short @NotNull [] array) {
        return FlowShort.of(array);
    }

    @NotNull
    public static FlowByte flow(byte @NotNull [] array) {
        return FlowByte.of(array);
    }

    @NotNull
    public static <T> Flow<T> flow(@NotNull Iterable<T> iterable) {
        if (iterable instanceof Set) {
            return Flow.flow((Set)iterable);
        }
        if (iterable instanceof List) {
            return Flow.flow((List)iterable);
        }
        if (iterable instanceof Collection) {
            return Flow.flow((Collection)iterable);
        }
        return Flow.flow(iterable.iterator());
    }

    @NotNull
    public static FlowLong flow(@NotNull LongIterable iterable) {
        return FlowLong.of(iterable);
    }

    @NotNull
    public static FlowInt flow(@NotNull IntIterable iterable) {
        return FlowInt.of(iterable);
    }

    @NotNull
    public static FlowLong flow(@NotNull LongSet collection) {
        return FlowLong.of(collection);
    }

    @NotNull
    public static <T> Flow<T> flow(final @NotNull Set<T> collection) {
        if (collection.isEmpty()) {
            return Flow.flow();
        }
        final Iterator<T> it = collection.iterator();
        return new FlowCompleted<T>(){

            @Override
            public int count() {
                return collection.size();
            }

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public T next() {
                return it.next();
            }

            @Override
            @NotNull
            public Set<T> toSet() {
                return collection;
            }
        };
    }

    @NotNull
    public static FlowLong flow(@NotNull LongList collection) {
        return FlowLong.of(collection);
    }

    @NotNull
    public static FlowInt flow(@NotNull IntList collection) {
        return FlowInt.of(collection);
    }

    @NotNull
    public static <T> Flow<T> flow(final @NotNull List<T> collection) {
        if (collection.isEmpty()) {
            return Flow.flow();
        }
        final Iterator<T> it = collection.iterator();
        return new FlowCompleted<T>(){

            @Override
            public int count() {
                return collection.size();
            }

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public T next() {
                return it.next();
            }

            @Override
            @NotNull
            public List<T> toList() {
                return new ObjectArrayList((Collection)collection);
            }
        };
    }

    @NotNull
    public static <T> Flow<T> flow(final @NotNull Collection<T> collection) {
        if (collection.isEmpty()) {
            return Flow.flow();
        }
        final Iterator<T> it = collection.iterator();
        return new FlowCompleted<T>(){

            @Override
            public int count() {
                return collection.size();
            }

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public T next() {
                return it.next();
            }

            @Override
            @NotNull
            public List<T> toList() {
                return new ObjectArrayList(collection);
            }

            @Override
            @NotNull
            public Set<T> toSet() {
                return new ObjectOpenHashSet(collection);
            }
        };
    }

    @NotNull
    public static <T> Flow<T> flow(final @NotNull ASupplier<T> supplier) {
        return new Flow<T>(){
            private T last;
            private boolean end;

            @Override
            public boolean hasNext() {
                if (this.end) {
                    return false;
                }
                if (this.last != null) {
                    return true;
                }
                this.last = supplier.get();
                if (this.last == null) {
                    this.end = true;
                    return false;
                }
                return true;
            }

            @Override
            public T next() {
                assert (this.last != null);
                return this.last;
            }
        };
    }

    @NotNull
    public static FlowLong flow(@NotNull LongIterator iterator) {
        return FlowLong.of(iterator);
    }

    @NotNull
    public static <T> Flow<T> flow(final @NotNull Iterator<T> iterator) {
        if (!iterator.hasNext()) {
            return Flow.flow();
        }
        return new Flow<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }
        };
    }

    @NotNull
    public static <K, V> Flow<Map.Entry<K, V>> flow(@NotNull Map<K, V> map) {
        return Flow.flow(map.entrySet());
    }

    public static <T> Flow<T> flow() {
        return EMPTY;
    }

    public static interface SplitComparator<T> {
        public int test(T var1);
    }
}

