/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.flow;

import io.aether.utils.AString;
import io.aether.utils.RU;
import io.aether.utils.flow.Flow;
import io.aether.utils.flow.FlowByte;
import io.aether.utils.flow.FlowCompletedInt;
import io.aether.utils.interfaces.ABiConsumerI2O;
import io.aether.utils.interfaces.AComparatorInt;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.interfaces.AConsumerInt;
import io.aether.utils.interfaces.AFunction;
import io.aether.utils.interfaces.AFunctionI2Array;
import io.aether.utils.interfaces.AFunctionI2I;
import io.aether.utils.interfaces.AFunctionI2O;
import io.aether.utils.interfaces.AFunctionL2I;
import io.aether.utils.interfaces.AFunctionL2IterableInt;
import io.aether.utils.interfaces.AFunctionL2O;
import io.aether.utils.interfaces.AFunctionL2StreamInt;
import io.aether.utils.interfaces.APredicateInt;
import io.aether.utils.interfaces.ARunnable;
import io.aether.utils.interfaces.ASupplierInt;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface FlowInt
extends IntIterator,
IntIterable {
    public static final int[] EMPTY_AR = new int[0];
    public static final FlowInt EMPTY = new FlowCompletedInt(){

        public boolean hasNext() {
            return false;
        }

        public int nextInt() {
            return 0;
        }

        @Override
        public int count() {
            return 0;
        }

        @Override
        public int @NotNull [] toArray() {
            return EMPTY_AR;
        }

        @Override
        @NotNull
        public IntList toList() {
            return new IntArrayList();
        }

        @Override
        @NotNull
        public <K, V> Map<K, V> toMap(AFunctionL2O<K> keyFactory, AFunctionL2O<V> valFactory) {
            return new Object2ObjectOpenHashMap();
        }
    };

    default public Flow<Integer> box() {
        final FlowInt self = this;
        return new Flow<Integer>(){

            @Override
            public boolean hasNext() {
                return self.hasNext();
            }

            @Override
            public Integer next() {
                return self.nextInt();
            }
        };
    }

    @NotNull
    public static FlowInt of(@NotNull FlowInt stream) {
        return stream;
    }

    @NotNull
    public static FlowInt of(final int ... array) {
        if (array.length == 0) {
            return FlowInt.of();
        }
        return new FlowCompletedInt(){
            int pos;

            public boolean hasNext() {
                return this.pos < array.length;
            }

            public int nextInt() {
                return array[this.pos++];
            }

            @Override
            public int @NotNull [] toArray() {
                return array;
            }

            @Override
            public void foreach(AConsumer<Integer> c) {
                for (int v : array) {
                    c.accept(v);
                }
            }

            @Override
            public int count() {
                return array.length;
            }

            @Override
            @NotNull
            public IntList toList() {
                return new IntArrayList(array);
            }

            @Override
            @NotNull
            public ASupplierInt toSupplier() {
                return new ASupplierInt(){
                    int pos;

                    @Override
                    public int get2() {
                        if (this.pos == array.length) {
                            throw new NoSuchElementException();
                        }
                        return array[this.pos++];
                    }
                };
            }
        };
    }

    @NotNull
    public static FlowInt of(@NotNull IntIterable iterable) {
        if (iterable instanceof IntSet) {
            return FlowInt.of((IntSet)iterable);
        }
        if (iterable instanceof IntList) {
            return FlowInt.of((IntList)iterable);
        }
        return FlowInt.of(iterable.iterator());
    }

    @NotNull
    public static FlowInt of(final @NotNull IntSet collection) {
        if (collection.isEmpty()) {
            return FlowInt.of();
        }
        final IntIterator it = collection.iterator();
        return new FlowCompletedInt(){

            @Override
            public int count() {
                return collection.size();
            }

            public boolean hasNext() {
                return it.hasNext();
            }

            public int nextInt() {
                return it.nextInt();
            }

            @Override
            @NotNull
            public IntSet toSet() {
                return collection;
            }
        };
    }

    @NotNull
    public static FlowInt of(final @NotNull IntList collection) {
        if (collection.isEmpty()) {
            return FlowInt.of();
        }
        final IntListIterator it = collection.iterator();
        return new FlowCompletedInt(){

            @Override
            public int count() {
                return collection.size();
            }

            public boolean hasNext() {
                return it.hasNext();
            }

            public int nextInt() {
                return it.nextInt();
            }

            @Override
            @NotNull
            public IntList toList() {
                return collection;
            }
        };
    }

    @NotNull
    public static FlowInt of(final @NotNull IntIterator iterator) {
        if (!iterator.hasNext()) {
            return FlowInt.of();
        }
        return new FlowInt(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public int nextInt() {
                return iterator.nextInt();
            }
        };
    }

    public static FlowInt of() {
        return EMPTY;
    }

    public static void quickSort(int[] source, int leftBorder, int rightBorder, AComparatorInt comparator) {
        int leftMarker = leftBorder;
        int rightMarker = rightBorder;
        int pivot = source[(leftMarker + rightMarker) / 2];
        while (true) {
            if (comparator.compare(source[leftMarker], pivot) < 0) {
                ++leftMarker;
                continue;
            }
            while (comparator.compare(source[rightMarker], pivot) > 0) {
                --rightMarker;
            }
            if (leftMarker <= rightMarker) {
                if (leftMarker < rightMarker) {
                    int tmp = source[leftMarker];
                    source[leftMarker] = source[rightMarker];
                    source[rightMarker] = tmp;
                }
                ++leftMarker;
                --rightMarker;
            }
            if (leftMarker > rightMarker) break;
        }
        if (leftMarker < rightBorder) {
            FlowInt.quickSort(source, leftMarker, rightBorder, comparator);
        }
        if (leftBorder < rightMarker) {
            FlowInt.quickSort(source, leftBorder, rightMarker, comparator);
        }
    }

    @NotNull
    default public IntIterator iterator() {
        return this;
    }

    default public int random() {
        int[] ar = this.toArray();
        return ar[Flow.RANDOM.nextInt(ar.length)];
    }

    default public boolean anyMatch(APredicateInt p) {
        while (this.hasNext()) {
            if (!p.test(this.nextInt())) continue;
            return true;
        }
        return false;
    }

    default public boolean noneMatch(APredicateInt p) {
        while (this.hasNext()) {
            if (!p.test(this.nextInt())) continue;
            return false;
        }
        return true;
    }

    default public FlowInt add(final int value) {
        final FlowInt oit = this;
        return new FlowInt(){
            private boolean index;

            public boolean hasNext() {
                return !this.index || oit.hasNext();
            }

            public int nextInt() {
                if (!this.index) {
                    this.index = true;
                    return value;
                }
                return oit.nextInt();
            }
        };
    }

    default public boolean noneMatchValue(int p) {
        while (this.hasNext()) {
            if (p != this.nextInt()) continue;
            return false;
        }
        return true;
    }

    default public boolean anyMatchValue(int p) {
        while (this.hasNext()) {
            if (p != this.nextInt()) continue;
            return true;
        }
        return false;
    }

    default public boolean allMatch(APredicateInt p) {
        while (this.hasNext()) {
            if (p.test(this.nextInt())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    default public <E> Flow<E> mapToObj(final @NotNull AFunctionI2O<E> f) {
        final FlowInt self = this;
        return new Flow<E>(){

            @Override
            public boolean hasNext() {
                return self.hasNext();
            }

            @Override
            public E next() {
                return f.apply(self.nextInt());
            }
        };
    }

    @NotNull
    default public FlowInt map(final @NotNull AFunctionI2I f) {
        final FlowInt self = this;
        return new FlowInt(){

            public boolean hasNext() {
                return self.hasNext();
            }

            public int nextInt() {
                return f.apply(self.nextInt());
            }
        };
    }

    @NotNull
    default public FlowByte mapToByte() {
        final FlowInt self = this;
        return new FlowByte(){

            public boolean hasNext() {
                return self.hasNext();
            }

            public byte nextByte() {
                return (byte)self.nextInt();
            }
        };
    }

    @NotNull
    default public FlowInt apply(final AConsumerInt c) {
        final FlowInt self = this;
        return new FlowInt(){

            public boolean hasNext() {
                return self.hasNext();
            }

            public int nextInt() {
                int v = self.nextInt();
                c.accept(v);
                return v;
            }
        };
    }

    default public FlowInt addAllEls(final int ... values) {
        final FlowInt oit = this;
        return new FlowInt(){
            private int index;

            public boolean hasNext() {
                return this.index < values.length || oit.hasNext();
            }

            public int nextInt() {
                if (this.index < values.length) {
                    return values[this.index++];
                }
                return oit.nextInt();
            }
        };
    }

    default public FlowInt addAll(FlowInt values) {
        return this.addAll((IntIterator)values);
    }

    default public FlowInt addAll(final IntIterator values) {
        if (!values.hasNext()) {
            return this;
        }
        final FlowInt oit = this;
        return new FlowInt(){

            public boolean hasNext() {
                return values.hasNext() || oit.hasNext();
            }

            public int nextInt() {
                if (values.hasNext()) {
                    return values.nextInt();
                }
                return oit.nextInt();
            }
        };
    }

    default public FlowInt addAll(IntIterable values) {
        return this.addAll(values.iterator());
    }

    @NotNull
    default public FlowInt flatMap(@NotNull AFunctionL2IterableInt f) {
        return this.flatMap((int e, AConsumerInt c) -> {
            IntIterable ii = f.apply(e);
            if (ii != null) {
                for (Integer v : ii) {
                    c.accept(v);
                }
            }
        });
    }

    @NotNull
    default public FlowInt flatMap(@NotNull AFunctionI2Array f) {
        return this.flatMap((int e, AConsumerInt c) -> {
            int[] ii = f.apply(e);
            if (ii != null) {
                for (int v : ii) {
                    c.accept(v);
                }
            }
        });
    }

    default public void foreach(AConsumer<Integer> c) {
        while (this.hasNext()) {
            c.accept(this.nextInt());
        }
    }

    @NotNull
    default public FlowInt flatMap(final @NotNull AFunctionL2StreamInt f) {
        final FlowInt self = this;
        return new FlowInt(){
            FlowInt cur;

            public boolean hasNext() {
                while (this.cur == null || !this.cur.hasNext()) {
                    if (this.cur != null) {
                        this.cur = null;
                    }
                    if (!self.hasNext()) {
                        return false;
                    }
                    this.cur = f.apply(self.nextInt());
                }
                return true;
            }

            public int nextInt() {
                return this.cur.nextInt();
            }
        };
    }

    @NotNull
    default public FlowInt flatMap(final @NotNull ABiConsumerI2O<AConsumerInt> f) {
        final FlowInt oit = this;
        final IntArrayList list = new IntArrayList();
        final AConsumerInt cc = arg_0 -> ((IntArrayList)list).add(arg_0);
        return new FlowInt(){
            int pos;

            public boolean hasNext() {
                while (list.isEmpty()) {
                    if (!oit.hasNext()) {
                        return false;
                    }
                    f.accept(oit.nextInt(), cc);
                }
                return true;
            }

            public int nextInt() {
                int res = list.getInt(this.pos++);
                if (this.pos == list.size()) {
                    this.pos = 0;
                    list.clear();
                }
                return res;
            }
        };
    }

    default public short @NotNull [] toShortArray() {
        short[] res = new short[10];
        int i = 0;
        while (this.hasNext()) {
            if (i == res.length) {
                res = Arrays.copyOf(res, (int)((double)res.length * 1.5));
            }
            res[i++] = (short)this.nextInt();
        }
        return Arrays.copyOf(res, i);
    }

    default public int @NotNull [] toArray() {
        int[] res = new int[10];
        int i = 0;
        while (this.hasNext()) {
            if (i == res.length) {
                res = Arrays.copyOf(res, (int)((double)res.length * 1.5));
            }
            res[i++] = this.nextInt();
        }
        return Arrays.copyOf(res, i);
    }

    default public <E extends Collection<Integer>> E toCollection(@NotNull E collection) {
        while (this.hasNext()) {
            collection.add(this.nextInt());
        }
        return (E)collection;
    }

    default public <E extends IntCollection> E toCollection(@NotNull E collection) {
        while (this.hasNext()) {
            collection.add(this.nextInt());
        }
        return collection;
    }

    @NotNull
    default public FlowInt filter(final @Nullable APredicateInt predicate) {
        if (predicate == null) {
            return this;
        }
        final FlowInt oit = this;
        return new FlowInt(){
            int last;
            boolean hasNext;

            public boolean hasNext() {
                if (this.hasNext) {
                    return true;
                }
                while (oit.hasNext()) {
                    this.last = oit.nextInt();
                    if (!predicate.test(this.last)) continue;
                    this.hasNext = true;
                    return true;
                }
                return false;
            }

            public int nextInt() {
                assert (this.hasNext);
                this.hasNext = false;
                return this.last;
            }
        };
    }

    @NotNull
    default public FlowInt filterNot(final @Nullable APredicateInt predicate) {
        if (predicate == null) {
            return this;
        }
        final FlowInt oit = this;
        return new FlowInt(){
            int last;
            boolean hasNext;

            public boolean hasNext() {
                if (this.hasNext) {
                    return true;
                }
                while (oit.hasNext()) {
                    this.last = oit.nextInt();
                    if (predicate.test(this.last)) continue;
                    this.hasNext = true;
                    return true;
                }
                return false;
            }

            public int nextInt() {
                assert (this.hasNext);
                this.hasNext = false;
                return this.last;
            }
        };
    }

    @NotNull
    default public FlowInt ifEmpty(final ARunnable task) {
        if (task == null) {
            return this;
        }
        final FlowInt oit = this;
        return new FlowInt(){
            boolean first = true;

            public boolean hasNext() {
                boolean res = oit.hasNext();
                if (!res && this.first) {
                    task.run();
                }
                this.first = false;
                return res;
            }

            public int nextInt() {
                return oit.nextInt();
            }
        };
    }

    @NotNull
    default public FlowInt ifEmpty(Exception error) {
        return this.ifEmpty(() -> {
            throw error;
        });
    }

    @NotNull
    default public FlowInt ignoreError(final Class<? extends Exception> ee) {
        if (ee == null) {
            return this;
        }
        final FlowInt oit = this;
        return new FlowInt(){
            int last;
            boolean hasNext;

            public boolean hasNext() {
                if (this.hasNext) {
                    return true;
                }
                while (oit.hasNext()) {
                    try {
                        this.last = oit.nextInt();
                        this.hasNext = true;
                        return true;
                    }
                    catch (Exception ex) {
                        if (ee.isInstance(ex)) continue;
                        RU.error(ex);
                    }
                }
                return false;
            }

            public int nextInt() {
                assert (this.hasNext);
                this.hasNext = false;
                return this.last;
            }
        };
    }

    @NotNull
    default public FlowInt sort(@NotNull AComparatorInt comparator) {
        int[] arr = this.toArray();
        FlowInt.quickSort(arr, 0, arr.length, comparator);
        return FlowInt.of(arr);
    }

    @NotNull
    default public IntIterable toIterable() {
        return () -> this;
    }

    @NotNull
    default public IntList toList() {
        return new IntArrayList(this.toArray());
    }

    @NotNull
    default public IntSet toSet() {
        return new IntOpenHashSet(this.toArray());
    }

    default public void to(AConsumerInt consumer) {
        while (this.hasNext()) {
            consumer.accept(this.nextInt());
        }
    }

    default public <E> E streamTo(AFunction<FlowInt, E> consumer) {
        return consumer.apply(this);
    }

    @NotNull
    default public ASupplierInt toSupplier() {
        return () -> {
            if (this.hasNext()) {
                return this.nextInt();
            }
            throw new NoSuchElementException();
        };
    }

    @NotNull
    default public <K, V> Map<K, V> toMap(AFunctionL2O<K> keyFactory, AFunctionL2O<V> valFactory) {
        Object2ObjectOpenHashMap res = new Object2ObjectOpenHashMap();
        while (this.hasNext()) {
            int val = this.nextInt();
            res.put(keyFactory.apply(val), valFactory.apply(val));
        }
        return res;
    }

    @NotNull
    default public <V> Int2ObjectMap<V> toMapI2O(AFunctionL2I keyFactory, AFunctionL2O<V> valFactory) {
        Int2ObjectOpenHashMap res = new Int2ObjectOpenHashMap();
        while (this.hasNext()) {
            int val = this.nextInt();
            res.put(keyFactory.apply(val), valFactory.apply(val));
        }
        return res;
    }

    @NotNull
    default public <K> Object2IntMap<K> toMapO2I(AFunctionL2O<K> keyFactory, AFunctionI2I valFactory) {
        Object2IntOpenHashMap res = new Object2IntOpenHashMap();
        while (this.hasNext()) {
            int val = this.nextInt();
            res.put(keyFactory.apply(val), valFactory.apply(val));
        }
        return res;
    }

    @NotNull
    default public <V> Int2ObjectMap<V> toMapL2O(AFunctionI2I keyFactory, AFunctionI2O<V> valFactory) {
        Int2ObjectOpenHashMap res = new Int2ObjectOpenHashMap();
        while (this.hasNext()) {
            int val = this.nextInt();
            res.put(keyFactory.apply(val), valFactory.apply(val));
        }
        return res;
    }

    default public String join(String delimer) {
        AString sb = AString.of();
        this.join(sb, delimer);
        return sb.toString();
    }

    default public void join(AString sb, String delimer) {
        boolean first = true;
        while (this.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.add(delimer);
            }
            sb.add(this.nextInt());
        }
    }

    default public FlowInt distinct() {
        return this.filter(new APredicateInt(){
            private final IntSet old = new IntOpenHashSet();

            @Override
            public boolean test2(int value) {
                return this.old.add(value);
            }
        });
    }

    default public String join(AFunctionL2O<Object> preparer, String delimer) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        while (this.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(delimer);
            }
            sb.append(preparer.apply(this.nextInt()));
        }
        return sb.toString();
    }

    default public int getFirstOr(int def) {
        if (this.hasNext()) {
            return this.nextInt();
        }
        return def;
    }

    default public int getFirst() {
        if (this.hasNext()) {
            return this.nextInt();
        }
        throw new NoSuchElementException();
    }

    default public int getFirst(APredicateInt p) {
        return this.filter(p).getFirst();
    }

    default public String join() {
        StringBuilder sb = new StringBuilder();
        while (this.hasNext()) {
            sb.append(this.nextInt());
        }
        return sb.toString();
    }

    default public String join(String delim, String prefix, String postfix) {
        StringBuilder sb = new StringBuilder(prefix);
        boolean first = true;
        while (this.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(delim);
            }
            sb.append(this.nextInt());
        }
        sb.append(postfix);
        return sb.toString();
    }

    default public int min(AComparatorInt comparator) {
        int min = Integer.MAX_VALUE;
        while (this.hasNext()) {
            int v = this.nextInt();
            if (comparator.compare(min, v) <= 0) continue;
            min = v;
        }
        return min;
    }

    default public int min() {
        int min = Integer.MAX_VALUE;
        while (this.hasNext()) {
            int v = this.nextInt();
            if (min <= v) continue;
            min = v;
        }
        return min;
    }

    default public int max(AComparatorInt comparator) {
        int max = Integer.MIN_VALUE;
        while (this.hasNext()) {
            int v = this.nextInt();
            if (comparator.compare(max, v) >= 0) continue;
            max = v;
        }
        return max;
    }

    default public int max() {
        int max = Integer.MIN_VALUE;
        while (this.hasNext()) {
            int v = this.nextInt();
            if (max >= v) continue;
            max = v;
        }
        return max;
    }

    default public int sum() {
        int res = 0;
        while (this.hasNext()) {
            res += this.nextInt();
        }
        return res;
    }

    default public int avg() {
        long sum = 0L;
        int count = 0;
        while (this.hasNext()) {
            sum += (long)this.nextInt();
            ++count;
        }
        return (int)(sum / (long)count);
    }
}

