/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.flow;

import io.aether.utils.RU;
import io.aether.utils.flow.Flow;
import io.aether.utils.flow.FlowCompletedShort;
import io.aether.utils.flow.FlowInt;
import io.aether.utils.interfaces.ABiConsumerI2O;
import io.aether.utils.interfaces.AComparatorInt;
import io.aether.utils.interfaces.AConsumerInt;
import io.aether.utils.interfaces.AConsumerShort;
import io.aether.utils.interfaces.AFunction;
import io.aether.utils.interfaces.AFunctionI2Array;
import io.aether.utils.interfaces.AFunctionI2I;
import io.aether.utils.interfaces.AFunctionI2O;
import io.aether.utils.interfaces.AFunctionL2I;
import io.aether.utils.interfaces.AFunctionL2IterableInt;
import io.aether.utils.interfaces.AFunctionL2O;
import io.aether.utils.interfaces.AFunctionL2StreamInt;
import io.aether.utils.interfaces.AFunctionS2O;
import io.aether.utils.interfaces.APredicateInt;
import io.aether.utils.interfaces.ARunnable;
import io.aether.utils.interfaces.ASupplierShort;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortIterable;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortList;
import it.unimi.dsi.fastutil.shorts.ShortListIterator;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface FlowShort
extends ShortIterator,
ShortIterable {
    public static final short[] EMPTY_AR = new short[0];
    public static final FlowShort EMPTY = new FlowCompletedShort(){

        public boolean hasNext() {
            return false;
        }

        public short nextShort() {
            return 0;
        }

        @Override
        public int count() {
            return 0;
        }

        @Override
        public short @NotNull [] toArray() {
            return EMPTY_AR;
        }

        @Override
        @NotNull
        public ShortList toList() {
            return new ShortArrayList();
        }

        @Override
        @NotNull
        public <K, V> Map<K, V> toMap(AFunctionL2O<K> keyFactory, AFunctionL2O<V> valFactory) {
            return new Object2ObjectOpenHashMap();
        }
    };

    default public Flow<Short> box() {
        final FlowShort self = this;
        return new Flow<Short>(){

            @Override
            public boolean hasNext() {
                return self.hasNext();
            }

            @Override
            public Short next() {
                return self.nextShort();
            }
        };
    }

    @NotNull
    default public ShortIterator iterator() {
        return this;
    }

    default public short random() {
        short[] ar = this.toArray();
        return ar[Flow.RANDOM.nextInt(ar.length)];
    }

    default public boolean anyMatch(APredicateInt p) {
        while (this.hasNext()) {
            if (!p.test(this.nextShort())) continue;
            return true;
        }
        return false;
    }

    default public boolean noneMatch(APredicateInt p) {
        while (this.hasNext()) {
            if (!p.test(this.nextShort())) continue;
            return false;
        }
        return true;
    }

    default public FlowShort add(int value) {
        final FlowShort oit = this;
        final short value2 = (short)value;
        return new FlowShort(){
            private boolean index;

            public boolean hasNext() {
                return !this.index || oit.hasNext();
            }

            public short nextShort() {
                if (!this.index) {
                    this.index = true;
                    return value2;
                }
                return oit.nextShort();
            }
        };
    }

    default public boolean noneMatchValue(int p) {
        while (this.hasNext()) {
            if (p != this.nextShort()) continue;
            return false;
        }
        return true;
    }

    default public boolean anyMatchValue(int p) {
        while (this.hasNext()) {
            if (p != this.nextShort()) continue;
            return true;
        }
        return false;
    }

    default public boolean allMatch(APredicateInt p) {
        while (this.hasNext()) {
            if (p.test(this.nextShort())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    default public <E> Flow<E> mapToObj(final @NotNull AFunctionS2O<E> f) {
        final FlowShort self = this;
        return new Flow<E>(){

            @Override
            public boolean hasNext() {
                return self.hasNext();
            }

            @Override
            public E next() {
                return f.apply(self.nextShort());
            }
        };
    }

    @NotNull
    default public FlowShort map(final @NotNull AFunctionI2I f) {
        final FlowShort self = this;
        return new FlowShort(){

            public boolean hasNext() {
                return self.hasNext();
            }

            public short nextShort() {
                return (short)f.apply(self.nextShort());
            }
        };
    }

    @NotNull
    default public FlowShort apply(final AConsumerInt c) {
        final FlowShort self = this;
        return new FlowShort(){

            public boolean hasNext() {
                return self.hasNext();
            }

            public short nextShort() {
                short v = self.nextShort();
                c.accept(v);
                return v;
            }
        };
    }

    default public FlowShort addAllEls(final int ... values) {
        final FlowShort oit = this;
        return new FlowShort(){
            private int index;

            public boolean hasNext() {
                return this.index < values.length || oit.hasNext();
            }

            public short nextShort() {
                if (this.index < values.length) {
                    return (short)values[this.index++];
                }
                return oit.nextShort();
            }
        };
    }

    default public FlowShort addAll(FlowShort values) {
        return this.addAll((ShortIterator)values);
    }

    default public FlowShort addAll(final ShortIterator values) {
        if (!values.hasNext()) {
            return this;
        }
        final FlowShort oit = this;
        return new FlowShort(){

            public boolean hasNext() {
                return values.hasNext() || oit.hasNext();
            }

            public short nextShort() {
                if (values.hasNext()) {
                    return values.nextShort();
                }
                return oit.nextShort();
            }
        };
    }

    default public FlowShort addAll(ShortIterable values) {
        return this.addAll(values.iterator());
    }

    @NotNull
    default public FlowShort flatMap(@NotNull AFunctionL2IterableInt f) {
        return this.flatMap((int e, AConsumerShort c) -> {
            IntIterable ii = f.apply(e);
            if (ii != null) {
                IntIterator iterator = ii.iterator();
                while (iterator.hasNext()) {
                    c.accept((short)iterator.nextInt());
                }
            }
        });
    }

    @NotNull
    default public FlowShort flatMap(@NotNull AFunctionI2Array f) {
        return this.flatMap((int e, AConsumerShort c) -> {
            int[] ii = f.apply(e);
            if (ii != null) {
                for (int v : ii) {
                    c.accept((short)v);
                }
            }
        });
    }

    default public void foreach(AConsumerShort c) {
        while (this.hasNext()) {
            c.accept(this.nextShort());
        }
    }

    @NotNull
    default public FlowShort flatMap(final @NotNull AFunctionL2StreamInt f) {
        final FlowShort self = this;
        return new FlowShort(){
            FlowInt cur;

            public boolean hasNext() {
                while (this.cur == null || !this.cur.hasNext()) {
                    if (this.cur != null) {
                        this.cur = null;
                    }
                    if (!self.hasNext()) {
                        return false;
                    }
                    this.cur = f.apply(self.nextShort());
                }
                return true;
            }

            public short nextShort() {
                return (short)this.cur.nextInt();
            }
        };
    }

    @NotNull
    default public FlowShort flatMap(final @NotNull ABiConsumerI2O<AConsumerShort> f) {
        final FlowShort oit = this;
        final ShortArrayList list = new ShortArrayList();
        final AConsumerShort cc = arg_0 -> ((ShortArrayList)list).add(arg_0);
        return new FlowShort(){
            int pos;

            public boolean hasNext() {
                while (list.isEmpty()) {
                    if (!oit.hasNext()) {
                        return false;
                    }
                    f.accept(oit.nextShort(), cc);
                }
                return true;
            }

            public short nextShort() {
                short res = list.getShort(this.pos++);
                if (this.pos == list.size()) {
                    this.pos = 0;
                    list.clear();
                }
                return res;
            }
        };
    }

    default public int @NotNull [] toIntArray() {
        int[] res = new int[10];
        int i = 0;
        while (this.hasNext()) {
            if (i == res.length) {
                res = Arrays.copyOf(res, (int)((double)res.length * 1.5));
            }
            res[i++] = this.nextShort();
        }
        return Arrays.copyOf(res, i);
    }

    default public short @NotNull [] toArray() {
        short[] res = new short[10];
        int i = 0;
        while (this.hasNext()) {
            if (i == res.length) {
                res = Arrays.copyOf(res, (int)((double)res.length * 1.5));
            }
            res[i++] = this.nextShort();
        }
        return Arrays.copyOf(res, i);
    }

    default public <E extends Collection<Short>> E toCollection(@NotNull E collection) {
        while (this.hasNext()) {
            collection.add(this.nextShort());
        }
        return (E)collection;
    }

    default public <E extends ShortCollection> E toCollection(@NotNull E collection) {
        while (this.hasNext()) {
            collection.add(this.nextShort());
        }
        return collection;
    }

    @NotNull
    default public FlowShort filter(final @Nullable APredicateInt predicate) {
        if (predicate == null) {
            return this;
        }
        final FlowShort oit = this;
        return new FlowShort(){
            short last;
            boolean hasNext;

            public boolean hasNext() {
                if (this.hasNext) {
                    return true;
                }
                while (oit.hasNext()) {
                    this.last = oit.nextShort();
                    if (!predicate.test(this.last)) continue;
                    this.hasNext = true;
                    return true;
                }
                return false;
            }

            public short nextShort() {
                assert (this.hasNext);
                this.hasNext = false;
                return this.last;
            }
        };
    }

    @NotNull
    default public FlowShort filterNot(final @Nullable APredicateInt predicate) {
        if (predicate == null) {
            return this;
        }
        final FlowShort oit = this;
        return new FlowShort(){
            short last;
            boolean hasNext;

            public boolean hasNext() {
                if (this.hasNext) {
                    return true;
                }
                while (oit.hasNext()) {
                    this.last = oit.nextShort();
                    if (predicate.test(this.last)) continue;
                    this.hasNext = true;
                    return true;
                }
                return false;
            }

            public short nextShort() {
                assert (this.hasNext);
                this.hasNext = false;
                return this.last;
            }
        };
    }

    @NotNull
    default public FlowShort ifEmpty(final ARunnable task) {
        if (task == null) {
            return this;
        }
        final FlowShort oit = this;
        return new FlowShort(){
            boolean first = true;

            public boolean hasNext() {
                boolean res = oit.hasNext();
                if (!res && this.first) {
                    task.run();
                }
                this.first = false;
                return res;
            }

            public short nextShort() {
                return oit.nextShort();
            }
        };
    }

    @NotNull
    default public FlowShort ifEmpty(Exception error) {
        return this.ifEmpty(() -> {
            throw error;
        });
    }

    @NotNull
    default public FlowShort ignoreError(final Class<? extends Exception> ee) {
        if (ee == null) {
            return this;
        }
        final FlowShort oit = this;
        return new FlowShort(){
            short last;
            boolean hasNext;

            public boolean hasNext() {
                if (this.hasNext) {
                    return true;
                }
                while (oit.hasNext()) {
                    try {
                        this.last = oit.nextShort();
                        this.hasNext = true;
                        return true;
                    }
                    catch (Exception ex) {
                        if (ee.isInstance(ex)) continue;
                        RU.error(ex);
                    }
                }
                return false;
            }

            public short nextShort() {
                assert (this.hasNext);
                this.hasNext = false;
                return this.last;
            }
        };
    }

    @NotNull
    default public FlowShort sort(@NotNull AComparatorInt comparator) {
        short[] arr = this.toArray();
        FlowShort.quickSort(arr, 0, arr.length, comparator);
        return FlowShort.of(arr);
    }

    @NotNull
    default public ShortIterable toIterable() {
        return () -> this;
    }

    @NotNull
    default public ShortList toList() {
        return new ShortArrayList(this.toArray());
    }

    @NotNull
    default public ShortSet toSet() {
        return new ShortOpenHashSet(this.toArray());
    }

    default public void to(AConsumerInt consumer) {
        while (this.hasNext()) {
            consumer.accept(this.nextShort());
        }
    }

    default public <E> E streamTo(AFunction<FlowShort, E> consumer) {
        return consumer.apply(this);
    }

    @NotNull
    default public ASupplierShort toSupplier() {
        return () -> {
            if (this.hasNext()) {
                return this.nextShort();
            }
            throw new NoSuchElementException();
        };
    }

    @NotNull
    default public <K, V> Map<K, V> toMap(AFunctionL2O<K> keyFactory, AFunctionL2O<V> valFactory) {
        Object2ObjectOpenHashMap res = new Object2ObjectOpenHashMap();
        while (this.hasNext()) {
            short val = this.nextShort();
            res.put(keyFactory.apply(val), valFactory.apply(val));
        }
        return res;
    }

    @NotNull
    default public <V> Int2ObjectMap<V> toMapI2O(AFunctionL2I keyFactory, AFunctionL2O<V> valFactory) {
        Int2ObjectOpenHashMap res = new Int2ObjectOpenHashMap();
        while (this.hasNext()) {
            short val = this.nextShort();
            res.put(keyFactory.apply(val), valFactory.apply(val));
        }
        return res;
    }

    @NotNull
    default public <K> Object2IntMap<K> toMapO2I(AFunctionL2O<K> keyFactory, AFunctionI2I valFactory) {
        Object2IntOpenHashMap res = new Object2IntOpenHashMap();
        while (this.hasNext()) {
            short val = this.nextShort();
            res.put(keyFactory.apply(val), valFactory.apply(val));
        }
        return res;
    }

    @NotNull
    default public <V> Int2ObjectMap<V> toMapL2O(AFunctionI2I keyFactory, AFunctionI2O<V> valFactory) {
        Int2ObjectOpenHashMap res = new Int2ObjectOpenHashMap();
        while (this.hasNext()) {
            short val = this.nextShort();
            res.put(keyFactory.apply(val), valFactory.apply(val));
        }
        return res;
    }

    default public String join(String delimer) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        while (this.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(delimer);
            }
            sb.append(this.nextShort());
        }
        return sb.toString();
    }

    default public FlowShort distinct() {
        return this.filter(new APredicateInt(){
            private final IntSet old = new IntOpenHashSet();

            @Override
            public boolean test2(int value) {
                return this.old.add(value);
            }
        });
    }

    default public String join(AFunctionL2O<Object> preparer, String delimer) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        while (this.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(delimer);
            }
            sb.append(preparer.apply(this.nextShort()));
        }
        return sb.toString();
    }

    default public int getFirstOr(int def) {
        if (this.hasNext()) {
            return this.nextShort();
        }
        return def;
    }

    default public int getFirst() {
        if (this.hasNext()) {
            return this.nextShort();
        }
        throw new NoSuchElementException();
    }

    default public int getFirst(APredicateInt p) {
        return this.filter(p).getFirst();
    }

    default public String join() {
        StringBuilder sb = new StringBuilder();
        while (this.hasNext()) {
            sb.append(this.nextShort());
        }
        return sb.toString();
    }

    default public String join(String delimer, String prefix, String postfix) {
        StringBuilder sb = new StringBuilder(prefix);
        boolean first = true;
        while (this.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(delimer);
            }
            sb.append(this.nextShort());
        }
        sb.append(postfix);
        return sb.toString();
    }

    default public int min(AComparatorInt comparator) {
        int min = Integer.MAX_VALUE;
        while (this.hasNext()) {
            short v = this.nextShort();
            if (comparator.compare(min, v) <= 0) continue;
            min = v;
        }
        return min;
    }

    default public int min() {
        short s;
        int n = Integer.MAX_VALUE;
        while (this.hasNext()) {
            short v = this.nextShort();
            if (s <= v) continue;
            s = v;
        }
        return s;
    }

    default public int max(AComparatorInt comparator) {
        int max = Integer.MIN_VALUE;
        while (this.hasNext()) {
            short v = this.nextShort();
            if (comparator.compare(max, v) >= 0) continue;
            max = v;
        }
        return max;
    }

    default public int max() {
        short s;
        int n = Integer.MIN_VALUE;
        while (this.hasNext()) {
            short v = this.nextShort();
            if (s >= v) continue;
            s = v;
        }
        return s;
    }

    default public int sum() {
        int res = 0;
        while (this.hasNext()) {
            res += this.nextShort();
        }
        return res;
    }

    default public int avg() {
        long sum = 0L;
        int count = 0;
        while (this.hasNext()) {
            sum += (long)this.nextShort();
            ++count;
        }
        return (int)(sum / (long)count);
    }

    default public FlowInt mapToInt() {
        final FlowShort self = this;
        return new FlowInt(){

            public int nextInt() {
                return self.nextShort();
            }

            public boolean hasNext() {
                return self.hasNext();
            }
        };
    }

    @NotNull
    public static FlowShort of(@NotNull FlowShort stream) {
        return stream;
    }

    @NotNull
    public static FlowShort of(final short ... array) {
        if (array.length == 0) {
            return FlowShort.of();
        }
        return new FlowCompletedShort(){
            int pos;

            public boolean hasNext() {
                return this.pos < array.length;
            }

            public short nextShort() {
                return array[this.pos++];
            }

            @Override
            public short @NotNull [] toArray() {
                return array;
            }

            @Override
            public void foreach(AConsumerShort c) {
                for (short v : array) {
                    c.accept(v);
                }
            }

            @Override
            public int count() {
                return array.length;
            }

            @Override
            @NotNull
            public ShortList toList() {
                return new ShortArrayList(array);
            }

            @Override
            @NotNull
            public ASupplierShort toSupplier() {
                return new ASupplierShort(){
                    int pos;

                    @Override
                    public short get2() {
                        if (this.pos == array.length) {
                            throw new NoSuchElementException();
                        }
                        return array[this.pos++];
                    }
                };
            }
        };
    }

    @NotNull
    public static FlowShort of(@NotNull IntIterable iterable) {
        return FlowShort.of(iterable.iterator());
    }

    @NotNull
    public static FlowShort of(final @NotNull ShortSet collection) {
        if (collection.isEmpty()) {
            return FlowShort.of();
        }
        final ShortIterator it = collection.iterator();
        return new FlowCompletedShort(){

            @Override
            public int count() {
                return collection.size();
            }

            public boolean hasNext() {
                return it.hasNext();
            }

            public short nextShort() {
                return it.nextShort();
            }

            @Override
            @NotNull
            public ShortSet toSet() {
                return collection;
            }
        };
    }

    @NotNull
    public static FlowShort of(final @NotNull ShortList collection) {
        if (collection.isEmpty()) {
            return FlowShort.of();
        }
        final ShortListIterator it = collection.iterator();
        return new FlowCompletedShort(){

            @Override
            public int count() {
                return collection.size();
            }

            public boolean hasNext() {
                return it.hasNext();
            }

            public short nextShort() {
                return it.nextShort();
            }

            @Override
            @NotNull
            public ShortList toList() {
                return collection;
            }
        };
    }

    @NotNull
    public static FlowShort of(final @NotNull IntIterator iterator) {
        if (!iterator.hasNext()) {
            return FlowShort.of();
        }
        return new FlowShort(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public short nextShort() {
                return (short)iterator.nextInt();
            }
        };
    }

    public static FlowShort of() {
        return EMPTY;
    }

    public static void quickSort(short[] source, int leftBorder, int rightBorder, AComparatorInt comparator) {
        int leftMarker = leftBorder;
        int rightMarker = rightBorder;
        short pivot = source[(leftMarker + rightMarker) / 2];
        while (true) {
            if (comparator.compare(source[leftMarker], pivot) < 0) {
                ++leftMarker;
                continue;
            }
            while (comparator.compare(source[rightMarker], pivot) > 0) {
                --rightMarker;
            }
            if (leftMarker <= rightMarker) {
                if (leftMarker < rightMarker) {
                    short tmp = source[leftMarker];
                    source[leftMarker] = source[rightMarker];
                    source[rightMarker] = tmp;
                }
                ++leftMarker;
                --rightMarker;
            }
            if (leftMarker > rightMarker) break;
        }
        if (leftMarker < rightBorder) {
            FlowShort.quickSort(source, leftMarker, rightBorder, comparator);
        }
        if (leftBorder < rightMarker) {
            FlowShort.quickSort(source, leftBorder, rightMarker, comparator);
        }
    }
}

