/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.futures;

import io.aether.logger.Log;
import io.aether.utils.flow.Flow;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.AFutureBaseImpl;
import io.aether.utils.futures.ARFuture;
import io.aether.utils.futures.ARFutureImpl;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.interfaces.ARunnable;
import io.aether.utils.interfaces.ASupplier;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

final class AFutureImpl
extends AFutureBaseImpl<AFuture>
implements AFuture {
    static final AFuture DONED;
    static final AFuture CANCELED;
    private static final Object DONE_VALUE;

    AFutureImpl(Throwable e) {
        this.setError(e);
    }

    AFutureImpl() {
    }

    public String toString() {
        return "AFuture(" + (this.isDone() ? "done:" : (this.isError() ? "error:" : (this.isCanceled() ? "canceled" : ""))) + String.valueOf(this.result) + ")";
    }

    @Override
    public AFuture and(AFuture f) {
        return AFutureImpl.all(this, f);
    }

    @Override
    public AFuture apply(ARunnable t) {
        AFutureImpl res = new AFutureImpl();
        this.to(() -> {
            try {
                t.run();
            }
            catch (Throwable e) {
                Log.error(e, new Object[0]);
            }
            res.done();
        });
        return res;
    }

    @Override
    public void done() {
        if (!this.updateStatus(DONE_VALUE)) {
            throw new IllegalStateException();
        }
    }

    @Override
    public boolean tryDone() {
        return this.updateStatus(DONE_VALUE);
    }

    @Override
    public <T> ARFuture<T> mapRFuture(ASupplier<T> t) {
        ARFutureImpl res = new ARFutureImpl();
        this.addListener(f -> {
            if (f.isDone()) {
                res.done(t.get());
            } else if (f.isError()) {
                res.error(f.getError());
            } else if (f.isCanceled()) {
                res.cancel();
            }
        });
        return res;
    }

    @Override
    public <T> ARFuture<T> mapRFutureWithDecomposite(ASupplier<ARFuture<T>> t) {
        ARFuture res = ARFuture.make();
        this.addListener(f -> {
            try {
                ARFuture v = (ARFuture)t.get();
                if (v == null) {
                    res.done(null);
                } else {
                    v.to(res);
                }
            }
            catch (Throwable e) {
                res.error(e);
            }
        });
        return res;
    }

    @Override
    @NotNull
    public AFuture to(@NotNull AFuture f) {
        f.addListener(c -> this.updateStatus(c.getNowRaw()));
        this.addListener(c -> f.updateStatus(c.getNowRaw()));
        return this;
    }

    static AFuture run(Executor executor, AConsumer<AFuture> task) {
        AFutureImpl f = new AFutureImpl();
        executor.execute(() -> {
            try {
                task.accept(f);
                if (!f.isCanceled()) {
                    f.done();
                }
            }
            catch (Throwable e) {
                f.setError(e);
            }
        });
        return f;
    }

    static AFuture run(Executor executor, ARunnable task) {
        AFutureImpl f = new AFutureImpl();
        executor.execute(() -> {
            try {
                if (!f.isCanceled()) {
                    task.run();
                }
                if (!f.isCanceled()) {
                    f.done();
                }
            }
            catch (Throwable e) {
                f.setError(e);
            }
        });
        return f;
    }

    static AFuture any(Collection<AFuture> ff, AConsumer<AFuture> other) {
        if (ff.size() == 1) {
            return ff.iterator().next();
        }
        for (AFuture a : ff) {
            if (!a.isDone()) continue;
            return a;
        }
        AFutureImpl res = new AFutureImpl();
        for (AFuture a : ff) {
            a.addListener(c -> {
                if (!res.isDone() && c.isFinalStatus() && res.updateStatus(((AFutureBaseImpl)((Object)c)).result)) {
                    for (AFuture aa : ff) {
                        if (aa == c) continue;
                        other.accept(aa);
                    }
                }
            });
        }
        return res;
    }

    static AFuture all(AFuture ... ff) {
        if (ff.length == 0) {
            return AFuture.of();
        }
        return AFutureImpl.all((Iterator<AFuture>)ObjectList.of((Object[])ff).iterator());
    }

    static AFuture all(Collection<AFuture> ff) {
        if (ff.isEmpty()) {
            return AFuture.of();
        }
        return AFutureImpl.all(ff.iterator());
    }

    static AFuture all(Iterator<AFuture> ff) {
        AFutureImpl res = new AFutureImpl();
        AFuture[] fff = Flow.flow(ff).toArray(AFuture.class);
        if (fff.length == 0) {
            return AFuture.of();
        }
        AtomicInteger counter = new AtomicInteger(0);
        AConsumer<AFuture> listener = t -> {
            if (res.isFinalStatus()) {
                return;
            }
            if (t.isDone()) {
                if (counter.decrementAndGet() == 0) {
                    res.done();
                }
            } else if (t.isError()) {
                res.setError(t.getError());
            } else if (t.isCanceled()) {
                res.cancel();
            }
        };
        boolean allDone = true;
        for (AFuture aFuture : fff) {
            AFutureBaseImpl implFuture = (AFutureBaseImpl)((Object)aFuture);
            if (implFuture.isFinalStatus()) {
                if (!implFuture.isError() && !implFuture.isCanceled()) continue;
                res.updateStatus(implFuture.getNowRaw());
                return res;
            }
            allDone = false;
            counter.incrementAndGet();
            aFuture.addListener(listener);
        }
        if (allDone) {
            res.done();
        }
        return res;
    }

    static {
        DONE_VALUE = new Object(){

            public String toString() {
                return "DONE";
            }
        };
        DONED = new AFutureImpl();
        DONED.updateStatus(DONE_VALUE);
        CANCELED = new AFutureImpl();
        CANCELED.cancel();
    }
}

