/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.interfaces;

import io.aether.utils.RU;
import java.lang.ref.WeakReference;

public interface A3Consumer<T1, T2, T3> {
    public static final A3Consumer<?, ?, ?> EMPTY = (v1, v2, v3) -> {};

    default public void accept(T1 v1, T2 v2, T3 v3) {
        try {
            this.accept2(v1, v2, v3);
        }
        catch (Throwable e) {
            RU.error(e);
        }
    }

    default public A3Consumer<T1, T2, T3> weak() {
        return new Weak(this);
    }

    public void accept2(T1 var1, T2 var2, T3 var3) throws Throwable;

    public static <E1, E2, E3> A3Consumer<E1, E2, E3> stub() {
        return (A3Consumer)RU.cast(EMPTY);
    }

    public static class Weak<T1, T2, T3>
    implements A3Consumer<T1, T2, T3> {
        final WeakReference<A3Consumer<T1, T2, T3>> ref;

        public Weak(A3Consumer<T1, T2, T3> ref) {
            this.ref = new WeakReference<A3Consumer<T1, T2, T3>>(ref);
        }

        @Override
        public void accept(T1 v1, T2 v2, T3 v3) {
            A3Consumer c = (A3Consumer)this.ref.get();
            if (c != null) {
                c.accept(v1, v2, v3);
            }
        }

        @Override
        public void accept2(T1 v1, T2 v2, T3 v3) {
            A3Consumer c = (A3Consumer)this.ref.get();
            if (c != null) {
                c.accept(v1, v2, v3);
            }
        }

        public boolean isEmptyRef() {
            return this.ref.get() == null;
        }
    }
}

