/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.interfaces;

import io.aether.utils.RU;
import java.lang.ref.WeakReference;
import java.util.function.Consumer;

public interface AConsumer<T>
extends Consumer<T> {
    public static final AConsumer<?> EMPTY = new AConsumer<Object>(){

        public String toString() {
            return "EMPTY_CONSUMER";
        }

        @Override
        public void accept2(Object v) throws Throwable {
        }
    };

    public static <E> AConsumer<E> stub() {
        return (AConsumer)RU.cast(EMPTY);
    }

    @Override
    default public void accept(T v) {
        try {
            this.accept2(v);
        }
        catch (Throwable e) {
            RU.error(e);
        }
    }

    default public AConsumer<T> weak() {
        return new Weak(this);
    }

    public void accept2(T var1) throws Throwable;

    public static class Weak<T>
    implements AConsumer<T> {
        final WeakReference<AConsumer<T>> ref;

        public Weak(AConsumer<T> ref) {
            this.ref = new WeakReference<AConsumer<AConsumer<T>>>(ref);
        }

        @Override
        public void accept(T t) {
            AConsumer c = (AConsumer)this.ref.get();
            if (c != null) {
                c.accept(t);
            }
        }

        @Override
        public void accept2(T v) {
            AConsumer c = (AConsumer)this.ref.get();
            if (c != null) {
                c.accept(v);
            }
        }

        public boolean isEmptyRef() {
            return this.ref.get() == null;
        }
    }
}

