/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.rcollections;

import io.aether.utils.AString;
import io.aether.utils.RU;
import io.aether.utils.ToString;
import io.aether.utils.flow.Flow;
import io.aether.utils.interfaces.AFunction;
import io.aether.utils.rcollections.RCollectionBySrc;
import io.aether.utils.slots.EventConsumer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public interface RCollection<T>
extends Collection<T>,
ToString {
    public EventConsumer<T> forAdd();

    public EventConsumer<T> forRemove();

    @Override
    default public boolean retainAll(@NotNull Collection<?> c) {
        Objects.requireNonNull(c);
        boolean modified = false;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (c.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    default public boolean containsAll(@NotNull Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    default public boolean addAll(@NotNull Collection<? extends T> c) {
        boolean res = false;
        for (T v : c) {
            res |= this.add(v);
        }
        return res;
    }

    @Override
    default public boolean removeAll(@NotNull Collection<?> c) {
        boolean res = false;
        for (Object v : c) {
            res |= this.remove(v);
        }
        return res;
    }

    @Override
    default public void clear() {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            it.remove();
        }
    }

    default public void add0(T val) {
        this.forAdd().fire(val);
    }

    default public void remove0(T val) {
        this.forRemove().fire(val);
    }

    @NotNull
    default public <T2> RCollection<T2> map(final AFunction<T, T2> f, final AFunction<T2, T> f2) {
        final RCollection self = this;
        return new RCollection<T2>(){
            final EventConsumer<T2> forAdd = new EventConsumer();
            final EventConsumer<T2> forRemove = new EventConsumer();

            @Override
            public void toString(AString sb) {
                boolean first = true;
                for (Object e : this) {
                    if (first) {
                        first = false;
                    } else {
                        sb.add(", ");
                    }
                    sb.add(e);
                }
            }

            public String toString() {
                return this.toString2();
            }

            @Override
            public EventConsumer<T2> forAdd() {
                return this.forAdd;
            }

            @Override
            public EventConsumer<T2> forRemove() {
                return this.forRemove;
            }

            @Override
            public int size() {
                return self.size();
            }

            @Override
            public boolean isEmpty() {
                return self.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return self.contains(f2.apply(RU.cast(o)));
            }

            @Override
            @NotNull
            public Iterator<T2> iterator() {
                final Iterator it = self.iterator();
                return new Iterator<T2>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public T2 next() {
                        return f.apply(it.next());
                    }
                };
            }

            @Override
            @NotNull
            public @NotNull Object @NotNull [] toArray() {
                return Flow.flow(this).toArray();
            }

            @Override
            @NotNull
            public <T5> @NotNull T5 @NotNull [] toArray(@NotNull @NotNull T5 @NotNull [] a) {
                return Flow.flow(this).toList().toArray(a);
            }

            @Override
            public boolean add(T2 t2) {
                return self.add(f2.apply(t2));
            }

            @Override
            public boolean remove(Object o) {
                return self.remove(f2.apply(RU.cast(o)));
            }
        };
    }

    public static <E> RCollection<E> of(Collection<E> src) {
        if (src instanceof RCollection) {
            return (RCollection)RU.cast(src);
        }
        return new RCollectionBySrc<E>(src);
    }
}

