/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.rcollections;

import io.aether.utils.AString;
import io.aether.utils.RU;
import io.aether.utils.rcollections.RCollection;
import io.aether.utils.slots.EventConsumer;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class RCollectionBySrc<E>
implements RCollection<E> {
    protected final Collection<E> src;
    final EventConsumer<E> forAdd;
    final EventConsumer<E> forRemove;

    public RCollectionBySrc(Collection<E> src) {
        this.src = src;
        this.forAdd = new EventConsumer();
        this.forRemove = new EventConsumer();
    }

    @Override
    public void toString(AString sb) {
        boolean first = true;
        for (E e : this) {
            if (first) {
                first = false;
            } else {
                sb.add(", ");
            }
            sb.add(e);
        }
    }

    public String toString() {
        return this.toString2();
    }

    @Override
    public int size() {
        return this.src.size();
    }

    @Override
    public EventConsumer<E> forAdd() {
        return this.forAdd;
    }

    @Override
    public EventConsumer<E> forRemove() {
        return this.forRemove;
    }

    @Override
    public boolean equals(Object obj) {
        return this.src.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.src.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.src.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.src.contains(o);
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        final Iterator<E> it = this.src.iterator();
        return new Iterator<E>(){
            E val;

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public E next() {
                this.val = it.next();
                return this.val;
            }

            @Override
            public void remove() {
                RCollectionBySrc.this.remove0(this.val);
                it.remove();
            }
        };
    }

    @Override
    @NotNull
    public @NotNull Object @NotNull [] toArray() {
        return this.src.toArray();
    }

    @Override
    public <T1> T1 @NotNull [] toArray(@NotNull @NotNull T1 @NotNull [] a) {
        return this.src.toArray(a);
    }

    @Override
    public boolean add(E t) {
        if (this.src.add(t)) {
            this.add0(t);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (this.src.remove(o)) {
            this.remove0(RU.cast(o));
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return this.src.containsAll(c);
    }
}

