/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.rcollections;

import io.aether.utils.RU;
import io.aether.utils.rcollections.RCollection;
import io.aether.utils.rcollections.RMap;
import io.aether.utils.rcollections.RSet;
import io.aether.utils.slots.EventConsumer;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RMapBySrc<K, V>
implements RMap<K, V> {
    public final EventConsumer<RMap.Update<K, V>> forUpdate = new EventConsumer();
    public final EventConsumer<Map.Entry<K, V>> forRemove = new EventConsumer();
    private final Map<K, V> src;

    public RMapBySrc(Map<K, V> src) {
        this.src = src;
    }

    @Override
    public EventConsumer<Map.Entry<K, V>> forRemove() {
        return this.forRemove;
    }

    @Override
    public EventConsumer<RMap.Update<K, V>> forUpdate() {
        return this.forUpdate;
    }

    @Override
    public int size() {
        return this.src.size();
    }

    @Override
    public boolean isEmpty() {
        return this.src.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.src.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.src.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.src.get(key);
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        V old = this.src.put(key, value);
        if (old != value) {
            this.forUpdate.fire(new RMap.Update<K, V>(key, value, old));
        }
        return old;
    }

    @Override
    public V remove(Object key) {
        V old = this.src.remove(key);
        this.forRemove.fire((Map.Entry)RU.cast(key));
        return old;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        Iterator it = this.entrySet().iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
    }

    @Override
    @NotNull
    public RSet<K> keySet() {
        return RSet.of(this.src.keySet());
    }

    @Override
    @NotNull
    public RCollection<V> values() {
        return RCollection.of(this.src.values());
    }

    @Override
    @NotNull
    public RSet<Map.Entry<K, V>> entrySet() {
        return RSet.of(this.src.entrySet());
    }
}

