/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.slots;

import io.aether.utils.CTypeI;
import io.aether.utils.RU;
import io.aether.utils.TaskConsumer;
import io.aether.utils.futures.ARFuture;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.interfaces.AFunction;
import io.aether.utils.interfaces.ARunnable;
import io.aether.utils.slots.EventConsumer;
import java.lang.invoke.VarHandle;

public class AMFuture<T>
implements AConsumer<T> {
    protected static final VarHandle UPDATER = CTypeI.of(AMFuture.class).getFieldVarHandle("value");
    public final transient EventConsumer<T> eventConsumer = new EventConsumer();
    protected volatile T value;

    public AMFuture(T value) {
        this.value = value;
    }

    public AMFuture() {
    }

    public void refresh() {
        T v = this.value;
        if (v == null) {
            return;
        }
        this.eventConsumer.fire(v);
    }

    @Override
    public void accept2(T t) {
        this.set(t);
    }

    public boolean set(T value) {
        T vv = this.value;
        if (vv == null) {
            if (UPDATER.compareAndSet(this, null, value)) {
                this.eventConsumer.fire(value);
                return true;
            }
            return this.set(value);
        }
        if (vv == value) {
            return false;
        }
        this.value = value;
        this.eventConsumer.fire(value);
        return true;
    }

    public <V2> AMFuture<V2> map(AFunction<T, V2> f) {
        AMFuture res = new AMFuture();
        this.add(v -> res.set(f.apply(v)));
        T v2 = this.value;
        if (v2 != null) {
            res.set(f.apply(v2));
        }
        return res;
    }

    public void once(AConsumer<T> task, int seconds, ARunnable timeoutTask) {
        this.once(task, (long)seconds * 1000L, timeoutTask);
    }

    public void once(final AConsumer<T> task, long ms, ARunnable timeoutTask) {
        TaskConsumer onceTask = new TaskConsumer<T>(){

            @Override
            protected void runTask(T value) {
                task.accept(value);
            }
        };
        RU.schedule(ms, () -> AMFuture.lambda$once$1(onceTask, timeoutTask));
        this.once(onceTask);
    }

    public void once(TaskConsumer<T> t2) {
        this.eventConsumer.once(t2);
        T v = this.value;
        if (v != null) {
            try {
                t2.accept(v);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                RU.error(e);
            }
        }
    }

    public void toOnce(final AConsumer<T> task) {
        this.once(new TaskConsumer<T>(){

            @Override
            protected void runTask(T value) {
                task.accept(value);
            }
        });
    }

    public void once(final AConsumer<T> task) {
        if (task == this) {
            return;
        }
        TaskConsumer t2 = new TaskConsumer<T>(){

            @Override
            protected void runTask(T value) {
                task.accept(value);
            }
        };
        this.once(t2);
    }

    public void addWeak(AConsumer<T> task) {
        this.add(task.weak());
    }

    public void add(AConsumer<T> task) {
        this.eventConsumer.add(task);
        T v = this.value;
        if (v != null) {
            task.accept(v);
        }
    }

    public T getNow() {
        return this.value;
    }

    public ARFuture<T> mapToARFuture() {
        T v = this.value;
        if (v != null) {
            return ARFuture.of(v);
        }
        ARFuture res = ARFuture.make();
        this.once(res::tryDone);
        return res;
    }

    public boolean isDone() {
        return this.value != null;
    }

    public static <T> AMFuture<T> completed(T value) {
        AMFuture<T> res = new AMFuture<T>();
        res.set(value);
        return res;
    }

    private static /* synthetic */ void lambda$once$1(1 onceTask, ARunnable timeoutTask) throws Throwable {
        if (onceTask.isExecuted()) {
            return;
        }
        timeoutTask.run();
    }
}

