/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.slots;

import io.aether.logger.Log;
import io.aether.utils.ConcurrentHashSet;
import io.aether.utils.TaskConsumer;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.interfaces.ARunnable;
import java.util.Set;

public class EventConsumer<T>
implements AConsumer<T> {
    protected final Set<AConsumer<T>> listeners = new ConcurrentHashSet<AConsumer<T>>();

    public void once(TaskConsumer<T> task) {
        this.add(task);
    }

    public void once(final AConsumer<T> task) {
        this.once(new TaskConsumer<T>(){

            @Override
            protected void runTask(T value) {
                task.accept(value);
            }
        });
    }

    public void add(AConsumer<T> listener) {
        this.listeners.add(Log.wrap(listener));
    }

    public void addRun(ARunnable listener) {
        this.listeners.add(Log.wrap(v -> listener.run()));
    }

    public void remove(AConsumer<T> listener) {
        this.listeners.remove(listener);
    }

    public void fire(T v) {
        for (AConsumer<T> l : this.listeners) {
            l.accept(v);
            if ((!(l instanceof TaskConsumer) || !((TaskConsumer)l).isExecuted()) && (!(l instanceof AConsumer.Weak) || !((AConsumer.Weak)l).isEmptyRef())) continue;
            this.listeners.remove(l);
        }
    }

    @Override
    public void accept(T t) {
        this.fire(t);
    }

    @Override
    public void accept2(T v) {
        this.fire(v);
    }

    public String toString() {
        return "EventConsumer(" + this.listeners.size() + ")";
    }

    public boolean hasListener() {
        return !this.listeners.isEmpty();
    }
}

