package io.aether.utils;

import org.jetbrains.annotations.NotNull;

public class CharSequenceByArray implements CharSequence {
	public final char[] data;
	public final int begin;
	public final int end;
	public CharSequenceByArray(char[] data) {
		this(data, 0, data.length);
	}
	public CharSequenceByArray(char[] data, int begin, int end) {
		this.data = data;
		this.begin = begin;
		this.end = end;
	}
	@Override
	public int length() {
		return end - begin;
	}
	@Override
	public char charAt(int index) {
		return data[begin + index];
	}
	@Override
	public String toString() {
		return new String(data, begin, end - begin);
	}
	@NotNull
	@Override
	public CharSequence subSequence(int start, int end) {
		assert end < data.length - this.begin;
		return new CharSequenceByArray(data, this.begin + start, this.begin + end);
	}
}
