package io.aether.utils;

import io.aether.utils.interfaces.AFunction;

import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentHashMapWithDefault<K, V> extends ConcurrentHashMap<K, V> {
    public ConcurrentHashMapWithDefault(AFunction<K, V> factory) {
        this.factory = factory;
    }

    final AFunction<K, V> factory;

    @Override
    public V get(Object key) {
        var r = super.get(key);
        if (r == null) {
            r = computeIfAbsent(RU.cast(key), factory);
        }
        return r;
    }
}
