package io.aether.utils;

import org.jetbrains.annotations.NotNull;

import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class ConcurrentHashSet<T> implements Set<T> {
	@Override
	public String toString() {
		return body.toString();
	}

	private final Set<T> body;
	public ConcurrentHashSet() {
		body = Collections.newSetFromMap(new ConcurrentHashMap<>());
	}
	public ConcurrentHashSet(Collection<T> c) {
		body = Collections.newSetFromMap(new ConcurrentHashMap<>());
		body.addAll(c);
	}
	@Override
	public int size() {
		return body.size();
	}
	@Override
	public boolean isEmpty() {
		return body.isEmpty();
	}
	@Override
	public boolean contains(Object o) {
		return body.contains(o);
	}
	@NotNull
	@Override
	public Iterator<T> iterator() {
		return body.iterator();
	}
	@NotNull
	@Override
	public Object @NotNull [] toArray() {
		return body.toArray();
	}
	@NotNull
	@Override
	public <T1> T1 @NotNull [] toArray(@NotNull T1 @NotNull [] a) {
		return body.toArray(a);
	}
	@Override
	public boolean add(T t) {
		return body.add(t);
	}
	@Override
	public boolean remove(Object o) {
		return body.remove(o);
	}
	@Override
	public boolean containsAll(@NotNull Collection<?> c) {
		return body.containsAll(c);
	}
	@Override
	public boolean addAll(@NotNull Collection<? extends T> c) {
		return body.addAll(c);
	}
	@Override
	public boolean retainAll(@NotNull Collection<?> c) {
		return body.retainAll(c);
	}
	@Override
	public boolean removeAll(@NotNull Collection<?> c) {
		return body.removeAll(c);
	}
	@Override
	public void clear() {
		body.clear();
	}
	@Override
	public boolean equals(Object o) {
		return body.equals(o);
	}
	@Override
	public int hashCode() {
		return body.hashCode();
	}
	@Override
	public Spliterator<T> spliterator() {
		return body.spliterator();
	}
	@Override
	public <T1> T1[] toArray(IntFunction<T1[]> generator) {
		return body.toArray(generator);
	}
	@Override
	public boolean removeIf(Predicate<? super T> filter) {
		return body.removeIf(filter);
	}
	@Override
	public Stream<T> stream() {
		return body.stream();
	}
	@Override
	public Stream<T> parallelStream() {
		return body.parallelStream();
	}
	@Override
	public void forEach(Consumer<? super T> action) {
		body.forEach(action);
	}
}
