package io.aether.utils;


import io.aether.logger.Log;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class ConsoleReader {
	public static void waitExit() {
		waitExit(()->{});
	}
	public static void waitExit(Runnable onExit) {
		Log.info("Press ENTER for exit");
		try {
			var console = new BufferedReader(new InputStreamReader(System.in));
			while (true) {
				String s;
				try {
					s = console.readLine();
					Log.info(s);
				} catch (IOException e) {
					console.close();
					console = new BufferedReader(new InputStreamReader(System.in));
					continue;
				}
				if (s == null) {
					console.close();
					console = new BufferedReader(new InputStreamReader(System.in));
					continue;
				}
				break;
			}
			onExit.run();
		} catch (Exception e) {
			Log.error(e);
		}
	}
}
