package io.aether.utils;

import io.aether.logger.LNode;
import io.aether.logger.Log;
import io.aether.utils.interfaces.AConsumer;

import java.lang.invoke.VarHandle;

public abstract class TaskConsumer<T> implements AConsumer<T> {
    private static final VarHandle OFFSET_FLAG = CTypeI.of(TaskConsumer.class).getFieldVarHandle("flag");
    private final LNode logContext = Log.createContext();
    private volatile boolean flag;

    @Override
    public void accept(T t) {
        accept2(t);
    }

    public boolean isExecuted() {
        return flag;
    }

    @Override
    public final void accept2(T v) {
        if (OFFSET_FLAG.compareAndSet(this, false, true)) {
            Log.push(logContext);
            try {
                runTask(v);
            } catch (Throwable e) {
                RU.error(e);
            } finally {
                Log.pop(logContext);
            }
        }
    }

    public final void cancel() {
        if (OFFSET_FLAG.compareAndSet(this, false, true)) {
            Log.push(logContext);
            try {
                cancelTask();
            } catch (Throwable e) {
                RU.error(e);
            } finally {
                Log.pop(logContext);
            }
        }
    }

    protected abstract void runTask(T value);

    protected void cancelTask() {
    }
}
