package io.aether.utils;

import io.aether.utils.interfaces.ARunnable;

import java.lang.invoke.VarHandle;

public abstract class TaskRun implements ARunnable {
	private static final VarHandle OFFSET_TASK = CTypeI.of(TaskRun.class).getFieldVarHandle("flag");
	private volatile boolean flag;
	public final void run2() {
		if (OFFSET_TASK.compareAndSet(this, false, true)) {
			try {
				runTask();
			} catch (Throwable e) {
				RU.error(e);
			}
		}
	}
	public final void cancel() {
		if (OFFSET_TASK.compareAndSet(this, false, true)) {
			try {
				cancelTask();
			} catch (Throwable e) {
				RU.error(e);
			}
		}
	}
	protected abstract void runTask();
	protected void cancelTask() {
	}
}
