package io.aether.utils.flow;

import io.aether.utils.AString;
import io.aether.utils.RU;
import io.aether.utils.interfaces.*;
import it.unimi.dsi.fastutil.bytes.*;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;

public interface FlowByte extends ByteIterator, ByteIterable {
	static final byte[] EMPTY_AR = new byte[0];
	FlowByte EMPTY = new FlowCompletedByte() {
		@Override
		public boolean hasNext() {
			return false;
		}
		@Override
		public byte nextByte() {
			return 0;
		}
		@Override
		public int count() {
			return 0;
		}
		@Override
		public byte @NotNull [] toArray() {
			return EMPTY_AR;
		}
		@Override
		public @NotNull ByteList toList() {
			return new ByteArrayList();
		}
		@Override
		public @NotNull <K, V> Map<K, V> toMap(AFunctionB2O<K> keyFactory, AFunctionB2O<V> valFactory) {
			return new Object2ObjectOpenHashMap<>();
		}
	};

    default Flow<Byte> box(){
		var self=this;
		return new Flow<>() {
			@Override
			public boolean hasNext() {
				return self.hasNext();
			}

			@Override
			public Byte next() {
				return self.nextByte();
			}
		};
	}

    @NotNull
	static FlowByte of(@NotNull FlowByte stream) {
		return stream;
	}
	@NotNull
	static FlowByte of(byte... array) {
		if (array.length == 0) return of();
		return new FlowCompletedByte() {
			int pos;
			@Override
			public boolean hasNext() {
				return pos < array.length;
			}
			@Override
			public byte nextByte() {
				return array[pos++];
			}
			@Override
			public byte @NotNull [] toArray() {
				return array;
			}
			@Override
			public void foreach(AConsumer<Byte> c) {
				for (var v : array) {
					c.accept(v);
				}
			}
			@Override
			public int count() {
				return array.length;
			}
			@Override
			public @NotNull ByteList toList() {
				return new ByteArrayList(array);
			}
			@Override
			public @NotNull ASupplierByte toSupplier() {
				return new ASupplierByte() {
					int pos;
					@Override
					public byte get2() {
						if (pos == array.length) throw new NoSuchElementException();
						return array[pos++];
					}
				};
			}
		};
	}
	@NotNull
	static FlowByte of(@NotNull ByteIterable iterable) {
		if (iterable instanceof ByteSet) return of((ByteSet)iterable);
		if (iterable instanceof ByteList) return of((ByteList)iterable);
		return of(iterable.iterator());
	}
	@NotNull
	static FlowByte of(@NotNull ByteSet collection) {
		if (collection.isEmpty()) return of();
		var it = collection.iterator();
		return new FlowCompletedByte() {
			@Override
			public int count() {
				return collection.size();
			}
			@Override
			public boolean hasNext() {
				return it.hasNext();
			}
			@Override
			public byte nextByte() {
				return it.nextByte();
			}
			@Override
			public @NotNull ByteSet toSet() {
				return collection;
			}
		};
	}
	@NotNull
	static FlowByte of(@NotNull ByteList collection) {
		if (collection.isEmpty()) return of();
		var it = collection.iterator();
		return new FlowCompletedByte() {
			@Override
			public int count() {
				return collection.size();
			}
			@Override
			public boolean hasNext() {
				return it.hasNext();
			}
			@Override
			public byte nextByte() {
				return it.nextByte();
			}
			@Override
			public @NotNull ByteList toList() {
				return collection;
			}
		};
	}
	@NotNull
	static FlowByte of(@NotNull ByteIterator iterator) {
		if (!iterator.hasNext()) return of();
		return new FlowByte() {
			@Override
			public boolean hasNext() {
				return iterator.hasNext();
			}
			@Override
			public byte nextByte() {
				return iterator.nextByte();
			}
		};
	}
	static FlowByte of() {
		return EMPTY;
	}
	static void quickSort(byte[] source, int leftBorder, int rightBorder, AComparatorByte comparator) {
		int leftMarker = leftBorder;
		int rightMarker = rightBorder;
		byte pivot = source[(leftMarker + rightMarker) / 2];
		do {
			while (comparator.compare(source[leftMarker], pivot) < 0) {
				leftMarker++;
			}
			while (comparator.compare(source[rightMarker], pivot) > 0) {
				rightMarker--;
			}
			if (leftMarker <= rightMarker) {
				if (leftMarker < rightMarker) {
					byte tmp = source[leftMarker];
					source[leftMarker] = source[rightMarker];
					source[rightMarker] = tmp;
				}
				leftMarker++;
				rightMarker--;
			}
		} while (leftMarker <= rightMarker);
		if (leftMarker < rightBorder) {
			quickSort(source, leftMarker, rightBorder, comparator);
		}
		if (leftBorder < rightMarker) {
			quickSort(source, leftBorder, rightMarker, comparator);
		}
	}
	@NotNull
	@Override
	default ByteIterator iterator() {
		return this;
	}
	default boolean anyMatch(APredicateByte p) {
		while (hasNext()) {
			if (p.test(nextByte())) return true;
		}
		return false;
	}
	default boolean noneMatch(APredicateByte p) {
		while (hasNext()) {
			if (p.test(nextByte())) return false;
		}
		return true;
	}
	default FlowByte add(byte value) {
		final var oit = this;
		return new FlowByte() {
			private boolean index;
			@Override
			public boolean hasNext() {
				return !index || oit.hasNext();
			}
			@Override
			public byte nextByte() {
				if (!index) {
					index = true;
					return value;
				}
				return oit.nextByte();
			}
		};
	}
	default boolean noneMatchValue(byte p) {
		while (hasNext()) {
			if (p == nextByte()) return false;
		}
		return true;
	}
	default boolean anyMatchValue(byte p) {
		while (hasNext()) {
			if (p == nextByte()) return true;
		}
		return false;
	}
	default boolean allMatch(APredicateByte p) {
		while (hasNext()) {
			if (!p.test(nextByte())) return false;
		}
		return true;
	}
	@NotNull
	default <E> Flow<E> map(@NotNull AFunctionL2O<E> f) {
		final var self = this;
		return new Flow<>() {
			@Override
			public boolean hasNext() {
				return self.hasNext();
			}
			@Override
			public E next() {
				return f.apply(self.nextByte());
			}
		};
	}
	@NotNull
	default FlowLong map(@NotNull AFunctionB2L f) {
		final var self = this;
		return new FlowLong() {
			@Override
			public boolean hasNext() {
				return self.hasNext();
			}
			@Override
			public long nextLong() {
				return f.apply(self.nextByte());
			}
		};
	}
	@NotNull
	default FlowByte apply(AConsumerByte c) {
		final var self = this;
		return new FlowByte() {
			@Override
			public boolean hasNext() {
				return self.hasNext();
			}
			@Override
			public byte nextByte() {
				var v = self.nextByte();
				c.accept(v);
				return v;
			}
		};
	}
	@SuppressWarnings("unchecked")
	default FlowByte addAllEls(byte... values) {
		final var oit = this;
		return new FlowByte() {
			private int index;
			@Override
			public boolean hasNext() {
				return index < values.length || oit.hasNext();
			}
			@Override
			public byte nextByte() {
				if (index < values.length) {
					return values[index++];
				}
				return oit.nextByte();
			}
		};
	}
	default FlowByte addAll(FlowByte values) {
		return addAll((ByteIterator) values);
	}
	default FlowByte addAll(ByteIterator values) {
		if (!values.hasNext()) return this;
		final var oit = this;
		return new FlowByte() {
			@Override
			public boolean hasNext() {
				return values.hasNext() || oit.hasNext();
			}
			@Override
			public byte nextByte() {
				if (values.hasNext()) {
					return values.nextByte();
				}
				return oit.nextByte();
			}
		};
	}
	default FlowByte addAll(ByteIterable values) {
		return addAll(values.iterator());
	}
	default void foreach(AConsumer<Byte> c) {
		while (hasNext()) {
			c.accept(nextByte());
		}
	}
	default byte @NotNull [] toArray() {
		byte[] res = new byte[10];
		int i = 0;
		while (hasNext()) {
			if (i == res.length) {
				res = Arrays.copyOf(res, (int) (res.length * 1.5));
			}
			res[i++] = nextByte();
		}
		return Arrays.copyOf(res, i);
	}
	default <E extends Collection<Byte>> E toCollection(@NotNull E collection) {
		while (hasNext()) {
			collection.add(nextByte());
		}
		return collection;
	}
	default <E extends ByteCollection> E toCollection(@NotNull E collection) {
		while (hasNext()) {
			collection.add(nextByte());
		}
		return collection;
	}
	@NotNull
	default FlowByte filter(@Nullable APredicateByte predicate) {
		if (predicate == null) return this;
		var oit = this;
		return new FlowByte() {
			byte last;
			boolean hasNext;
			@Override
			public boolean hasNext() {
				if (hasNext) return true;
				while (oit.hasNext()) {
					last = oit.nextByte();
					if (predicate.test(last)) {
						hasNext = true;
						return true;
					}
				}
				return false;
			}
			@Override
			public byte nextByte() {
				assert hasNext;
				hasNext = false;
				return last;
			}
		};
	}
	@NotNull
	default FlowByte filterNot(@Nullable APredicateByte predicate) {
		if (predicate == null) return this;
		var oit = this;
		return new FlowByte() {
			byte last;
			boolean hasNext;
			@Override
			public boolean hasNext() {
				if (hasNext) return true;
				while (oit.hasNext()) {
					last = oit.nextByte();
					if (!predicate.test(last)) {
						hasNext = true;
						return true;
					}
				}
				return false;
			}
			@Override
			public byte nextByte() {
				assert hasNext;
				hasNext = false;
				return last;
			}
		};
	}
	@NotNull
	default FlowByte ifEmpty(ARunnable task) {
		if (task == null) return this;
		var oit = this;
		return new FlowByte() {
			boolean first = true;
			@Override
			public boolean hasNext() {
				var res = oit.hasNext();
				if (!res && first) {
					task.run();
				}
				first = false;
				return res;
			}
			@Override
			public byte nextByte() {
				return oit.nextByte();
			}
		};
	}
	@NotNull
	default FlowByte ifEmpty(Exception error) {
		return ifEmpty(() -> {
			throw error;
		});
	}
	@NotNull
	default FlowByte ignoreError(Class<? extends Exception> ee) {
		if (ee == null) return this;
		var oit = this;
		return new FlowByte() {
			byte last;
			boolean hasNext;
			@Override
			public boolean hasNext() {
				if (hasNext) return true;
				while (oit.hasNext()) {
					try {
						last = oit.nextByte();
						hasNext = true;
						return true;
					} catch (Exception ex) {
						if (!ee.isInstance(ex)) {
							RU.error(ex);
						}
					}
				}
				return false;
			}
			@Override
			public byte nextByte() {
				assert hasNext;
				hasNext = false;
				return last;
			}
		};
	}
	@NotNull
	default FlowByte sort(@NotNull AComparatorByte comparator) {
		byte[] arr = toArray();
		quickSort(arr, 0, arr.length, comparator);
		return of(arr);
	}
	@NotNull
	default ByteIterable toIterable() {
		return () -> this;
	}
	@NotNull
	default ByteList toList() {
		return new ByteArrayList(toArray());
	}
	@NotNull
	default ByteSet toSet() {
		return new ByteOpenHashSet(toArray());
	}
	default void to(AConsumerByte consumer) {
		while (hasNext()) {
			consumer.accept(nextByte());
		}
	}
	default <E> E streamTo(AFunction<FlowByte, E> consumer) {
		return consumer.apply(this);
	}
	@NotNull
	default ASupplierByte toSupplier() {
		return () -> {
			if (hasNext()) {
				return nextByte();
			}
			throw new NoSuchElementException();
		};
	}
	@NotNull
	default <K, V> Map<K, V> toMap(AFunctionB2O<K> keyFactory, AFunctionB2O<V> valFactory) {
		Object2ObjectOpenHashMap<K, V> res = new Object2ObjectOpenHashMap<>();
		while (hasNext()) {
			var val = nextByte();
			res.put(keyFactory.apply(val), valFactory.apply(val));
		}
		return res;
	}
	@NotNull
	default <V> Int2ObjectMap<V> toMapI2O(AFunctionL2I keyFactory, AFunctionL2O<V> valFactory) {
		Int2ObjectOpenHashMap<V> res = new Int2ObjectOpenHashMap<>();
		while (hasNext()) {
			var val = nextByte();
			res.put(keyFactory.apply(val), valFactory.apply(val));
		}
		return res;
	}
	@NotNull
	default <K> Object2IntMap<K> toMapO2I(AFunctionL2O<K> keyFactory, AFunctionL2I valFactory) {
		Object2IntOpenHashMap<K> res = new Object2IntOpenHashMap<>();
		while (hasNext()) {
			var val = nextByte();
			res.put(keyFactory.apply(val), valFactory.apply(val));
		}
		return res;
	}
	@NotNull
	default <V> Long2ObjectMap<V> toMapL2O(AFunctionB2L keyFactory, AFunctionB2O<V> valFactory) {
		Long2ObjectOpenHashMap<V> res = new Long2ObjectOpenHashMap<>();
		while (hasNext()) {
			var val = nextByte();
			res.put(keyFactory.apply(val), valFactory.apply(val));
		}
		return res;
	}
	default String join(String delimer) {
		return join(AString.of(),delimer).toString();
	}
	default AString join(AString sb,String delimer) {
		var first = true;
		while (hasNext()) {
			if (first){
				first=false;
			}else{
				sb.add(delimer);
			}
			sb.add(nextByte());
		}
		return sb;
	}
	default FlowByte distinct() {
		return filter(new APredicateByte() {
			private final ByteSet old = new ByteOpenHashSet();
			public boolean test2(byte value) {
				return old.add(value);
			}
		});
	}
	default String join(AFunctionL2O<Object> preparer, String delimer) {
		StringBuilder sb = new StringBuilder();
		var first = true;
		while (hasNext()) {
			if (first){
				first=false;
			}else{
				sb.append(delimer);
			}
			sb.append(preparer.apply(nextByte()));
		}
		return sb.toString();
	}
	default byte getFirstOr(byte def) {
		if (hasNext()) return nextByte();
		return def;
	}
	default byte getFirst() {
		if (hasNext()) return nextByte();
		throw new NoSuchElementException();
	}
	default byte getFirst(APredicateByte p) {
		return filter(p).getFirst();
	}
	default String join() {
		StringBuilder sb = new StringBuilder();
		while (hasNext()) {
			sb.append(nextByte());
		}
		return sb.toString();
	}
	default String join(String delimer, String prefix, String postfix) {
		StringBuilder sb = new StringBuilder(prefix);
		var first = true;
		while (hasNext()) {
			if (first){
				first=false;
			}else{
				sb.append(delimer);
			}
			sb.append(nextByte());
		}
		sb.append(postfix);
		return sb.toString();
	}
	default byte min(AComparatorByte comparator) {
		byte min = Byte.MAX_VALUE;
		while (hasNext()) {
			var v = nextByte();
			if (comparator.compare(min, v) > 0) {
				min = v;
			}
		}
		return min;
	}
	default byte max(AComparatorByte comparator) {
		byte max = Byte.MIN_VALUE;
		while (hasNext()) {
			var v = nextByte();
			if (comparator.compare(max, v) < 0) {
				max = v;
			}
		}
		return max;
	}
	default FlowInt mapToUInt() {
		var self = this;
		return new FlowInt() {
			@Override
			public int nextInt() {
				return Byte.toUnsignedInt(self.nextByte());
			}
			@Override
			public boolean hasNext() {
				return self.hasNext();
			}
		};
	}
}
