package io.aether.utils.flow;

import io.aether.utils.interfaces.AFunctionL2O;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.jetbrains.annotations.NotNull;

import java.util.Map;

public interface FlowCompletedLong extends FlowLong {
	int count();
	default FlowCompleted<Long> box() {
		var self = this;
		return new FlowCompleted<>() {
			@Override
			public int count() {
				return self.count();
			}

			@Override
			public boolean hasNext() {
				return self.hasNext();
			}

			@Override
			public Long next() {
				return self.nextLong();
			}
		};
	}

	@Override
	default @NotNull LongList toList() {
		var res = new LongArrayList(count());
		while (hasNext()) {
			res.add(nextLong());
		}
		return res;
	}
	@Override
	default @NotNull <K, V> Map<K, V> toMap(AFunctionL2O<K> keyFactory, AFunctionL2O<V> valFactory) {
		Object2ObjectOpenHashMap<K, V> res = new Object2ObjectOpenHashMap<>(count());
		while (hasNext()) {
			var val = nextLong();
			res.put(keyFactory.apply(val), valFactory.apply(val));
		}
		return res;
	}
	@Override
	default long @NotNull [] toArray() {
		long[] res = new long[count()];
		int i = 0;
		while (hasNext()) {
			res[i++] = nextLong();
		}
		return res;
	}
}
