package io.aether.utils.flow;

import io.aether.utils.interfaces.AFunctionL2O;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import org.jetbrains.annotations.NotNull;

import java.util.Map;

public interface FlowCompletedShort extends FlowShort {
	int count();
	@Override
	default @NotNull ShortList toList() {
		var res = new ShortArrayList(count());
		while (hasNext()) {
			res.add(nextShort());
		}
		return res;
	}
	default Flow<Short> box() {
		var self = this;
		return new FlowCompleted<>() {
			@Override
			public int count() {
				return self.count();
			}

			@Override
			public boolean hasNext() {
				return self.hasNext();
			}

			@Override
			public Short next() {
				return self.nextShort();
			}
		};
	}
	@Override
	default @NotNull <K, V> Map<K, V> toMap(AFunctionL2O<K> keyFactory, AFunctionL2O<V> valFactory) {
		Object2ObjectOpenHashMap<K, V> res = new Object2ObjectOpenHashMap<>(count());
		while (hasNext()) {
			var val = nextShort();
			res.put(keyFactory.apply(val), valFactory.apply(val));
		}
		return res;
	}
	@Override
	default short @NotNull [] toArray() {
		var res = new short[count()];
		int i = 0;
		while (hasNext()) {
			res[i++] = nextShort();
		}
		return res;
	}
}
