package io.aether.utils.flow;

import io.aether.utils.RU;
import io.aether.utils.interfaces.*;
import it.unimi.dsi.fastutil.ints.*;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.shorts.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;

public interface FlowShort extends ShortIterator, ShortIterable {
    static final short[] EMPTY_AR = new short[0];
    FlowShort EMPTY = new FlowCompletedShort() {

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public short nextShort() {
            return 0;
        }

        @Override
        public int count() {
            return 0;
        }

        @Override
        public short @NotNull [] toArray() {
            return EMPTY_AR;
        }

        @Override
        public @NotNull ShortList toList() {
            return new ShortArrayList();
        }

        @Override
        public @NotNull <K, V> Map<K, V> toMap(AFunctionL2O<K> keyFactory, AFunctionL2O<V> valFactory) {
            return new Object2ObjectOpenHashMap<>();
        }
    };

    default Flow<Short> box() {
        var self = this;
        return new Flow<>() {
            @Override
            public boolean hasNext() {
                return self.hasNext();
            }

            @Override
            public Short next() {
                return self.nextShort();
            }
        };
    }

    @NotNull
    @Override
    default ShortIterator iterator() {
        return this;
    }

    default short random() {
        var ar = toArray();
        return ar[Flow.RANDOM.nextInt(ar.length)];
    }

    default boolean anyMatch(APredicateInt p) {
        while (hasNext()) {
            if (p.test(nextShort())) return true;
        }
        return false;
    }

    default boolean noneMatch(APredicateInt p) {
        while (hasNext()) {
            if (p.test(nextShort())) return false;
        }
        return true;
    }

    default FlowShort add(int value) {
        final var oit = this;
        short value2 = (short) value;
        return new FlowShort() {
            private boolean index;

            @Override
            public boolean hasNext() {
                return !index || oit.hasNext();
            }

            @Override
            public short nextShort() {
                if (!index) {
                    index = true;
                    return value2;
                }
                return oit.nextShort();
            }
        };
    }

    default boolean noneMatchValue(int p) {
        while (hasNext()) {
            if (p == nextShort()) return false;
        }
        return true;
    }

    default boolean anyMatchValue(int p) {
        while (hasNext()) {
            if (p == nextShort()) return true;
        }
        return false;
    }

    default boolean allMatch(APredicateInt p) {
        while (hasNext()) {
            if (!p.test(nextShort())) return false;
        }
        return true;
    }

    @NotNull
    default <E> Flow<E> mapToObj(@NotNull AFunctionS2O<E> f) {
        final var self = this;
        return new Flow<>() {
            @Override
            public boolean hasNext() {
                return self.hasNext();
            }

            @Override
            public E next() {
                return f.apply(self.nextShort());
            }
        };
    }

    @NotNull
    default FlowShort map(@NotNull AFunctionI2I f) {
        final var self = this;
        return new FlowShort() {
            @Override
            public boolean hasNext() {
                return self.hasNext();
            }

            @Override
            public short nextShort() {
                return (short) f.apply(self.nextShort());
            }
        };
    }

    @NotNull
    default FlowShort apply(AConsumerInt c) {
        final var self = this;
        return new FlowShort() {
            @Override
            public boolean hasNext() {
                return self.hasNext();
            }

            @Override
            public short nextShort() {
                var v = self.nextShort();
                c.accept(v);
                return v;
            }
        };
    }

    default FlowShort addAllEls(int... values) {
        final var oit = this;
        return new FlowShort() {
            private int index;

            @Override
            public boolean hasNext() {
                return index < values.length || oit.hasNext();
            }

            @Override
            public short nextShort() {
                if (index < values.length) {
                    return (short) values[index++];
                }
                return oit.nextShort();
            }
        };
    }

    default FlowShort addAll(FlowShort values) {
        return addAll((ShortIterator) values);
    }

    default FlowShort addAll(ShortIterator values) {
        if (!values.hasNext()) return this;
        final var oit = this;
        return new FlowShort() {
            @Override
            public boolean hasNext() {
                return values.hasNext() || oit.hasNext();
            }

            @Override
            public short nextShort() {
                if (values.hasNext()) {
                    return values.nextShort();
                }
                return oit.nextShort();
            }
        };
    }

    default FlowShort addAll(ShortIterable values) {
        return addAll(values.iterator());
    }

    @NotNull
    default FlowShort flatMap(@NotNull AFunctionL2IterableInt f) {
        return flatMap((e, c) -> {
            IntIterable ii = f.apply(e);
            if (ii != null) {
                for (IntIterator iterator = ii.iterator(); iterator.hasNext(); ) {
                    c.accept((short) iterator.nextInt());
                }
            }
        });
    }

    @NotNull
    default FlowShort flatMap(@NotNull AFunctionI2Array f) {
        return flatMap((e, c) -> {
            int[] ii = f.apply(e);
            if (ii != null) {
                for (var v : ii) {
                    c.accept((short) v);
                }
            }
        });
    }

    default void foreach(AConsumerShort c) {
        while (hasNext()) {
            c.accept(nextShort());
        }
    }

    @NotNull
    default FlowShort flatMap(@NotNull AFunctionL2StreamInt f) {
        var self = this;
        return new FlowShort() {
            FlowInt cur;

            @Override
            public boolean hasNext() {
                while (cur == null || !cur.hasNext()) {
                    if (cur != null) {
                        cur = null;
                    }
                    if (!self.hasNext()) return false;
                    cur = f.apply(self.nextShort());
                }
                return true;
            }

            @Override
            public short nextShort() {
                return (short) cur.nextInt();
            }
        };
    }

    @NotNull
    default FlowShort flatMap(@NotNull ABiConsumerI2O<AConsumerShort> f) {
        final var oit = this;
        var list = new ShortArrayList();
        final AConsumerShort cc = list::add;
        return new FlowShort() {
            int pos;

            @Override
            public boolean hasNext() {
                while (list.isEmpty()) {
                    if (!oit.hasNext()) return false;
                    f.accept(oit.nextShort(), cc);
                }
                return true;
            }

            @Override
            public short nextShort() {
                var res = list.getShort(pos++);
                if (pos == list.size()) {
                    pos = 0;
                    list.clear();
                }
                return res;
            }
        };
    }

    default int @NotNull [] toIntArray() {
        var res = new int[10];
        int i = 0;
        while (hasNext()) {
            if (i == res.length) {
                res = Arrays.copyOf(res, (int) (res.length * 1.5));
            }
            res[i++] = nextShort();
        }
        return Arrays.copyOf(res, i);
    }

    default short @NotNull [] toArray() {
        var res = new short[10];
        int i = 0;
        while (hasNext()) {
            if (i == res.length) {
                res = Arrays.copyOf(res, (int) (res.length * 1.5));
            }
            res[i++] = nextShort();
        }
        return Arrays.copyOf(res, i);
    }

    default <E extends Collection<Short>> E toCollection(@NotNull E collection) {
        while (hasNext()) {
            collection.add(nextShort());
        }
        return collection;
    }

    default <E extends ShortCollection> E toCollection(@NotNull E collection) {
        while (hasNext()) {
            collection.add(nextShort());
        }
        return collection;
    }

    @NotNull
    default FlowShort filter(@Nullable APredicateInt predicate) {
        if (predicate == null) return this;
        var oit = this;
        return new FlowShort() {
            short last;
            boolean hasNext;

            @Override
            public boolean hasNext() {
                if (hasNext) return true;
                while (oit.hasNext()) {
                    last = oit.nextShort();
                    if (predicate.test(last)) {
                        hasNext = true;
                        return true;
                    }
                }
                return false;
            }

            @Override
            public short nextShort() {
                assert hasNext;
                hasNext = false;
                return last;
            }
        };
    }

    @NotNull
    default FlowShort filterNot(@Nullable APredicateInt predicate) {
        if (predicate == null) return this;
        var oit = this;
        return new FlowShort() {
            short last;
            boolean hasNext;

            @Override
            public boolean hasNext() {
                if (hasNext) return true;
                while (oit.hasNext()) {
                    last = oit.nextShort();
                    if (!predicate.test(last)) {
                        hasNext = true;
                        return true;
                    }
                }
                return false;
            }

            @Override
            public short nextShort() {
                assert hasNext;
                hasNext = false;
                return last;
            }
        };
    }

    @NotNull
    default FlowShort ifEmpty(ARunnable task) {
        if (task == null) return this;
        var oit = this;
        return new FlowShort() {
            boolean first = true;

            @Override
            public boolean hasNext() {
                var res = oit.hasNext();
                if (!res && first) {
                    task.run();
                }
                first = false;
                return res;
            }

            @Override
            public short nextShort() {
                return oit.nextShort();
            }
        };
    }

    @NotNull
    default FlowShort ifEmpty(Exception error) {
        return ifEmpty(() -> {
            throw error;
        });
    }

    @NotNull
    default FlowShort ignoreError(Class<? extends Exception> ee) {
        if (ee == null) return this;
        var oit = this;
        return new FlowShort() {
            short last;
            boolean hasNext;

            @Override
            public boolean hasNext() {
                if (hasNext) return true;
                while (oit.hasNext()) {
                    try {
                        last = oit.nextShort();
                        hasNext = true;
                        return true;
                    } catch (Exception ex) {
                        if (!ee.isInstance(ex)) {
                            RU.error(ex);
                        }
                    }
                }
                return false;
            }

            @Override
            public short nextShort() {
                assert hasNext;
                hasNext = false;
                return last;
            }
        };
    }

    @NotNull
    default FlowShort sort(@NotNull AComparatorInt comparator) {
        short[] arr = toArray();
        quickSort(arr, 0, arr.length, comparator);
        return of(arr);
    }

    @NotNull
    default ShortIterable toIterable() {
        return () -> this;
    }

    @NotNull
    default ShortList toList() {
        return new ShortArrayList(toArray());
    }

    @NotNull
    default ShortSet toSet() {
        return new ShortOpenHashSet(toArray());
    }

    default void to(AConsumerInt consumer) {
        while (hasNext()) {
            consumer.accept(nextShort());
        }
    }

    default <E> E streamTo(AFunction<FlowShort, E> consumer) {
        return consumer.apply(this);
    }

    @NotNull
    default ASupplierShort toSupplier() {
        return () -> {
            if (hasNext()) {
                return nextShort();
            }
            throw new NoSuchElementException();
        };
    }

    @NotNull
    default <K, V> Map<K, V> toMap(AFunctionL2O<K> keyFactory, AFunctionL2O<V> valFactory) {
        Object2ObjectOpenHashMap<K, V> res = new Object2ObjectOpenHashMap<>();
        while (hasNext()) {
            var val = nextShort();
            res.put(keyFactory.apply(val), valFactory.apply(val));
        }
        return res;
    }

    @NotNull
    default <V> Int2ObjectMap<V> toMapI2O(AFunctionL2I keyFactory, AFunctionL2O<V> valFactory) {
        Int2ObjectOpenHashMap<V> res = new Int2ObjectOpenHashMap<>();
        while (hasNext()) {
            var val = nextShort();
            res.put(keyFactory.apply(val), valFactory.apply(val));
        }
        return res;
    }

    @NotNull
    default <K> Object2IntMap<K> toMapO2I(AFunctionL2O<K> keyFactory, AFunctionI2I valFactory) {
        Object2IntOpenHashMap<K> res = new Object2IntOpenHashMap<>();
        while (hasNext()) {
            var val = nextShort();
            res.put(keyFactory.apply(val), valFactory.apply(val));
        }
        return res;
    }

    @NotNull
    default <V> Int2ObjectMap<V> toMapL2O(AFunctionI2I keyFactory, AFunctionI2O<V> valFactory) {
        Int2ObjectOpenHashMap<V> res = new Int2ObjectOpenHashMap<>();
        while (hasNext()) {
            var val = nextShort();
            res.put(keyFactory.apply(val), valFactory.apply(val));
        }
        return res;
    }

    default String join(String delimer) {
        StringBuilder sb = new StringBuilder();
        var first = true;
        while (hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(delimer);
            }
            sb.append(nextShort());
        }
        return sb.toString();
    }

    default FlowShort distinct() {
        return filter(new APredicateInt() {
            private final IntSet old = new IntOpenHashSet();

            public boolean test2(int value) {
                return old.add(value);
            }
        });
    }

    default String join(AFunctionL2O<Object> preparer, String delimer) {
        StringBuilder sb = new StringBuilder();
        var first = true;
        while (hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(delimer);
            }
            sb.append(preparer.apply(nextShort()));
        }
        return sb.toString();
    }

    default int getFirstOr(int def) {
        if (hasNext()) return nextShort();
        return def;
    }

    default int getFirst() {
        if (hasNext()) return nextShort();
        throw new NoSuchElementException();
    }

    default int getFirst(APredicateInt p) {
        return filter(p).getFirst();
    }

    default String join() {
        StringBuilder sb = new StringBuilder();
        while (hasNext()) {
            sb.append(nextShort());
        }
        return sb.toString();
    }

    default String join(String delimer, String prefix, String postfix) {
        StringBuilder sb = new StringBuilder(prefix);
        var first = true;
        while (hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(delimer);
            }
            sb.append(nextShort());
        }
        sb.append(postfix);
        return sb.toString();
    }

    default int min(AComparatorInt comparator) {
        int min = Integer.MAX_VALUE;
        while (hasNext()) {
            var v = nextShort();
            if (comparator.compare(min, v) > 0) {
                min = v;
            }
        }
        return min;
    }

    default int min() {
        int min = Integer.MAX_VALUE;
        while (hasNext()) {
            var v = nextShort();
            if (min > v) {
                min = v;
            }
        }
        return min;
    }

    default int max(AComparatorInt comparator) {
        int max = Integer.MIN_VALUE;
        while (hasNext()) {
            var v = nextShort();
            if (comparator.compare(max, v) < 0) {
                max = v;
            }
        }
        return max;
    }

    default int max() {
        int max = Integer.MIN_VALUE;
        while (hasNext()) {
            var v = nextShort();
            if (max < v) {
                max = v;
            }
        }
        return max;
    }

    default int sum() {
        int res = 0;
        while (hasNext()) {
            res += nextShort();
        }
        return res;
    }

    default int avg() {
        long sum = 0;
        int count = 0;
        while (hasNext()) {
            sum += nextShort();
            count++;
        }
        return (int) (sum / count);
    }

    default FlowInt mapToInt() {
        var self = this;
        return new FlowInt() {
            @Override
            public int nextInt() {
                return self.nextShort();
            }

            @Override
            public boolean hasNext() {
                return self.hasNext();
            }
        };
    }

    @NotNull
    static FlowShort of(@NotNull FlowShort stream) {
        return stream;
    }

    @NotNull
    static FlowShort of(short... array) {
        if (array.length == 0) return of();
        return new FlowCompletedShort() {
            int pos;

            @Override
            public boolean hasNext() {
                return pos < array.length;
            }

            @Override
            public short nextShort() {
                return array[pos++];
            }

            @Override
            public short @NotNull [] toArray() {
                return array;
            }

            @Override
            public void foreach(AConsumerShort c) {
                for (var v : array) {
                    c.accept(v);
                }
            }

            @Override
            public int count() {
                return array.length;
            }

            @Override
            public @NotNull ShortList toList() {
                return new ShortArrayList(array);
            }

            @Override
            public @NotNull ASupplierShort toSupplier() {
                return new ASupplierShort() {
                    int pos;

                    @Override
                    public short get2() {
                        if (pos == array.length) throw new NoSuchElementException();
                        return array[pos++];
                    }
                };
            }
        };
    }

    @NotNull
    static FlowShort of(@NotNull IntIterable iterable) {
//        if (iterable instanceof IntSet) return of((IntSet)iterable);
//        if (iterable instanceof IntList) return of((IntList)iterable);
        return of(iterable.iterator());
    }

    @NotNull
    static FlowShort of(@NotNull ShortSet collection) {
        if (collection.isEmpty()) return of();
        var it = collection.iterator();
        return new FlowCompletedShort() {
            @Override
            public int count() {
                return collection.size();
            }

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public short nextShort() {
                return it.nextShort();
            }

            @Override
            public @NotNull ShortSet toSet() {
                return collection;
            }
        };
    }

    @NotNull
    static FlowShort of(@NotNull ShortList collection) {
        if (collection.isEmpty()) return of();
        var it = collection.iterator();
        return new FlowCompletedShort() {
            @Override
            public int count() {
                return collection.size();
            }

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public short nextShort() {
                return it.nextShort();
            }

            @Override
            public @NotNull ShortList toList() {
                return collection;
            }
        };
    }

    @NotNull
    static FlowShort of(@NotNull IntIterator iterator) {
        if (!iterator.hasNext()) return of();
        return new FlowShort() {
            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public short nextShort() {
                return (short) iterator.nextInt();
            }
        };
    }

    static FlowShort of() {
        return EMPTY;
    }

    static void quickSort(short[] source, int leftBorder, int rightBorder, AComparatorInt comparator) {
        int leftMarker = leftBorder;
        int rightMarker = rightBorder;
        int pivot = source[(leftMarker + rightMarker) / 2];
        do {
            while (comparator.compare(source[leftMarker], pivot) < 0) {
                leftMarker++;
            }
            while (comparator.compare(source[rightMarker], pivot) > 0) {
                rightMarker--;
            }
            if (leftMarker <= rightMarker) {
                if (leftMarker < rightMarker) {
                    short tmp = source[leftMarker];
                    source[leftMarker] = source[rightMarker];
                    source[rightMarker] = tmp;
                }
                leftMarker++;
                rightMarker--;
            }
        } while (leftMarker <= rightMarker);
        if (leftMarker < rightBorder) {
            quickSort(source, leftMarker, rightBorder, comparator);
        }
        if (leftBorder < rightMarker) {
            quickSort(source, leftBorder, rightMarker, comparator);
        }
    }
}
