package io.aether.utils.interfaces;

import io.aether.utils.RU;

import java.lang.ref.WeakReference;

public interface A3Consumer<T1, T2, T3> {
    A3Consumer<?, ?, ?> EMPTY = (v1,v2,v3) -> {
    };

    default void accept(T1 v1, T2 v2, T3 v3) {
        try {
            accept2(v1, v2, v3);
        } catch (Throwable e) {
            RU.error(e);
        }
    }

    default A3Consumer<T1, T2, T3> weak() {
        return new Weak<>(this);
    }

    void accept2(T1 v1, T2 v2, T3 v3) throws Throwable;

    static <E1, E2, E3> A3Consumer<E1, E2, E3> stub() {
        return RU.cast(EMPTY);
    }

    class Weak<T1, T2, T3> implements A3Consumer<T1, T2, T3> {
        final WeakReference<A3Consumer<T1, T2, T3>> ref;

        public Weak(A3Consumer<T1, T2, T3> ref) {
            this.ref = new WeakReference<>(ref);
        }

        @Override
        public void accept(T1 v1, T2 v2, T3 v3) {
            var c = ref.get();
            if (c != null) c.accept(v1, v2, v3);
        }

        @Override
        public void accept2(T1 v1, T2 v2, T3 v3) {
            var c = ref.get();
            if (c != null) c.accept(v1, v2, v3);
        }

        public boolean isEmptyRef() {
            return ref.get() == null;
        }

    }
}
