package io.aether.utils.interfaces;

import io.aether.utils.RU;

import java.lang.ref.WeakReference;
import java.util.function.Consumer;

public interface AConsumer<T> extends Consumer<T> {
	AConsumer<?> EMPTY = new AConsumer<Object>() {
		@Override
		public String toString() {
			return "EMPTY_CONSUMER";
		}

		@Override
        public void accept2(Object v) throws Throwable {
        }
    };
	static <E> AConsumer<E> stub() {
		return RU.cast(EMPTY);
	}
	@Override
	default void accept(T v) {
		try {
			accept2(v);
		} catch (Throwable e) {
			RU.error(e);
		}
	}
	default AConsumer<T> weak(){
		return new Weak<>(this);
	}
	void accept2(T v) throws Throwable;
	class Weak<T> implements AConsumer<T> {
		final WeakReference<AConsumer<T>> ref;
		public Weak(AConsumer<T>ref) {
			this.ref = new WeakReference<>( ref);
		}

		@Override
		public void accept(T t) {
			var c=ref.get();
			if(c!=null)c.accept(t);
		}

		@Override
		public void accept2(T v) {
			var c=ref.get();
			if(c!=null)c.accept(v);
		}

		public boolean isEmptyRef() {
			return ref.get()==null;
		}

	}
}
