package io.aether.utils.rcollections;

import io.aether.utils.AString;
import io.aether.utils.RU;
import io.aether.utils.slots.EventConsumer;
import org.jetbrains.annotations.NotNull;

import java.util.Collection;
import java.util.Iterator;

public class RCollectionBySrc<E> implements RCollection<E> {
    protected final Collection<E> src;
    final EventConsumer<E> forAdd;
    final EventConsumer<E> forRemove;

    public RCollectionBySrc(Collection<E> src) {
        this.src = src;
        forAdd = new EventConsumer<>();
        forRemove = new EventConsumer<>();
    }

    @Override
    public void toString(AString sb) {
        boolean first = true;
        for (var e : this) {
            if (first) {
                first = false;
            } else {
                sb.add(", ");
            }
            sb.add(e);
        }
    }

    @Override
    public String toString() {
        return toString2();
    }

    @Override
    public int size() {
        return src.size();
    }

    @Override
    public EventConsumer<E> forAdd() {
        return forAdd;
    }

    @Override
    public EventConsumer<E> forRemove() {
        return forRemove;
    }

    @Override
    public boolean equals(Object obj) {
        return src.equals(obj);
    }

    @Override
    public int hashCode() {
        return src.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return src.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return src.contains(o);
    }

    @Override
    public @NotNull Iterator<E> iterator() {
        var it = src.iterator();
        return new Iterator<E>() {
            E val;

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public E next() {
                val = it.next();
                return val;
            }

            @Override
            public void remove() {
                remove0(val);
                it.remove();
            }
        };
    }

    @Override
    public @NotNull Object @NotNull [] toArray() {
        return src.toArray();
    }

    @Override
    public <T1> T1 @NotNull [] toArray(@NotNull T1 @NotNull [] a) {
        return src.toArray(a);
    }

    @Override
    public boolean add(E t) {
        if (src.add(t)) {
            add0(t);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (src.remove(o)) {
            remove0(RU.cast(o));
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return src.containsAll(c);
    }


}
