package io.aether.utils.slots;

import io.aether.utils.ConcurrentHashSet;
import io.aether.utils.interfaces.ABiConsumer;
import io.aether.utils.interfaces.ARunnable;

import java.util.Set;

public class EventBiConsumer<T1, T2> {
    private final Set<ABiConsumer<T1, T2>> listeners = new ConcurrentHashSet<>();

    public void add(ABiConsumer<T1, T2> listener) {
        listeners.add(listener);
    }

    public void remove(ABiConsumer<T1, T2> listener) {
        listeners.remove(listener);
    }

    public void fire(T1 v1, T2 v2) {
        for (var l : listeners) {
            l.accept(v1, v2);
        }
    }

    public boolean hasListener() {
        return !listeners.isEmpty();
    }

    public void addRun(ARunnable task) {
        add((v1, v2) -> {
            task.run();
        });
    }
}
