package io.aether.utils.slots;

import io.aether.logger.Log;
import io.aether.utils.ConcurrentHashSet;
import io.aether.utils.TaskConsumer;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.interfaces.ARunnable;

import java.util.Set;

public class EventConsumer<T> implements AConsumer<T> {
    protected final Set<AConsumer<T>> listeners = new ConcurrentHashSet<>();

    public void once(TaskConsumer<T> task) {
        add(task);
    }

    public void once(AConsumer<T> task) {
        once(new TaskConsumer<>() {
            @Override
            protected void runTask(T value) {
                task.accept(value);
            }
        });
    }

    public void add(AConsumer<T> listener) {
        listeners.add(Log.wrap(listener));
    }
    public void addRun(ARunnable listener) {
        listeners.add(Log.wrap((AConsumer<T>) v->listener.run()));
    }

    public void remove(AConsumer<T> listener) {
        listeners.remove(listener);
    }

    public void fire(T v) {
        for (AConsumer<T> l : listeners) {
            l.accept(v);
            if ((l instanceof TaskConsumer && ((TaskConsumer<?>) l).isExecuted()) || l instanceof AConsumer.Weak && ((Weak<T>) l).isEmptyRef()) {
                listeners.remove(l);
            }
        }
    }

    @Override
    public void accept(T t) {
        fire(t);
    }

    @Override
    public void accept2(T v) {
        fire(v);
    }

    @Override
    public String toString() {
        return "EventConsumer("+listeners.size()+")";
    }

    public boolean hasListener() {
        return !listeners.isEmpty();
    }
}
