package io.aether.utils.slots;

import io.aether.utils.RU;
import io.aether.utils.TaskConsumer;
import io.aether.utils.interfaces.AConsumer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class EventConsumerWithQueue<T> extends EventConsumer<T> {
    final Queue<T> queue = new ConcurrentLinkedQueue<>();

    public void add(AConsumer<T> listener) {
        listeners.add(listener);
        RU.readAll(queue, listener);
    }

    public void fire(T v) {
        queue.add(v);
        var it = listeners.iterator();
        if(it.hasNext()){
            var qq=new ObjectArrayList<T>();
            RU.readAll(queue, qq::add);
            while (it.hasNext()) {
                var l = it.next();
                for(var q:qq){
                    l.accept(q);
                }
                if ((l instanceof TaskConsumer && ((TaskConsumer<?>) l).isExecuted()) || l instanceof AConsumer.Weak && ((Weak<T>) l).isEmptyRef()) {
                    it.remove();
                }
            }
        }
    }

}
