package io.aether.utils.tuples;

public class Tuple2<T1, T2> extends Tuple{
    private final T1 val1;
    private final T2 val2;

    public T1 val1() {
        return val1;
    }

    public T2 val2() {
        return val2;
    }

    public Tuple2(T1 val1, T2 val2) {
        this.val1 = val1;
        this.val2 = val2;
    }

    @Override
    public String toString() {
        return "["+ val1 +
               ", " + val2 +
               ']';
    }

    public static <T1,T2>Tuple2<T1, T2> of(T1 val1, T2 val2) {
        return new Tuple2<>(val1,val2);
    }
}
