/*
 * Decompiled with CFR 0.152.
 */
package io.aether.logger;

import io.aether.logger.Log;
import io.aether.logger.LogImpl;
import io.aether.utils.AString;
import io.aether.utils.RU;
import io.aether.utils.flow.Flow;
import io.aether.utils.interfaces.ABiConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.ref.Reference;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class LNode {
    public static final LNode EMPTY = new LNode(){

        @Override
        public int count() {
            return 0;
        }

        @Override
        public void foreach(Set<String> exclude, ABiConsumer<String, Object> c) {
        }

        @Override
        protected Object get(String key, Set<LNode> old) {
            return null;
        }

        @Override
        public Object get(String key) {
            return null;
        }
    };
    public final long id = LogImpl.ID_COUNTER.getAndIncrement();

    public boolean contains(String key) {
        return this.get(key) != null;
    }

    public boolean msgContains(String c) {
        return this.getMsg().contains(c);
    }

    public boolean messageContains(String c) {
        return this.getMessage().indexOf(c) >= 0;
    }

    public AString getMessage() {
        return this.getMessage(Set.of());
    }

    public String getMsg() {
        return String.valueOf(this.get("logMessage"));
    }

    public AString getMessage(Set<String> keys) {
        AString sb = AString.of();
        this.printMessage(sb, keys, null, null);
        return sb;
    }

    public void printMessage(AString w, Set<String> keys, String color, String defaultColor) {
        try {
            String msg = (String)this.getCast("logMessage");
            if (msg == null) {
                return;
            }
            w.addVars((CharSequence)msg, k -> {
                String kk = k.toString();
                keys.add(k.toString());
                return this.get(kk);
            });
            Throwable e = this.getException();
            if (e != null) {
                w.add(" [");
                w.addStackTrace(e);
                w.add("]");
            }
        }
        catch (Exception e) {
            w.add("error print message: ").addStackTrace(e);
        }
    }

    public Map<String, Object> toMap() {
        Object2ObjectArrayMap map = new Object2ObjectArrayMap();
        HashSet<String> s = new HashSet<String>();
        this.foreach(s, ((Map)map)::put);
        return map;
    }

    public String toString() {
        AString sb = AString.of();
        Log.Level l = (Log.Level)((Object)this.getCast("logLevel"));
        if (l != null) {
            sb.add(String.valueOf(this.get("logLevel")));
            sb.add(" ");
        }
        HashSet<String> exclude = new HashSet<String>();
        exclude.add("logLevel");
        exclude.add("logMessage");
        this.printMessage(sb, exclude, null, null);
        sb.add(" ");
        this.foreach(exclude, (k, v) -> {
            sb.add((String)k).add(" = ");
            sb.add(v);
            sb.add(", ");
        });
        return sb.toString();
    }

    public <T> T getCast(String key) {
        return RU.cast(this.get(key));
    }

    public Object getSystemComponent() {
        return this.get("SystemComponent");
    }

    public boolean checkSystemComponent(Object val) {
        return Objects.equals(this.getSystemComponent(), val);
    }

    protected abstract Object get(String var1, Set<LNode> var2);

    public Object get(String key) {
        return this.get(key, new HashSet<LNode>());
    }

    public abstract int count();

    public abstract void foreach(Set<String> var1, ABiConsumer<String, Object> var2);

    public boolean isTrace() {
        return this.check("logLevel", (Object)Log.Level.TRACE);
    }

    public boolean isDebug() {
        return this.check("logLevel", (Object)Log.Level.DEBUG);
    }

    public boolean isInfo() {
        return this.check("logLevel", (Object)Log.Level.INFO);
    }

    public boolean isWarn() {
        return this.check("logLevel", (Object)Log.Level.WARN);
    }

    public boolean isError() {
        return this.check("logLevel", (Object)Log.Level.ERROR);
    }

    public boolean check(Object key, Object value) {
        return Objects.equals(this.get(String.valueOf(key)), value);
    }

    public boolean isEmpty() {
        return this.count() == 0;
    }

    public Throwable getException() {
        Throwable res = (Throwable)this.getCast("exception");
        if (res == null) {
            res = (Throwable)this.getCast("error");
        }
        return res;
    }

    public Log.Level getLevel() {
        return (Log.Level)((Object)this.getCast("logLevel"));
    }

    public void set(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    public static LNode of(LNode data) {
        return data;
    }

    public static LNode of(final Object ... data) {
        if (data.length == 0) {
            return EMPTY;
        }
        assert (data.length % 2 == 0);
        for (int i = 0; i < data.length; i += 2) {
            if (data[i] == null) {
                ObjectArrayList l = new ObjectArrayList(data.length);
                for (int i2 = 0; i2 < data.length; i2 += 2) {
                    if (data[i] == null || data[i + 1] == null) continue;
                    l.add(data[i]);
                    l.add(data[i + 1]);
                }
                return LNode.of(l.toArray());
            }
            if (data[i] instanceof String) continue;
            throw new IllegalStateException();
        }
        return new LNode(){

            @Override
            public void foreach(Set<String> exclude, ABiConsumer<String, Object> c) {
                for (int i = 0; i < data.length; i += 2) {
                    String k = String.valueOf(data[i]);
                    if (!exclude.add(k)) continue;
                    c.accept(k, data[i + 1]);
                }
            }

            @Override
            protected Object get(String key, Set<LNode> old) {
                for (int i = 0; i < data.length; i += 2) {
                    String k = String.valueOf(data[i]);
                    if (!Objects.equals(k, key)) continue;
                    Object res = data[i + 1];
                    if (res instanceof Reference) {
                        res = ((Reference)res).get();
                    }
                    return res;
                }
                return null;
            }

            @Override
            public int count() {
                return data.length / 2;
            }
        };
    }

    public static LNode ofMulti(LNode ... data) {
        int count = 0;
        if (data == null || data.length == 0) {
            return EMPTY;
        }
        if (data.length == 1) {
            if (data[0] == null) {
                return EMPTY;
            }
            return data[0];
        }
        for (LNode e : data) {
            if (e == null || e == EMPTY) {
                data = Flow.flow(data).filterExclude(EMPTY).filterNotNull().toArray(LNode.class);
                return LNode.ofMulti(Flow.flow(data).filterNotNull().toArray(LNode.class));
            }
            count += e.count();
        }
        final int finalCount = count;
        final LNode[] finalData1 = data;
        if (count == 0) {
            return EMPTY;
        }
        return new LNode(){

            @Override
            public void foreach(Set<String> exclude, ABiConsumer<String, Object> c) {
                for (LNode n : finalData1) {
                    n.foreach(exclude, c);
                }
            }

            @Override
            protected Object get(String key, Set<LNode> old) {
                for (LNode n : finalData1) {
                    if (!old.add(n)) continue;
                    Object res = n.get(key, old);
                    if (res instanceof Reference) {
                        res = ((Reference)res).get();
                    }
                    if (res == null) continue;
                    return res;
                }
                return null;
            }

            @Override
            public int count() {
                return finalCount;
            }
        };
    }

    public static LNode ofMulti(final Collection<LNode> data) {
        int count = 0;
        for (LNode e : data) {
            count += e.count();
        }
        final int finalCount = count;
        return new LNode(){

            @Override
            public void foreach(Set<String> exclude, ABiConsumer<String, Object> c) {
                for (LNode n : data) {
                    n.foreach(exclude, c);
                }
            }

            @Override
            protected Object get(String key, Set<LNode> old) {
                for (LNode n : data) {
                    if (!old.add(n)) continue;
                    Object res = n.get(key, old);
                    if (res instanceof Reference) {
                        res = ((Reference)res).get();
                    }
                    if (res == null) continue;
                    return res;
                }
                return null;
            }

            @Override
            public int count() {
                return finalCount;
            }
        };
    }

    public static LNode of2(final Object[] keys, final Object[] vals) {
        if (keys.length != vals.length) {
            Log.warn("bad node", "keys", keys, "vals", vals);
            return EMPTY;
        }
        return new LNode(){

            @Override
            public void foreach(Set<String> exclude, ABiConsumer<String, Object> c) {
                for (int i = 0; i < keys.length; ++i) {
                    String k = String.valueOf(keys[i]);
                    if (!exclude.add(k)) continue;
                    Object v = vals[i];
                    c.accept(k, v);
                }
            }

            @Override
            protected Object get(String key, Set<LNode> old) {
                for (int i = 0; i < keys.length; ++i) {
                    String k = String.valueOf(keys[i]);
                    if (!Objects.equals(k, key)) continue;
                    Object res = vals[i];
                    if (res instanceof Reference) {
                        res = ((Reference)res).get();
                    }
                    return res;
                }
                return null;
            }

            @Override
            public int count() {
                return keys.length;
            }
        };
    }

    public static LNode of2(final List<? extends CharSequence> keys, final List<?> vals) {
        if (keys.size() != vals.size()) {
            Log.warn("bad node", "keys", keys, "vals", vals);
            return EMPTY;
        }
        return new LNode(){

            @Override
            public void foreach(Set<String> exclude, ABiConsumer<String, Object> c) {
                for (int i = 0; i < keys.size(); ++i) {
                    String k = String.valueOf(keys.get(i));
                    if (!exclude.add(k)) continue;
                    Object v = vals.get(i);
                    c.accept(k, v);
                }
            }

            @Override
            protected Object get(String key, Set<LNode> old) {
                for (int i = 0; i < keys.size(); ++i) {
                    String k = String.valueOf(keys.get(i));
                    if (!Objects.equals(k, key)) continue;
                    Object res = vals.get(i);
                    if (res instanceof Reference) {
                        res = ((Reference)res).get();
                    }
                    return res;
                }
                return null;
            }

            @Override
            public int count() {
                return keys.size();
            }
        };
    }

    public static LNode ofMap(Map<String, ?> map) {
        return new NodeMap(map);
    }

    public static LNode ofMap() {
        return LNode.ofMap(new ConcurrentHashMap());
    }

    public static class NodeMap
    extends LNode {
        private final Map<String, ?> map;

        public NodeMap() {
            this(new ConcurrentHashMap());
        }

        public NodeMap(Map<String, ?> map) {
            this.map = map;
        }

        @Override
        public void foreach(Set<String> exclude, ABiConsumer<String, Object> c) {
            for (Map.Entry<String, ?> e : this.map.entrySet()) {
                String k = e.getKey();
                if (!exclude.add(k)) continue;
                Object v = e.getValue();
                c.accept(k, v);
            }
        }

        @Override
        public void set(String key, Object val) {
            this.map.put(key, RU.cast(val));
        }

        @Override
        protected Object get(String key, Set<LNode> old) {
            return this.map.get(key);
        }

        @Override
        public Object get(String key) {
            return this.map.get(key);
        }

        @Override
        public int count() {
            return this.map.size();
        }
    }
}

