/*
 * Decompiled with CFR 0.152.
 */
package io.aether.logger;

import io.aether.logger.LNode;
import io.aether.logger.Log;
import io.aether.logger.LogFilter;
import io.aether.logger.LogPrinter;
import io.aether.logger.LogWrapper;
import io.aether.utils.AString;
import io.aether.utils.CTypeI;
import io.aether.utils.RU;
import io.aether.utils.ToString;
import io.aether.utils.interfaces.ABiConsumer;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.interfaces.AFunction;
import io.aether.utils.interfaces.APredicate;
import io.aether.utils.interfaces.ARunnable;
import io.aether.utils.interfaces.ASupplier;
import io.aether.utils.interfaces.ObjectFind;
import io.aether.utils.slots.EventConsumer;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.ArrayDeque;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

class LogImpl {
    static final LogFilter filter = new LogFilter();
    static final EventConsumer<LNode> onEvent = new EventConsumer();
    static final AtomicLong ID_COUNTER = new AtomicLong();
    static final AtomicReference<LogPrinter[]> consolePrinter = new AtomicReference();
    static final Iterator<String> EMPTY_ITERATOR = new Iterator<String>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public String next() {
            return null;
        }
    };
    private static final Set<String> SET_STUB = new SetStub();
    private static final ThreadLocal<Map<String, WeakReference<LNode>>> namedNodes = ThreadLocal.withInitial(HashMap::new);
    public static boolean ENABLED = true;
    public static ThreadLocal<Deque<LNode>> stack = ThreadLocal.withInitial(ArrayDeque::new);

    LogImpl() {
    }

    public static void storeNode(String name, LNode n) {
        if (!ENABLED) {
            return;
        }
        namedNodes.get().put(name, new WeakReference<LNode>(n));
    }

    public static void setStored(String nameNode, String key, Object value) {
        if (!ENABLED) {
            return;
        }
        WeakReference<LNode> nr = namedNodes.get().get(nameNode);
        if (nr == null) {
            return;
        }
        LNode n = (LNode)nr.get();
        if (n == null) {
            return;
        }
        n.set(key, value);
    }

    public static Deque<LNode> getStack() {
        return stack.get();
    }

    public static AutoCloseable addListener(LogFilter filter, AConsumer<LNode> consumer) {
        AConsumer<LNode> c = n -> {
            if (filter.predicate.test((LNode)n)) {
                consumer.accept(filter.dropFields((LNode)n));
            }
        };
        onEvent.add(c);
        return () -> onEvent.remove(c);
    }

    public static LNode createContext(Object ... data) {
        if (!ENABLED) {
            return LNode.EMPTY;
        }
        return LNode.ofMulti(LNode.of(data), LogImpl.get());
    }

    public static LNode createContext(LNode ... data) {
        if (!ENABLED) {
            return LNode.EMPTY;
        }
        return LNode.ofMulti(LNode.ofMulti(data), LogImpl.get());
    }

    public static LNode createContext() {
        if (!ENABLED) {
            return LNode.EMPTY;
        }
        return LogImpl.get();
    }

    public static Log.LogAutoClose context(Object ... data) {
        if (!ENABLED) {
            return Log.LogAutoClose.EMPTY;
        }
        LNode n = LogImpl.push0(data);
        return () -> LogImpl.pop(n);
    }

    public static Log.LogAutoClose context(LNode parent, Object ... addData) {
        if (!ENABLED) {
            return Log.LogAutoClose.EMPTY;
        }
        return LogImpl.context(LogImpl.of(addData), parent);
    }

    public static Log.LogAutoClose context(LNode ... nn) {
        if (!ENABLED) {
            return Log.LogAutoClose.EMPTY;
        }
        if (nn == null || nn.length == 0 || nn.length == 1 && nn[0] == null) {
            return () -> {};
        }
        LNode n = LNode.ofMulti(nn);
        LogImpl.push(n);
        return () -> LogImpl.pop(n);
    }

    public static Log.LogAutoClose context(LNode n) {
        if (!ENABLED) {
            return Log.LogAutoClose.EMPTY;
        }
        if (n == null || n == LNode.EMPTY) {
            return () -> {};
        }
        LogImpl.push(n);
        return () -> LogImpl.pop(n);
    }

    private static LNode push0(Object ... data) {
        LNode n = LNode.of(data);
        LogImpl.push(n);
        return n;
    }

    public static void push(LNode n) {
        if (!ENABLED) {
            return;
        }
        if (n == null) {
            throw new IllegalStateException();
        }
        Deque<LNode> q = stack.get();
        if (q == null) {
            q = new LinkedList<LNode>();
            stack.set(q);
        }
        q.addFirst(n);
    }

    public static LNode get() {
        if (!ENABLED) {
            return LNode.EMPTY;
        }
        Deque<LNode> q = stack.get();
        if (q == null || q.isEmpty()) {
            return LNode.EMPTY;
        }
        if (q.size() == 1) {
            return q.getFirst();
        }
        return LNode.ofMulti(q.toArray(new LNode[0]));
    }

    public static Executor wrapExecutor(Executor executor) {
        if (!ENABLED) {
            return executor;
        }
        return new LogExecutor(executor);
    }

    public static ARunnable wrapRunnable(ARunnable t, Object ... data) {
        if (!ENABLED) {
            return t;
        }
        LNode l = LogImpl.createContext(data);
        if (l == null || l.isEmpty()) {
            return t;
        }
        return new ARunnableWrapper(l, t);
    }

    public static void pop(LNode n) {
        if (!ENABLED) {
            return;
        }
        Deque<LNode> q = stack.get();
        if (q.removeFirst() != n) {
            throw new IllegalStateException();
        }
    }

    public static <T> ASupplier<T> wrapSupplier(ASupplier<T> t) {
        if (!ENABLED) {
            return t;
        }
        LNode l = LogImpl.get();
        return new ASupplierWrapper<T>(l, t);
    }

    public static <T> ASupplier<T> wrap(ASupplier<T> t) {
        if (!ENABLED) {
            return t;
        }
        return LogImpl.wrapSupplier(t);
    }

    public static ARunnable wrap(ARunnable t) {
        if (!ENABLED) {
            return t;
        }
        LNode l = LogImpl.get();
        return new ARunnableWrapper(l, t);
    }

    public static <T> AConsumer<T> wrap(AConsumer<T> t) {
        if (!ENABLED) {
            return t;
        }
        LNode l = LogImpl.get();
        return new AConsumerWrapper<T>(l, t);
    }

    public static <T, T2> ABiConsumer<T, T2> wrap(ABiConsumer<T, T2> t) {
        if (!ENABLED) {
            return t;
        }
        LNode l = LogImpl.get();
        return new ABiConsumerWrapper<T, T2>(l, t);
    }

    public static <T, R> AFunction<T, R> wrap(AFunction<T, R> t) {
        if (!ENABLED) {
            return t;
        }
        LNode l = LogImpl.get();
        return new AFunctionWrapper<T, R>(l, t);
    }

    public static void log(LNode node) {
        if (!ENABLED) {
            return;
        }
        assert (node != null);
        if (LogImpl.filter.predicate.test(node)) {
            onEvent.fire(LNode.ofMulti(node, LNode.of("logTime", new Date())));
        }
    }

    private static void log0(LNode node) {
        if (!ENABLED) {
            return;
        }
        assert (node != null);
        if (LogImpl.filter.predicate.test(node)) {
            onEvent.fire(node);
        }
    }

    private static LNode log(Log.Level level, String msg, LNode ... data) {
        return LogImpl.log(level, msg, LogImpl.of(data));
    }

    private static LNode log(Log.Level level, String msg, LNode data) {
        LNode[] nn;
        if (!ENABLED) {
            return LNode.EMPTY;
        }
        Deque<LNode> q = stack.get();
        if (q == null) {
            nn = new LNode[]{data, LNode.of(new Object[]{"logTime", new Date(), "logLevel", level, "logMessage", msg})};
        } else {
            nn = new LNode[2 + q.size()];
            nn[0] = data;
            nn[1] = LNode.of(new Object[]{"logTime", new Date(), "logLevel", level, "logMessage", msg});
            Iterator<LNode> it = q.iterator();
            int i = 2;
            while (it.hasNext()) {
                nn[i++] = it.next();
            }
        }
        LNode n = LNode.ofMulti(nn);
        LogImpl.log0(n);
        return n;
    }

    public static LNode trace(ToString msg, Object ... data) {
        return LogImpl.trace(msg.toString2(), data);
    }

    public static LNode trace(String msg, LNode ... data) {
        return LogImpl.trace(msg, LogImpl.of(data));
    }

    public static LNode trace(String msg, LNode data) {
        if (!ENABLED) {
            return LNode.EMPTY;
        }
        return LogImpl.log(Log.Level.TRACE, msg, data);
    }

    public static LNode trace(String msg, Object ... data) {
        if (!ENABLED) {
            return LNode.EMPTY;
        }
        return LogImpl.log(Log.Level.TRACE, msg, LogImpl.of(data));
    }

    public static LNode debug(ToString msg, Object ... data) {
        return LogImpl.debug(msg.toString2(), data);
    }

    public static LNode debug(String msg, Object ... data) {
        return LogImpl.debug(msg, LogImpl.of(data));
    }

    public static LNode debug(String msg, LNode ... data) {
        return LogImpl.debug(msg, LogImpl.of(data));
    }

    public static LNode debug(String msg, LNode data) {
        if (!ENABLED) {
            return LNode.EMPTY;
        }
        return LogImpl.log(Log.Level.DEBUG, msg, data);
    }

    public static LNode info(ToString msg, Object ... data) {
        return LogImpl.info(msg.toString2(), LogImpl.of(data));
    }

    public static LNode info(String msg, Object ... data) {
        return LogImpl.info(msg, LogImpl.of(data));
    }

    public static LNode info(String msg, LNode ... data) {
        return LogImpl.info(msg, LogImpl.of(data));
    }

    public static LNode info(String msg, LNode data) {
        if (!ENABLED) {
            return LNode.EMPTY;
        }
        return LogImpl.log(Log.Level.INFO, msg, data);
    }

    public static LNode warn(ToString msg, Object ... data) {
        return LogImpl.warn(msg.toString2(), data);
    }

    public static LNode warn(String msg, Object ... data) {
        return LogImpl.warn(msg, LogImpl.of(data));
    }

    public static LNode warn(String msg, LNode ... data) {
        return LogImpl.warn(msg, LogImpl.of(data));
    }

    public static LNode warn(String msg, LNode data) {
        if (!ENABLED) {
            return LNode.EMPTY;
        }
        return LogImpl.log(Log.Level.WARN, msg, data);
    }

    public static LNode warn(String msg, Throwable throwable, Object ... data) {
        if (!ENABLED) {
            return LNode.EMPTY;
        }
        LNode n = LNode.ofMulti(LNode.of(new Object[]{"logTime", new Date(), "logLevel", Log.Level.WARN, "error", throwable, "logMessage", msg}), LNode.of(data), LogImpl.get());
        LogImpl.log0(n);
        return n;
    }

    public static LNode error(String msg, Throwable throwable, Object ... data) {
        LNode n = LNode.ofMulti(LNode.of(new Object[]{"logTime", new Date(), "logLevel", Log.Level.ERROR, "exception", throwable, "logMessage", msg}), LNode.of(data), LogImpl.get());
        LogImpl.log0(n);
        return n;
    }

    public static LNode error(String msg, Object ... data) {
        LNode n = LNode.ofMulti(LNode.of(new Object[]{"logTime", new Date(), "logLevel", Log.Level.ERROR, "logMessage", msg}), LNode.of(data), LogImpl.get());
        LogImpl.log0(n);
        return n;
    }

    public static LNode error(Throwable throwable, Object ... data) {
        return LogImpl.error(throwable.getMessage(), throwable, data);
    }

    public static void addFilterNot(APredicate<LNode> p) {
        filter.not(p);
    }

    public static void addFilter(APredicate<LNode> p) {
        filter.filter(p);
    }

    public static LogPrinter printConsoleColored() {
        return LogImpl.printConsoleColored(new LogFilter());
    }

    public static LogPrinter printConsoleColored(LogFilter filter) {
        LogPrinter[] ar = consolePrinter.get();
        if (ar != null) {
            return ar[0];
        }
        ar = new LogPrinter[1];
        if (consolePrinter.compareAndSet(null, ar)) {
            LogPrinter printer;
            ar[0] = printer = new LogPrinter(new LogPrinter.Column[]{LogPrinter.col("logTime", v -> Log.DATE_FORMAT.format((Date)v)), LogPrinter.splitter(" "), LogPrinter.col("logLevel").min(5), LogPrinter.splitter("\u2502"), LogPrinter.col("SystemComponent").minAuto().min(10), LogPrinter.splitter("\u2502"), LogPrinter.col("logMessage", (o, n, kk) -> n.printMessage(o, kk, null, null)).min(100), LogPrinter.splitter("  "), LogPrinter.colAll()}, filter){

                @Override
                public AString printNode(AString s, LNode n) {
                    s = s.limitByteArrays(50);
                    switch (n.getLevel()) {
                        case TRACE: {
                            s.styleForeground(null, 150, 150, 150);
                            break;
                        }
                        case DEBUG: {
                            s.styleForeground(null, 100, 255, 100);
                            break;
                        }
                        case INFO: {
                            s.styleForeground(null, 100, 100, 255);
                            break;
                        }
                        case WARN: {
                            s.styleForeground(null, 255, 50, 50);
                            break;
                        }
                        case ERROR: {
                            s.styleForeground(null, 255, 0, 0);
                        }
                    }
                    AString res = super.printNode(s, n);
                    s.styleClear();
                    return res;
                }
            };
            return printer;
        }
        return ar[0];
    }

    public static LogPrinter printPlainConsole(LogFilter filter) {
        LogPrinter[] ar = new LogPrinter[1];
        if (consolePrinter.compareAndSet(null, ar)) {
            LogPrinter printer;
            ar[0] = printer = new LogPrinter(new LogPrinter.Column[]{LogPrinter.col("logTime", v -> Log.DATE_FORMAT.format((Date)v)), LogPrinter.splitter(" "), LogPrinter.col("logLevel").min(5), LogPrinter.splitter("\u2502"), LogPrinter.col("SystemComponent").minAuto().min(10), LogPrinter.splitter("\u2502"), LogPrinter.col("logMessage", (o, n, kk) -> n.printMessage(o, kk, null, null)).min(100), LogPrinter.colAll()}, filter);
            return printer;
        }
        return ar[0];
    }

    public static LNode of(Object ... data) {
        if (!ENABLED) {
            return LNode.EMPTY;
        }
        return LNode.of(data);
    }

    public static LNode of(LNode data) {
        return data;
    }

    public static LNode of2(Object[] keys, Object[] vals) {
        return LNode.of2(keys, vals);
    }

    public static LNode of2(List<? extends CharSequence> keys, List<?> vals) {
        return LNode.of2(keys, vals);
    }

    public static LNode ofMap(Map<String, ?> vals) {
        return LNode.ofMap(vals);
    }

    public static LNode of(LNode ... data) {
        if (!ENABLED) {
            return LNode.EMPTY;
        }
        return LNode.ofMulti(data);
    }

    public static void loggerOff() {
        ENABLED = false;
    }

    public static void loggerOn() {
        ENABLED = true;
    }

    private static class ASupplierWrapper<T>
    implements ASupplier<T>,
    LogWrapper {
        private final LNode l;
        private final ASupplier<T> t;

        public ASupplierWrapper(LNode l, ASupplier<T> t) {
            this.l = l;
            this.t = t;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ASupplierWrapper) {
                return this.t.equals(((ASupplierWrapper)obj).t);
            }
            return obj.equals(this.t);
        }

        public int hashCode() {
            return this.t.hashCode();
        }

        @Override
        public T get2() throws Exception {
            LogImpl.push(this.l);
            try {
                T t = this.t.get();
                return t;
            }
            finally {
                LogImpl.pop(this.l);
            }
        }
    }

    private static class ARunnableWrapper
    implements ARunnable,
    LogWrapper {
        private final LNode l;
        private final ARunnable t;

        public ARunnableWrapper(LNode l, ARunnable t) {
            this.l = l;
            this.t = t;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ARunnableWrapper) {
                return this.t.equals(((ARunnableWrapper)obj).t);
            }
            return obj.equals(this.t);
        }

        public int hashCode() {
            return this.t.hashCode();
        }

        @Override
        public void run2() throws Throwable {
            LogImpl.push(this.l);
            try {
                this.t.run();
            }
            finally {
                LogImpl.pop(this.l);
            }
        }
    }

    private static class AFunctionWrapper<T, R>
    implements AFunction<T, R>,
    LogWrapper {
        private final LNode l;
        private final AFunction<T, R> t;

        public AFunctionWrapper(LNode l, AFunction<T, R> t) {
            this.l = l;
            this.t = t;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof AFunctionWrapper) {
                return this.t.equals(((AFunctionWrapper)obj).t);
            }
            return obj.equals(this.t);
        }

        public int hashCode() {
            return this.t.hashCode();
        }

        @Override
        public R apply2(T v) throws Throwable {
            LogImpl.push(this.l);
            try {
                R r = this.t.apply(v);
                return r;
            }
            finally {
                LogImpl.pop(this.l);
            }
        }
    }

    private static class ABiConsumerWrapper<T, T2>
    implements ABiConsumer<T, T2>,
    LogWrapper {
        private final LNode l;
        private final ABiConsumer<T, T2> t;

        public ABiConsumerWrapper(LNode l, ABiConsumer<T, T2> t) {
            this.l = l;
            this.t = t;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ABiConsumerWrapper) {
                return this.t.equals(((ABiConsumerWrapper)obj).t);
            }
            return obj.equals(this.t);
        }

        public int hashCode() {
            return this.t.hashCode();
        }

        @Override
        public void accept2(T v, T2 v2) throws Throwable {
            LogImpl.push(this.l);
            try {
                this.t.accept(v, v2);
            }
            finally {
                LogImpl.pop(this.l);
            }
        }
    }

    private static class AConsumerWrapper<T>
    implements AConsumer<T>,
    LogWrapper {
        private final LNode l;
        private final AConsumer<T> t;

        public AConsumerWrapper(LNode l, AConsumer<T> t) {
            this.l = l;
            this.t = t;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof AConsumerWrapper) {
                return this.t.equals(((AConsumerWrapper)obj).t);
            }
            return obj.equals(this.t);
        }

        public int hashCode() {
            return this.t.hashCode();
        }

        @Override
        public void accept2(T v) throws Throwable {
            LogImpl.push(this.l);
            try {
                this.t.accept(v);
            }
            finally {
                LogImpl.pop(this.l);
            }
        }
    }

    private static class LogExecutor
    implements Executor,
    ObjectFind {
        private final Executor executor;

        public LogExecutor(Executor executor) {
            this.executor = executor;
        }

        @Override
        public <T> T find(Class<T> type) {
            if (type.isInstance(this)) {
                return RU.cast(this);
            }
            if (type.isInstance(this.executor)) {
                return type.cast(this.executor);
            }
            if (this.executor instanceof ObjectFind) {
                return ((ObjectFind)((Object)this.executor)).find(type);
            }
            return null;
        }

        @Override
        public <T> T find(CTypeI<T> type) {
            if (type.isInstance(this)) {
                return RU.cast(this);
            }
            if (type.isInstance(this.executor)) {
                return type.cast(this.executor);
            }
            if (this.executor instanceof ObjectFind) {
                return ((ObjectFind)((Object)this.executor)).find(type);
            }
            return null;
        }

        @Override
        public void execute(@NotNull Runnable command) {
            Deque<LNode> q = stack.get();
            if (q == null || q.isEmpty()) {
                this.executor.execute(() -> {
                    try {
                        command.run();
                    }
                    catch (Throwable e) {
                        Log.error(e, new Object[0]);
                        RU.error(e);
                    }
                });
            } else {
                LNode nn = LogImpl.get();
                this.executor.execute(() -> {
                    LogImpl.push(nn);
                    try {
                        command.run();
                    }
                    catch (Throwable e) {
                        Log.error(e, new Object[0]);
                    }
                    finally {
                        LogImpl.pop(nn);
                    }
                });
            }
        }
    }

    private static class SetStub
    extends AbstractSet<String> {
        private SetStub() {
        }

        @Override
        @NotNull
        public Iterator<String> iterator() {
            return EMPTY_ITERATOR;
        }

        @Override
        public boolean add(String s) {
            return true;
        }

        @Override
        public int size() {
            return 0;
        }
    }
}

