/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils;

import io.aether.utils.AString;
import io.aether.utils.CType;
import io.aether.utils.RU;
import io.aether.utils.ToString;
import io.aether.utils.flow.Flow;
import io.aether.utils.interfaces.ASupplier;
import io.leangen.geantyref.AnnotationFormatException;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeFactory;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.VarHandle;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jdk.jfr.Unsigned;
import org.jetbrains.annotations.NotNull;

public interface CTypeI<T>
extends ToString {
    public static final Unsigned UNSIGNED;
    public static final CTypeI<Byte> UBYTE;
    public static final CTypeI<Short> USHORT;
    public static final CTypeI<Integer> UINT;
    public static final CTypeI<Long> ULONG;
    public static final String CLASS_NAME;
    public static final CTypeI<String> STRING;
    public static final CTypeI<Character> CHAR;
    public static final CTypeI<Character> CHAR_BOX;
    public static final CTypeI<Boolean> BOOLEAN;
    public static final CTypeI<Boolean> BOOLEAN_BOX;
    public static final CTypeI<Byte> BYTE;
    public static final CTypeI<Byte> BYTE_BOX;
    public static final CTypeI<Short> SHORT;
    public static final CTypeI<Short> SHORT_BOX;
    public static final CTypeI<Integer> INT;
    public static final CTypeI<Integer> INT_BOX;
    public static final CTypeI<Long> LONG;
    public static final CTypeI<Long> LONG_BOX;
    public static final CTypeI<Float> FLOAT;
    public static final CTypeI<Float> FLOAT_BOX;
    public static final CTypeI<Double> DOUBLE;
    public static final CTypeI<Double> DOUBLE_BOX;
    public static final CTypeI<byte[]> BYTE_ARR;
    public static final CTypeI<boolean[]> BOOLEAN_ARR;
    public static final CTypeI<short[]> SHORT_ARR;
    public static final CTypeI<int[]> INT_ARR;
    public static final CTypeI<long[]> LONG_ARR;
    public static final CTypeI<float[]> FLOAT_ARR;
    public static final CTypeI<double[]> DOUBLE_ARR;

    public boolean mutable();

    public <FT> FieldAccessor<FT> getFieldAccessor(String var1);

    public <FT> FieldAccessor<FT> getFieldAccessor(Field var1);

    public CTypeI<T> addAnnotations(Annotation ... var1);

    public String getRawSimpleNameWithParameters();

    public void getRawSimpleNameWithParameters(AString var1);

    public CharSequence getCanonicalNameWithParameters();

    public void getCanonicalNameWithParameters(AString var1);

    public String getRawSimpleName();

    public String declareCode();

    public String toId();

    public Class<T> getRaw();

    public Class<?> getRaw2();

    public boolean instanceOf(Type var1);

    public boolean instanceOf(CTypeI<?> var1);

    public boolean instanceOf(AnnotatedType var1);

    @NotNull
    public Type toType();

    @NotNull
    public AnnotatedType toAnnotatedType();

    public CTypeI<Object> getComponent();

    public CTypeI<Object> getComponentByName(String var1);

    public CTypeI<Object> getComponent(int var1);

    public CTypeI<Object> getComponent(Class<?> var1, int var2);

    public boolean isAnnotated(Class<? extends Annotation> var1);

    public <A extends Annotation> A getAnnotation(Class<A> var1);

    public boolean isArray();

    public boolean isPrimitive();

    public boolean isNumber();

    public boolean isEnum();

    public boolean isInterface();

    public TypeVariable<?>[] getGenericVariables();

    public Flow<Method> getMethods();

    public Flow<Field> getAllFields();

    public Flow<Method> getAllMethods();

    public Flow<Field> getFields();

    public Annotation[] getAnnotations();

    public CTypeI<?> resolveReturnType(Method var1);

    public CTypeI<?>[] resolveTypeArgs(Method var1);

    public CTypeI<?> resolveExtend(CTypeI<Object> var1);

    public CTypeI<?> resolveTypeField(Field var1);

    public boolean isBoxedPrimitive();

    public boolean isBoxedOrRawPrimitive();

    public CTypeI<T> toPrimitive();

    public CTypeI<T> unbox();

    public CTypeI<Object>[] getParameters();

    public CTypeI<? super T> getParent();

    public CTypeI<? extends T>[] getChildrenClasses();

    public void getAllDependencies(Set<CTypeI<?>> var1, boolean var2);

    public Flow<CTypeI<? extends T>> getAllChildrenClasses();

    public boolean isAbstract();

    public CTypeI<T> tryToBox();

    public Flow<CTypeI<?>> getInterfaces();

    public T makeAuto(Object ... var1);

    public VarHandle getFieldVarHandle(Field var1);

    public VarHandle getFieldVarHandle(String var1);

    public ASupplier<?> maker();

    public Constructor<?> getConstructor(Class<?> ... var1);

    public MethodHandle maker(Class<?> ... var1);

    public Enum<?>[] getEnumValues();

    public boolean isAetherClass();

    public String getCanonicalName();

    public boolean isParametrizedClass();

    public boolean isVariable();

    public boolean isParameterizedType();

    public String getPackage();

    public boolean isInstance(Object var1);

    public boolean compareValues(T var1, T var2, CompareEvent var3);

    public CTypeI<T[]> toArray();

    public <C> CTypeI<C> cast();

    public ClassLoader getClassLoader();

    public T cast(Object var1);

    public static <T> CTypeI<T> of(Class<T> type) {
        return CTypeI.of(type);
    }

    public static <T> CTypeI<T> of(Type type) {
        if (!2.$assertionsDisabled && type == null) {
            throw new AssertionError();
        }
        CType res = CType.CACHE1.get(type);
        res = type instanceof TypeVariable ? new CType.WType<Object>((TypeVariable)type) : new CType.PType<Object>(type);
        CType.CACHE1.put(type, res);
        return (CTypeI)RU.cast(res);
    }

    public static <T> CTypeI<T> of(AnnotatedType type) {
        return new CType.AType(type);
    }

    public static <T> CTypeI<T> of(Annotation aa, Class<T> type, AnnotatedType ... args) {
        return CTypeI.of(TypeFactory.parameterizedAnnotatedClass(type, (Annotation[])new Annotation[]{aa}, (AnnotatedType[])args));
    }

    public static CTypeI<Object> of(Annotation[] aa, Class<?> type, AnnotatedType ... args) {
        return CTypeI.of(TypeFactory.parameterizedAnnotatedClass(type, (Annotation[])aa, (AnnotatedType[])args));
    }

    public static <T> CTypeI<T> of(Annotation[] aa, Class<T> type, Type ... args) {
        if (aa.length == 0) {
            return CTypeI.of(type, args);
        }
        return CTypeI.of(TypeFactory.parameterizedAnnotatedClass(type, (Annotation[])aa, (AnnotatedType[])Flow.flow(args).map(GenericTypeReflector::annotate).toArray(AnnotatedType.class)));
    }

    public static <T> CTypeI<T> of(Annotation[] aa, Type type) {
        return CTypeI.of(GenericTypeReflector.annotate((Type)type, (Annotation[])aa));
    }

    public static <T> CTypeI<T> of(Annotation[] aa, CTypeI<T> type) {
        Annotation[] aaa = type.getAnnotations();
        if (aaa == null || aaa.length == 0) {
            aaa = aa;
        } else {
            HashSet aaaSet = new HashSet();
            Collections.addAll(aaaSet, aaa);
            Collections.addAll(aaaSet, aa);
            aaa = aaaSet.toArray(new Annotation[0]);
        }
        return CTypeI.of(GenericTypeReflector.updateAnnotations((AnnotatedType)type.toAnnotatedType(), (Annotation[])aaa));
    }

    public static <T> CTypeI<T> of(Class<? super T> raw, Type ... args) {
        if (args.length == 0) {
            return CTypeI.of(raw);
        }
        return CTypeI.of(TypeFactory.parameterizedClass(raw, (Type[])args));
    }

    public static <T> CTypeI<T> of(Class<? super T> raw, CTypeI<?> ... args) {
        return CTypeI.of(TypeFactory.parameterizedAnnotatedClass(raw, (Annotation[])new Annotation[0], (AnnotatedType[])Flow.flow(args).map(CTypeI::tryToBox).map(CTypeI::toAnnotatedType).toArray(AnnotatedType.class)));
    }

    public static <T> CTypeI<T> of(AnnotatedType raw, AnnotatedType[] args) {
        return CTypeI.of(TypeFactory.parameterizedAnnotatedClass(CTypeI.of(raw).getRaw(), (Annotation[])raw.getAnnotations(), (AnnotatedType[])args));
    }

    public static <T> CTypeI<T> of(AnnotatedType raw, CTypeI<Object>[] args) {
        return CTypeI.of(TypeFactory.parameterizedAnnotatedClass(CTypeI.of(raw).getRaw(), (Annotation[])raw.getAnnotations(), (AnnotatedType[])Flow.flow(args).map(CTypeI::toAnnotatedType).toArray(AnnotatedType.class)));
    }

    public static <T> CTypeI<T[]> buildArray(Type component) {
        return CTypeI.of(TypeFactory.arrayOf((Type)component));
    }

    public static <T> CTypeI<T[]> buildArray(AnnotatedType component, Annotation[] annotations) {
        return CTypeI.of(TypeFactory.arrayOf((AnnotatedType)component, (Annotation[])annotations));
    }

    public static <T> CTypeI<T[]> buildArray(CTypeI<T> component) {
        return CTypeI.of(TypeFactory.arrayOf((AnnotatedType)component.toAnnotatedType(), (Annotation[])new Annotation[0]));
    }

    public static CTypeI<Object> buildArray(CTypeI<Object> component, Annotation[] annotations) {
        return CTypeI.of(TypeFactory.arrayOf((AnnotatedType)component.toAnnotatedType(), (Annotation[])annotations));
    }

    public static <T> CTypeI<T> of(Type res, List<Type> pp) {
        return (CTypeI)RU.cast(CTypeI.of((Class)res, pp.toArray(new Type[0])));
    }

    public static String annotationToCode(Annotation a) {
        StringBuilder sb = new StringBuilder();
        CTypeI.annotationToCode(sb, a);
        return sb.toString();
    }

    public static String annotationToBuildCode(Annotation a) {
        StringBuilder sb = new StringBuilder();
        CTypeI.annotationToCode(sb, a);
        return sb.toString();
    }

    public static void annotationToBuildCode(StringBuilder sb, Annotation a) {
        sb.append(CLASS_NAME).append(".annotation(").append(a.annotationType().getCanonicalName()).append(".class,").append(Map.class.getCanonicalName()).append(".of(");
        Method[] mm = a.annotationType().getDeclaredMethods();
        boolean first = true;
        try {
            for (Method m : mm) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                m.setAccessible(true);
                Class<?> rt = m.getReturnType();
                Object v = m.invoke((Object)a, new Object[0]);
                if (v == null) continue;
                sb.append("\"").append(m.getName()).append("\"");
                sb.append(',');
                if (rt.isArray()) {
                    sb.append("new ").append(CTypeI.of(rt).declareCode()).append("[]");
                    sb.append("{");
                    boolean first1 = true;
                    System.exit(1);
                    for (int i = 0; i < Array.getLength(v); ++i) {
                        if (first1) {
                            first1 = false;
                            continue;
                        }
                        sb.append(",");
                    }
                    sb.append("}");
                    continue;
                }
                if (Annotation.class.isAssignableFrom(rt)) {
                    CTypeI.annotationToCode(sb, (Annotation)v);
                    continue;
                }
                if (rt == String.class) {
                    sb.append('\"');
                    sb.append(String.valueOf(v).replaceAll("([\"\\\\])", "\\$1"));
                    sb.append('\"');
                    continue;
                }
                sb.append(v);
            }
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        sb.append("))");
    }

    public static void annotationToCode(StringBuilder sb, Annotation a) {
        block21: {
            sb.append('@');
            Class<? extends Annotation> t = a.annotationType();
            sb.append(t.getCanonicalName());
            try {
                Method[] mm = t.getDeclaredMethods();
                if (mm.length <= 0) break block21;
                sb.append('(');
                boolean first = true;
                for (Method m : mm) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(',');
                    }
                    m.setAccessible(true);
                    Class<?> rt = m.getReturnType();
                    Object v = m.invoke((Object)a, new Object[0]);
                    if (v == null) continue;
                    sb.append(m.getName());
                    sb.append('=');
                    if (rt.isArray()) {
                        int i;
                        sb.append('{');
                        rt = rt.getComponentType();
                        boolean first2 = true;
                        if (Annotation.class.isAssignableFrom(rt)) {
                            for (i = 0; i < Array.getLength(v); ++i) {
                                if (first2) {
                                    first2 = false;
                                } else {
                                    sb.append(',');
                                }
                                CTypeI.annotationToCode(sb, (Annotation)v);
                            }
                        } else if (rt == String.class) {
                            for (i = 0; i < Array.getLength(v); ++i) {
                                if (first2) {
                                    first2 = false;
                                } else {
                                    sb.append(',');
                                }
                                sb.append('\"');
                                sb.append(v);
                                sb.append('\"');
                            }
                        } else {
                            for (i = 0; i < Array.getLength(v); ++i) {
                                if (first2) {
                                    first2 = false;
                                } else {
                                    sb.append(',');
                                }
                                sb.append(v);
                            }
                        }
                        sb.append('}');
                        continue;
                    }
                    if (Annotation.class.isAssignableFrom(rt)) {
                        CTypeI.annotationToCode(sb, (Annotation)v);
                        continue;
                    }
                    if (rt == String.class) {
                        sb.append('\"');
                        sb.append(v);
                        sb.append('\"');
                        continue;
                    }
                    sb.append(v);
                }
                sb.append(')');
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                RU.error(e);
            }
        }
    }

    public static <T extends Annotation> T annotation(Class<T> type, Map<String, Object> args) {
        try {
            return (T)TypeFactory.annotation(type, args);
        }
        catch (AnnotationFormatException e) {
            throw new RuntimeException(e);
        }
    }

    public static Constructor<?> getDefaultConstructor(Class<?> c) {
        for (Constructor<?> cc : c.getDeclaredConstructors()) {
            if (cc.getParameterCount() != 0) continue;
            return cc;
        }
        return null;
    }

    public static void getAllFields(Class<?> raw, List<Field> res) {
        int p = 0;
        for (Field f : raw.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            res.add(p++, f);
        }
        if (!raw.isInterface() && raw.getSuperclass() != null) {
            CTypeI.getAllFields(raw.getSuperclass(), res);
        }
    }

    public static void getAllMethods(Class<?> raw, Set<Method> res) {
        for (Method method : raw.getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers())) continue;
            res.add(method);
        }
        if (!raw.isInterface() && raw.getSuperclass() != null) {
            CTypeI.getAllMethods(raw.getSuperclass(), res);
        }
        for (GenericDeclaration genericDeclaration : raw.getInterfaces()) {
            CTypeI.getAllMethods(genericDeclaration, res);
        }
    }

    public static Flow<Class<?>> getAllParentClasses(Class<?> type) {
        final ArrayDeque q = new ArrayDeque();
        q.add(type);
        return new Flow<Class<?>>(){

            @Override
            public boolean hasNext() {
                return !q.isEmpty();
            }

            @Override
            public Class<?> next() {
                Class t = (Class)q.poll();
                assert (t != null);
                Class sc = t.getSuperclass();
                if (sc != null) {
                    q.add(sc);
                }
                Collections.addAll(q, t.getInterfaces());
                return t;
            }
        };
    }

    public static Flow<Annotation> getAllAnnotations(Class<?> type) {
        return CTypeI.getAllParentClasses(type).flatMap2(Class::getAnnotations);
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
        UNSIGNED = CTypeI.annotation(Unsigned.class, Map.of());
        UBYTE = CTypeI.of(UNSIGNED, Byte.TYPE, new AnnotatedType[0]);
        USHORT = CTypeI.of(UNSIGNED, Short.TYPE, new AnnotatedType[0]);
        UINT = CTypeI.of(UNSIGNED, Integer.TYPE, new AnnotatedType[0]);
        ULONG = CTypeI.of(UNSIGNED, Long.TYPE, new AnnotatedType[0]);
        CLASS_NAME = CTypeI.class.getCanonicalName();
        STRING = CTypeI.of(String.class);
        CHAR = CTypeI.of(Character.TYPE);
        CHAR_BOX = CTypeI.of(Character.class);
        BOOLEAN = CTypeI.of(Boolean.TYPE);
        BOOLEAN_BOX = CTypeI.of(Boolean.class);
        BYTE = CTypeI.of(Byte.TYPE);
        BYTE_BOX = CTypeI.of(Byte.class);
        SHORT = CTypeI.of(Short.TYPE);
        SHORT_BOX = CTypeI.of(Short.class);
        INT = CTypeI.of(Integer.TYPE);
        INT_BOX = CTypeI.of(Integer.class);
        LONG = CTypeI.of(Long.TYPE);
        LONG_BOX = CTypeI.of(Long.class);
        FLOAT = CTypeI.of(Float.TYPE);
        FLOAT_BOX = CTypeI.of(Float.class);
        DOUBLE = CTypeI.of(Double.TYPE);
        DOUBLE_BOX = CTypeI.of(Double.class);
        BYTE_ARR = CTypeI.of(byte[].class);
        BOOLEAN_ARR = CTypeI.of(boolean[].class);
        SHORT_ARR = CTypeI.of(short[].class);
        INT_ARR = CTypeI.of(int[].class);
        LONG_ARR = CTypeI.of(long[].class);
        FLOAT_ARR = CTypeI.of(float[].class);
        DOUBLE_ARR = CTypeI.of(double[].class);
    }

    public static interface CompareEvent {
        public void compareEvent(Field var1, Object var2, Object var3, Object var4, Object var5) throws Exception;
    }

    public static interface FieldAccessor<T2>
    extends ToString {
        public T2 get(Object var1);

        public void set(Object var1, T2 var2);
    }
}

