/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils;

import org.jetbrains.annotations.NotNull;

public class CharSequenceBySequence
implements CharSequence {
    public final CharSequence data;
    public final int begin;
    public final int end;

    public CharSequenceBySequence(CharSequence data) {
        this(data, 0, data.length());
    }

    public CharSequenceBySequence(CharSequence data, int begin, int end) {
        this.data = data;
        this.begin = begin;
        this.end = end;
    }

    @Override
    public int length() {
        return this.end - this.begin;
    }

    @Override
    public char charAt(int index) {
        return this.data.charAt(this.begin + index);
    }

    @Override
    public String toString() {
        char[] c = new char[this.length()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.charAt(i);
        }
        return new String(c);
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        return new CharSequenceBySequence(this.data, this.begin + start, this.begin + end);
    }
}

