/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils;

import io.aether.logger.Log;
import io.aether.utils.futures.AFuture;
import io.aether.utils.interfaces.Destroyable;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class Destroyer
implements Destroyable {
    public final String name;
    private final Queue<Destroyable> queue = new ConcurrentLinkedQueue<Destroyable>();
    volatile AtomicReference<AFuture> destroyFuture = new AtomicReference();

    public Destroyer(String name) {
        this.name = name;
    }

    public boolean isDestroyed() {
        return this.destroyFuture.get() != null;
    }

    public void add(Destroyable destroyable) {
        this.queue.add(destroyable);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public AFuture destroy(boolean force) {
        Destroyable e;
        AFuture res = AFuture.make();
        if (!this.destroyFuture.compareAndSet(null, res)) {
            return this.destroyFuture.get();
        }
        AtomicInteger counter = new AtomicInteger();
        while ((e = this.queue.poll()) != null) {
            counter.incrementAndGet();
            try {
                ((AFuture)e.destroy(force).to(() -> {
                    if (counter.decrementAndGet() == 0) {
                        res.tryDone();
                    }
                })).timeout(5, () -> Log.warn("Timeout destroy: $unit", "unit", e));
            }
            catch (Exception ex) {
                Log.warn("destroy exception", ex, new Object[0]);
            }
        }
        if (counter.decrementAndGet() <= 0) {
            res.tryDone();
        }
        res.timeout(5, () -> Log.warn("Timeout destroy all: $unit", "unit", this));
        return res;
    }

    public void add(final ScheduledFuture<?> os) {
        this.add(new Destroyable(){

            public String toString() {
                return os.toString();
            }

            @Override
            public AFuture destroy(boolean force) {
                os.cancel(force);
                return AFuture.completed();
            }
        });
    }

    public void add(final AutoCloseable os) {
        this.add(new Destroyable(){

            public String toString() {
                return os.toString();
            }

            @Override
            public AFuture destroy(boolean force) {
                if (force) {
                    try {
                        os.close();
                    }
                    catch (Exception e) {
                        Log.warn("destroy exception", e, new Object[0]);
                    }
                    return AFuture.completed();
                }
                try {
                    os.close();
                    return AFuture.completed();
                }
                catch (Exception e) {
                    return AFuture.doThrow(e);
                }
            }
        });
    }
}

