/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils;

import io.aether.logger.LNode;
import io.aether.logger.Log;
import io.aether.utils.AString;
import io.aether.utils.CTypeI;
import io.aether.utils.Destroyer;
import io.aether.utils.flow.Flow;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.interfaces.AFunction;
import io.aether.utils.interfaces.ARunnable;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeFactory;
import it.unimi.dsi.fastutil.chars.CharConsumer;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class RU {
    public static final Executor EMPTY_EXECUTOR = Runnable::run;
    public static final Random RND = new Random();
    public static final SecureRandom SECURE_RANDOM = new SecureRandom();
    static final IntList sysLoadingList = new IntArrayList();
    private static final Pattern PATTERN_URI = Pattern.compile("((?<protocol>[\\w:]+)/)?((?<user>\\w+(:(?<password>\\w+))?)@)(?<host>[\\w.]+)(:(?<port>\\d))?(/(?<path>\\.*))?");
    private static final ScheduledExecutorService INSTANCE4 = Executors.newScheduledThreadPool(2, runnable -> {
        Thread th = new Thread(runnable);
        th.setName("INSTANCE4");
        th.setDaemon(true);
        return th;
    });
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final short[] EMPTY_SHORT_ARRAY = new short[0];
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final char[] base64_code = new char[]{'.', '/', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final File HOME_DIR = new File(System.getProperty("user.home"));
    private static final File WORK_DIR = new File(System.getProperty("user.dir"));
    private static final AtomicLong contextIdCounter = new AtomicLong();
    static volatile int sysLoading;

    public static void loadLibrary(String libraryName) {
        String resourcePath = RU.getResourcePath(libraryName);
        try (InputStream in = RU.class.getResourceAsStream(resourcePath);){
            if (in == null) {
                throw new UnsatisfiedLinkError("Could not find native library: " + resourcePath);
            }
            Path tempDir = Files.createTempDirectory("native-lib-extract", new FileAttribute[0]);
            tempDir.toFile().deleteOnExit();
            Path tempFile = tempDir.resolve("lib" + libraryName);
            Files.copy(in, tempFile, StandardCopyOption.REPLACE_EXISTING);
            System.load(tempFile.toAbsolutePath().toString());
        }
        catch (Exception e) {
            throw new UnsatisfiedLinkError("Failed to load native library: " + e.getMessage());
        }
    }

    private static String getResourcePath(String libraryName) {
        String osName = System.getProperty("os.name").toLowerCase();
        String extension = osName.contains("win") ? ".dll" : (osName.contains("mac") ? ".dylib" : ".so");
        return "/lib" + libraryName + extension;
    }

    public static AString toJson(Object val) {
        AString s = AString.of();
        RU.toJson(s, val);
        return s;
    }

    public static byte[] sha1(byte[] input) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            return md.digest(input);
        }
        catch (NoSuchAlgorithmException e) {
            Log.error(e, new Object[0]);
            return (byte[])RU.error(e);
        }
    }

    public static void toJson(AString s, Object val) {
        if (val == null) {
            s.add("null");
        } else if (val instanceof Map) {
            s.add("{");
            boolean first = true;
            for (Map.Entry e : ((Map)val).entrySet()) {
                if (first) {
                    first = false;
                } else {
                    s.add(",");
                }
                s.add("\"").add(e.getKey()).add("\":");
                RU.toJson(s, e.getValue());
            }
            s.add("}");
        } else if (val instanceof Iterable) {
            s.add("[");
            boolean first = true;
            for (Object o : (Iterable)val) {
                if (first) {
                    first = false;
                } else {
                    s.add(",");
                }
                RU.toJson(s, o);
            }
            s.add("]");
        } else if (val instanceof byte[]) {
            s.add("\"").add(val).add("\"");
        } else if (val.getClass().isArray()) {
            s.add("[");
            boolean first = true;
            int len = Array.getLength(val);
            for (int i = 0; i < len; ++i) {
                if (first) {
                    first = false;
                } else {
                    s.add(",");
                }
                RU.toJson(s, Array.get(val, i));
            }
            s.add("]");
        } else if (val instanceof String) {
            s.add("\"").add(val).add("\"");
        }
    }

    public static URI parseURI(String s) throws URISyntaxException {
        Matcher m = PATTERN_URI.matcher(s);
        if (!m.find()) {
            throw new URISyntaxException(s, "URI is bad");
        }
        Object auth = null;
        String user = m.group("user");
        String password = m.group("password");
        if (user != null) {
            auth = user;
            if (password != null) {
                auth = (String)auth + ":" + password;
            }
        }
        int port = 0;
        String portString = m.group("port");
        if (portString != null && !portString.isBlank()) {
            try {
                port = Integer.parseInt(portString);
            }
            catch (Exception e) {
                throw new URISyntaxException(s, "Port is bad: " + portString);
            }
        }
        try {
            return new URI(m.group("protocol"), (String)auth, m.group("host"), port, m.group("path"), null, null);
        }
        catch (URISyntaxException e) {
            return (URI)RU.error(e);
        }
    }

    public static boolean startWith(byte[] src, int ... vals) {
        if (src == null) {
            return false;
        }
        if (src.length < vals.length) {
            return false;
        }
        for (int i = 0; i < vals.length; ++i) {
            if (src[i] == vals[i]) continue;
            return false;
        }
        return true;
    }

    public static void encodeBase64(byte[] d, CharConsumer rs) throws IllegalArgumentException {
        RU.encodeBase64(d, d.length, rs);
    }

    public static void encodeBase64(byte[] d, int len, CharConsumer rs) throws IllegalArgumentException {
        int off = 0;
        if (len <= 0 || len > d.length) {
            throw new IllegalArgumentException("Invalid len");
        }
        while (off < len) {
            int c1 = d[off++] & 0xFF;
            rs.accept(base64_code[c1 >> 2 & 0x3F]);
            c1 = (c1 & 3) << 4;
            if (off >= len) {
                rs.accept(base64_code[c1 & 0x3F]);
                break;
            }
            int c2 = d[off++] & 0xFF;
            rs.accept(base64_code[(c1 |= c2 >> 4 & 0xF) & 0x3F]);
            c1 = (c2 & 0xF) << 2;
            if (off >= len) {
                rs.accept(base64_code[c1 & 0x3F]);
                break;
            }
            c2 = d[off++] & 0xFF;
            rs.accept(base64_code[(c1 |= c2 >> 6 & 3) & 0x3F]);
            rs.accept(base64_code[c2 & 0x3F]);
        }
    }

    public static void encodeBase64(byte[] d, StringBuilder rs) throws IllegalArgumentException {
        RU.encodeBase64(d, d.length, rs);
    }

    public static void encodeBase64(byte[] d, int len, StringBuilder rs) throws IllegalArgumentException {
        int off = 0;
        if (len <= 0 || len > d.length) {
            throw new IllegalArgumentException("Invalid len");
        }
        while (off < len) {
            int c1 = d[off++] & 0xFF;
            rs.append(base64_code[c1 >> 2 & 0x3F]);
            c1 = (c1 & 3) << 4;
            if (off >= len) {
                rs.append(base64_code[c1 & 0x3F]);
                break;
            }
            int c2 = d[off++] & 0xFF;
            rs.append(base64_code[(c1 |= c2 >> 4 & 0xF) & 0x3F]);
            c1 = (c2 & 0xF) << 2;
            if (off >= len) {
                rs.append(base64_code[c1 & 0x3F]);
                break;
            }
            c2 = d[off++] & 0xFF;
            rs.append(base64_code[(c1 |= c2 >> 6 & 3) & 0x3F]);
            rs.append(base64_code[c2 & 0x3F]);
        }
    }

    public static ScheduledFuture<?> schedule(long periodMs, ARunnable t) {
        StackTraceElement[] st = null;
        return INSTANCE4.schedule(Log.wrap(() -> {
            try {
                t.run2();
            }
            catch (Throwable e) {
                RU.concatStackTrace(st, e);
            }
        }), periodMs, TimeUnit.MILLISECONDS);
    }

    public static ScheduledFuture<?> scheduleAtFixedRate(Destroyer resTo, Executor executor, int durationSeconds, ARunnable task) {
        ScheduledFuture<?> res = RU.scheduleAtFixedRate(executor, durationSeconds, task);
        resTo.add(res);
        return res;
    }

    public static ScheduledFuture<?> scheduleAtFixedRate(Executor executor, int durationSeconds, ARunnable t) {
        StackTraceElement[] st = null;
        return INSTANCE4.scheduleAtFixedRate(() -> executor.execute(() -> {
            try {
                t.run2();
            }
            catch (Throwable e) {
                RU.concatStackTrace(st, e);
            }
        }), 0L, durationSeconds, TimeUnit.SECONDS);
    }

    public static ScheduledFuture<?> scheduleAtFixedRate(long period, ARunnable t) {
        return RU.scheduleAtFixedRate(period, TimeUnit.MILLISECONDS, t);
    }

    public static ScheduledFuture<?> scheduleAtFixedRate(Destroyer resTo, long period, TimeUnit timeUnit, ARunnable t) {
        ScheduledFuture<?> res = RU.scheduleAtFixedRate(period, timeUnit, t);
        resTo.add(res);
        return res;
    }

    public static ScheduledFuture<?> scheduleAtFixedRate(long period, TimeUnit timeUnit, ARunnable t) {
        StackTraceElement[] st = null;
        return INSTANCE4.scheduleAtFixedRate(Log.wrap(() -> {
            try {
                t.run2();
            }
            catch (Throwable e) {
                RU.concatStackTrace(st, e);
            }
        }), 0L, period, timeUnit);
    }

    public static CTypeI<Object> parseType(String s) {
        try {
            return RU.parseType(s, new int[]{0});
        }
        catch (ClassNotFoundException e) {
            RU.error(e);
            return null;
        }
    }

    public static <T extends Throwable> T filterFrontAndBackStackTrace(T e, Class<?> ... skipClasses) {
        e.setStackTrace(RU.filterFrontAndBackStackTrace(e.getStackTrace(), RU.concatArrays(e.getClass(), skipClasses)));
        return e;
    }

    private static Type parseType0(String s) throws ClassNotFoundException {
        switch (s) {
            case "boolean": {
                return Boolean.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "boolean[]": {
                return boolean[].class;
            }
            case "char[]": {
                return char[].class;
            }
            case "byte[]": {
                return byte[].class;
            }
            case "short[]": {
                return short[].class;
            }
            case "int[]": {
                return int[].class;
            }
            case "long[]": {
                return long[].class;
            }
        }
        return Class.forName(s);
    }

    public static StackTraceElement[] filterFrontAndBackStackTrace(StackTraceElement[] ss, Class<?> ... skipClasses) {
        int top = 0;
        block0: for (int i = 0; i < ss.length; ++i) {
            if (ss[i].getClassName().equals(Thread.class.getName())) continue;
            for (Class<?> s : skipClasses) {
                assert (s != null);
                if (ss[i].getClassName().equals(s.getName())) continue block0;
            }
            top = i;
            break;
        }
        return RU.filterStackTraceBack(Arrays.copyOfRange(ss, top, ss.length), new Class[0]);
    }

    public static StackTraceElement[] filterStackTraceBack(StackTraceElement[] ss, Class<?> ... skipClasses) {
        int bottom = ss.length;
        for (int i = ss.length - 1; i >= 0; --i) {
            if (!ss[i].getClassName().contains("aether")) continue;
            bottom = i + 1;
            break;
        }
        return Arrays.copyOfRange(ss, 0, bottom);
    }

    public static CTypeI<Object> parseType(String s, int[] i) throws ClassNotFoundException {
        int i1 = s.indexOf(44, i[0]);
        int i2 = s.indexOf(60, i[0]);
        int i3 = s.indexOf(62, i[0]);
        int min = s.length();
        if (i1 >= 0 && min > i1) {
            min = i1;
        }
        if (i2 >= 0 && min > i2) {
            min = i2;
        }
        if (i3 >= 0 && min > i3) {
            min = i3;
        }
        if (min == s.length()) {
            String ss = s.substring(i[0]).trim();
            if (ss.isBlank()) {
                i[0] = -1;
                return null;
            }
            Type res = RU.parseType0(ss);
            i[0] = -1;
            return CTypeI.of(res);
        }
        if (min == i1) {
            String ss = s.substring(i[0], i1).trim();
            if (ss.isBlank()) {
                i[0] = min + 1;
                return null;
            }
            Type res = RU.parseType0(ss);
            i[0] = i1 + 1;
            return CTypeI.of(res);
        }
        if (min == i2) {
            Type res = RU.parseType0(s.substring(i[0], i2).trim());
            i[0] = i2 + 1;
            ObjectArrayList pp = new ObjectArrayList();
            while (true) {
                CTypeI<Object> t;
                if ((t = RU.parseType(s, i)) == null) {
                    if (pp.isEmpty()) {
                        return CTypeI.of(res);
                    }
                    return CTypeI.of(res, (List<Type>)pp);
                }
                pp.add(t.toType());
            }
        }
        String ss = s.substring(i[0], i3).trim();
        i[0] = i3 + 1;
        if (ss.isBlank()) {
            return null;
        }
        return CTypeI.of(Class.forName(ss));
    }

    public static Flow<File> getAllPaths() {
        return Flow.flow(System.getProperty("java.class.path").split(":")).distinct().map(File::new);
    }

    public static int sizeOf(Parameter p) {
        Class<?> t = p.getType();
        if (t == String.class) {
            return 2;
        }
        if (t == Byte.TYPE) {
            return 1;
        }
        if (t == Short.TYPE) {
            return 2;
        }
        if (t == Integer.TYPE) {
            return 4;
        }
        if (t == Long.TYPE) {
            return 8;
        }
        if (t == Float.TYPE) {
            return 4;
        }
        if (t == Double.TYPE) {
            return 8;
        }
        if (t == Boolean.TYPE) {
            return 1;
        }
        throw new UnsupportedOperationException(String.valueOf(t));
    }

    public static <S, T> T[] mapArray(S[] src, Class<T> targetType, AFunction<S, T> mapper) {
        Object[] res = (Object[])Array.newInstance(targetType, src.length);
        for (int i = 0; i < src.length; ++i) {
            res[i] = mapper.apply(src[i]);
        }
        return res;
    }

    public static int ceilDiv(int x, int y) {
        int q = x / y;
        if ((x ^ y) >= 0 && q * y != x) {
            return q + 1;
        }
        return q;
    }

    public static CTypeI<Object> resolveExtend(CTypeI<?> parent, CTypeI<?> owner) {
        return CTypeI.of(GenericTypeReflector.getExactSuperType((AnnotatedType)owner.toAnnotatedType(), parent.getRaw2()));
    }

    public static <T> T error(StackTraceElement[] st, Throwable e) {
        RU.concatStackTrace(st, e);
        RU.error(e);
        return null;
    }

    public static <T, E extends Throwable> T error(Throwable e) throws E {
        throw e;
    }

    public static int availableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            RU.error(e);
        }
    }

    public static double getNetLoading() {
        double d;
        BufferedReader fr = new BufferedReader(new FileReader("/proc/stat"));
        try {
            d = 0.0;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return (Double)RU.error(e);
            }
        }
        fr.close();
        return d;
    }

    public static int getSystemLoading() {
        return sysLoading;
    }

    public static <T> T[] concatArrays(T v, T[] vv) {
        if (vv.length == 0) {
            Object[] res = (Object[])Array.newInstance(v.getClass(), 1);
            res[0] = v;
            return res;
        }
        Object[] res = (Object[])Array.newInstance(vv.getClass().getComponentType(), vv.length + 1);
        System.arraycopy(vv, 0, res, 1, vv.length);
        res[0] = v;
        return res;
    }

    public static <T> T cast(Object t) {
        return (T)t;
    }

    public static <T> T[] concatArrays(T[] v, T[] vv) {
        T[] res = Arrays.copyOf(vv, v.length + vv.length);
        System.arraycopy(vv, 0, res, v.length, vv.length);
        return res;
    }

    public static void concatStackTrace(StackTraceElement[] st, Throwable e) {
        if (st == null) {
            return;
        }
        e.setStackTrace(Flow.flow(e.getStackTrace()).addAll(Flow.flow(st).skip(2)).toArray(StackTraceElement.class));
    }

    public static <T> int updateMax(T owner, AtomicIntegerFieldUpdater<T> updater, int value) {
        int nv;
        int i;
        while (!updater.compareAndSet(owner, i = updater.get(owner), nv = Math.max(i, value))) {
        }
        return nv;
    }

    public static <T> int updateMin(T owner, AtomicIntegerFieldUpdater<T> updater, int value) {
        int nv;
        int i;
        while (!updater.compareAndSet(owner, i = updater.get(owner), nv = Math.min(i, value))) {
        }
        return nv;
    }

    public static <T> long updateMax(T owner, AtomicLongFieldUpdater<T> updater, long value) {
        long nv;
        long i;
        while (!updater.compareAndSet(owner, i = updater.get(owner), nv = Math.max(i, value))) {
        }
        return nv;
    }

    public static <T> void readAll(Queue<T> q, AConsumer<T> o) {
        if (q == null) {
            return;
        }
        T element;
        while ((element = q.poll()) != null) {
            o.accept(element);
        }
        return;
    }

    public static void runAll(Queue<ARunnable> q) {
        if (q == null) {
            return;
        }
        ARunnable element;
        while ((element = q.poll()) != null) {
            try {
                element.run();
                continue;
            }
            catch (Exception e) {
                Log.error(e, new Object[0]);
                continue;
            }
            break;
        }
        return;
    }

    public static String escape(String s) {
        return RU.escape("\\$\"", s);
    }

    public static String escape(String chars, String s) {
        for (int i = 0; i < chars.length(); ++i) {
            char c = chars.charAt(i);
            s = s.replace(Character.toString(c), "\\" + c);
        }
        return s;
    }

    public static CharSequence unescape(CharSequence s) {
        StringBuilder sb = null;
        int last = 0;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch != '\\') continue;
            if (sb == null) {
                sb = new StringBuilder(s.length() + 10);
            }
            sb.append(s, last, i);
            last = ++i;
        }
        if (sb == null) {
            return s;
        }
        if (last < s.length()) {
            sb.append(s, last, s.length());
        }
        return sb;
    }

    public static short[] convertBytesToShortArray(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] res = new short[bytes.length / 2];
        for (int i = 0; i < res.length; ++i) {
            int v = 0;
            for (int ii = 0; ii < 2; ++ii) {
                v = v << 8 | Byte.toUnsignedInt(bytes[i * 2 + ii]);
            }
            res[i] = (short)v;
        }
        return res;
    }

    public static int[] convertBytesToIntArray(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] res = new int[bytes.length / 4];
        for (int i = 0; i < res.length; ++i) {
            int v = 0;
            for (int ii = 0; ii < 4; ++ii) {
                v = v << 8 | Byte.toUnsignedInt(bytes[i * 4 + ii]);
            }
            res[i] = v;
        }
        return res;
    }

    public static byte[] convertShortToByteArray(int data) {
        return RU.convertShortToByteArray((short)data);
    }

    public static byte[] convertShortToByteArray(short data) {
        return new byte[]{(byte)data, (byte)(data >> 8)};
    }

    public static byte[] convertShortToByteArray(short[] data) {
        if (data == null || data.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] res = new byte[data.length * 4];
        int p = 0;
        for (short v : data) {
            for (int i = 0; i < 2; ++i) {
                res[p++] = (byte)(v >> 8 * (1 - i));
            }
        }
        return res;
    }

    public static byte[] convertIntToByteArray(int[] data) {
        if (data == null || data.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] res = new byte[data.length * 4];
        int p = 0;
        for (int v : data) {
            for (int i = 0; i < 4; ++i) {
                res[p++] = (byte)(v >> 8 * (3 - i));
            }
        }
        return res;
    }

    public static long time() {
        return System.currentTimeMillis();
    }

    public static long bytesToLong(byte[] bytes, int offset) {
        return (long)bytes[offset] << 56 | (long)(bytes[offset + 1] & 0xFF) << 48 | (long)(bytes[offset + 2] & 0xFF) << 40 | (long)(bytes[offset + 3] & 0xFF) << 32 | (long)(bytes[offset + 4] & 0xFF) << 24 | (long)(bytes[offset + 5] & 0xFF) << 16 | (long)(bytes[offset + 6] & 0xFF) << 8 | (long)(bytes[offset + 7] & 0xFF);
    }

    public static long bytesToLongLittleEndian(byte[] bytes, int offset) {
        return (long)(bytes[offset + 7] & 0xFF) << 56 | (long)(bytes[offset + 6] & 0xFF) << 48 | (long)(bytes[offset + 5] & 0xFF) << 40 | (long)(bytes[offset + 4] & 0xFF) << 32 | (long)(bytes[offset + 3] & 0xFF) << 24 | (long)(bytes[offset + 2] & 0xFF) << 16 | (long)(bytes[offset + 1] & 0xFF) << 8 | (long)(bytes[offset] & 0xFF);
    }

    private static AnnotatedType arrayOf(AnnotatedType componentType, Annotation[] annotations) {
        return TypeFactory.arrayOf((AnnotatedType)componentType, (Annotation[])annotations);
    }

    public static String[] splitWithQuotes(String s) {
        ArrayList<String> l = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean inString = false;
        boolean escape = false;
        char q = '0';
        for (char c : s.toCharArray()) {
            if (inString) {
                if (escape) {
                    escape = false;
                    sb.append(c);
                    continue;
                }
                if (c == '\\') {
                    escape = true;
                    sb.append(c);
                    continue;
                }
                if (c == q) {
                    inString = false;
                    sb.append(c);
                    l.add(sb.toString());
                    sb.setLength(0);
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (c == '\"' || c == '\'') {
                inString = true;
                q = c;
                sb.append(c);
                continue;
            }
            if (c == ' ') {
                l.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            sb.append(c);
        }
        return l.toArray(new String[0]);
    }

    public static boolean isDeclaredInClass(Field f, Class<?> rootClass) {
        assert (rootClass != null);
        for (Class<?> c = rootClass; c != null; c = c.getSuperclass()) {
            if (f.getDeclaringClass() != c) continue;
            return false;
        }
        return rootClass.isAssignableFrom(f.getDeclaringClass());
    }

    public static void executeShellBashSudo(String password, String cmd) {
        RU.executeShellBash("echo \"" + password + "\" | sudo -S " + cmd);
    }

    public static void executeShellBash(String cmd) {
        try {
            ProcessBuilder process = new ProcessBuilder("/usr/bin/bash", "-c", cmd);
            process.redirectErrorStream(true);
            Process proc = process.start();
            proc.waitFor();
            proc.getInputStream().transferTo(System.out);
            proc.getErrorStream().transferTo(System.out);
            proc.destroy();
        }
        catch (Exception e) {
            RU.error(e);
        }
    }

    public static void executeShell(String s) {
        try {
            String[] args = RU.splitWithQuotes(s);
            ProcessBuilder process = new ProcessBuilder(args);
            process.redirectErrorStream(true);
            Process proc = process.start();
            proc.waitFor();
            proc.getInputStream().transferTo(System.out);
            proc.getErrorStream().transferTo(System.out);
            proc.destroy();
        }
        catch (Exception e) {
            RU.error(e);
        }
    }

    public static <T extends Enum<T>> Class<Enum<T>> castEnum(Class<?> raw) {
        return (Class)RU.cast(raw);
    }

    public static <T> T[] removeElement(T[] a, int i) {
        if (a == null || a.length == 0) {
            return a;
        }
        assert (i >= 0 && i < a.length);
        if (a.length == 1) {
            return (Object[])RU.cast(Array.newInstance(a.getClass().getComponentType(), 0));
        }
        if (i == 0) {
            return Arrays.copyOfRange(a, 1, a.length);
        }
        if (i == a.length - 1) {
            return Arrays.copyOfRange(a, 0, a.length - 1);
        }
        Object[] na = (Object[])RU.cast(Array.newInstance(a.getClass().getComponentType(), a.length - 1));
        System.arraycopy(a, 0, na, 0, i);
        System.arraycopy(a, 0, na, i + 1, a.length - i - 1);
        return na;
    }

    public static MethodHandle unreflect(MethodHandles.Lookup lookup, Method method) {
        try {
            return lookup.unreflect(method);
        }
        catch (IllegalAccessException e) {
            try {
                MethodHandles.Lookup privateLookup = MethodHandles.privateLookupIn(method.getDeclaringClass(), MethodHandles.lookup());
                return privateLookup.unreflect(method);
            }
            catch (IllegalAccessException ex) {
                return (MethodHandle)RU.error(ex);
            }
        }
    }

    public static VarHandle unreflect(Field f) {
        return CTypeI.of(f.getDeclaringClass()).getFieldVarHandle(f);
    }

    public static Executor debugExecutor(final Executor executor) {
        return new Executor(){

            @Override
            public void execute(@NotNull Runnable command) {
                StackTraceElement[] stack = Thread.currentThread().getStackTrace();
                executor.execute(() -> {
                    try {
                        command.run();
                    }
                    catch (Throwable e) {
                        e.setStackTrace(Flow.flow(e.getStackTrace()).skipLast(4).addAll(Flow.flow(stack).skip(3)).toArray(StackTraceElement.class));
                        throw e;
                    }
                });
            }
        };
    }

    public static <T> T errorUnsupported() {
        return RU.error(new UnsupportedOperationException());
    }

    public static File homeDir() {
        return HOME_DIR;
    }

    public static File workDir() {
        return WORK_DIR;
    }

    public static long newContextId() {
        return contextIdCounter.getAndIncrement();
    }

    public static File selfExecuteCmdJar() {
        String cmd = ProcessHandle.current().info().commandLine().orElse("");
        String res = cmd.replaceAll(".*?/java\\s+(-+\\S+\\s+)*(\\S+.jar).*", "$2");
        return new File(RU.workDir(), res);
    }

    public static String selfExecuteCmdWithoutArgs() {
        String cmd = ProcessHandle.current().info().commandLine().orElse("");
        String res = cmd.replaceAll(".*?/java\\s+(-+\\S+\\s+)*(\\S+.jar).*", "java $1$2");
        return res;
    }

    public static File tempFile() {
        try {
            return File.createTempFile("temp", "");
        }
        catch (IOException e) {
            return (File)RU.error(e);
        }
    }

    public static void printStackTrace() {
        Log.debug(Flow.flow(Thread.currentThread().getStackTrace()).join("\n"), new LNode[0]);
    }

    static {
        INSTANCE4.scheduleAtFixedRate(new Runnable(){
            long cpu0;
            long nice0;
            long system0;
            long idle0;
            private boolean checkFirst;

            @Override
            public void run() {
                try (BufferedReader fr = new BufferedReader(new FileReader("/proc/stat"));){
                    String cpuLine = fr.readLine();
                    String[] s = cpuLine.split(" +");
                    long cpu1 = Long.parseLong(s[1]);
                    long nice1 = Long.parseLong(s[2]);
                    long system1 = Long.parseLong(s[3]);
                    long idle1 = Long.parseLong(s[4]);
                    long cpuDelta = cpu1 - this.cpu0;
                    long niceDelta = nice1 - this.nice0;
                    long systemDelta = system1 - this.system0;
                    long idleDelta = idle1 - this.idle0;
                    this.cpu0 = cpu1;
                    this.nice0 = nice1;
                    this.system0 = system1;
                    this.idle0 = idle1;
                    if (this.checkFirst) {
                        this.checkFirst = false;
                        return;
                    }
                    long total = cpuDelta + niceDelta + systemDelta + idleDelta;
                    int l = (int)(100.0 * (double)(cpuDelta + niceDelta + systemDelta) / (double)total);
                    sysLoadingList.add(l);
                    while (sysLoadingList.size() >= 6) {
                        sysLoadingList.removeInt(0);
                    }
                    sysLoading = Flow.flow(sysLoadingList).avg();
                }
                catch (IOException e) {
                    sysLoading = 0;
                }
            }
        }, 0L, 1L, TimeUnit.SECONDS);
    }
}

