/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils;

import io.aether.logger.Log;
import io.aether.utils.RU;
import io.aether.utils.interfaces.ASupplier;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class TimeoutChecker {
    private static final ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(@NotNull Runnable r) {
            Thread t = new Thread(r);
            t.setName("Timeout checker");
            t.setDaemon(true);
            return t;
        }
    });
    private final long ms;
    private final Object message;
    private volatile long startTime;
    private volatile ScheduledFuture<?> scTask;
    private volatile boolean successful;

    private TimeoutChecker(int seconds, Object message) {
        this((long)seconds * 1000L, message);
    }

    private TimeoutChecker(long ms, Object message) {
        this.ms = ms;
        assert (message != null);
        this.message = message;
    }

    private TimeoutChecker addTask() {
        this.startTime = RU.time();
        ScheduledFuture<?> scTask = service.schedule(() -> {
            if (this.successful) {
                return;
            }
            String msg = this.message instanceof Supplier ? String.valueOf(((Supplier)this.message).get()) : String.valueOf(this.message);
            Log.warn("time $time > $limit: $msg", "time", RU.time() - this.startTime, "limit", this.ms, "msg", msg);
        }, this.ms, TimeUnit.MILLISECONDS);
        ScheduledFuture<?> t = this.scTask;
        if (t != null) {
            t.cancel(true);
        }
        this.scTask = scTask;
        return this;
    }

    public void done() {
        this.successful = true;
        ScheduledFuture<?> t = this.scTask;
        if (t != null) {
            t.cancel(true);
            this.scTask = null;
        }
    }

    public void next() {
        this.done();
        this.addTask();
    }

    public void resume() {
        this.addTask();
    }

    public static TimeoutChecker error5() {
        return TimeoutChecker.error(5);
    }

    public static TimeoutChecker errorMs(long ms, ASupplier<Object> message) {
        return new TimeoutChecker(ms, message).addTask();
    }

    public static TimeoutChecker error(int seconds, ASupplier<Object> message) {
        return new TimeoutChecker(seconds, (Object)message).addTask();
    }

    public static TimeoutChecker error(int seconds, Object message) {
        return new TimeoutChecker(seconds, message).addTask();
    }

    public static TimeoutChecker error10() {
        return TimeoutChecker.error(10);
    }

    public static TimeoutChecker error20() {
        return TimeoutChecker.error(20);
    }

    public static TimeoutChecker error40() {
        return TimeoutChecker.error(40);
    }

    public static TimeoutChecker error(int seconds) {
        return TimeoutChecker.error(seconds, () -> "");
    }

    public static TimeoutChecker info(long timeout) {
        return new TimeoutChecker(timeout, null);
    }
}

