/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.dataio;

import io.aether.utils.HexUtils;
import io.aether.utils.dataio.DataIO;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataInOut;
import io.aether.utils.dataio.DataInOutStatic;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteBufferDataIO
implements DataIO {
    private final ByteBuffer buffer;
    private boolean isWriting;

    public ByteBufferDataIO(int capacity) {
        this.buffer = ByteBuffer.allocate(capacity).order(ByteOrder.LITTLE_ENDIAN);
        this.isWriting = true;
    }

    @Override
    public int getSizeForWrite() {
        return this.buffer.remaining();
    }

    @Override
    public boolean isWritable() {
        return this.buffer.hasRemaining();
    }

    @Override
    public void clear() {
        this.buffer.clear();
        this.isWriting = true;
    }

    @Override
    public int getSizeForRead() {
        if (!this.isWriting) {
            this.flipBuffer();
        }
        return this.buffer.position();
    }

    private void flipBuffer() {
        this.buffer.flip();
        this.isWriting = !this.isWriting;
    }

    @Override
    public int read(byte[] b, int offset, int len) {
        if (this.isWriting) {
            this.flipBuffer();
        }
        int remaining = this.buffer.remaining();
        int l = Math.min(Math.min(len, b.length), remaining);
        if (l > 0) {
            this.buffer.get(b, offset, l);
        }
        return l;
    }

    @Override
    public void write(byte[] b) {
        if (!this.isWriting) {
            this.flipBuffer();
        }
        if (b.length > this.buffer.remaining()) {
            throw new IllegalStateException();
        }
        this.buffer.put(b);
    }

    @Override
    public int write(byte[] b, int off, int len) {
        if (!this.isWriting) {
            this.flipBuffer();
        }
        int l = Math.min(len, this.buffer.remaining());
        this.buffer.put(b, off, l);
        return l;
    }

    @Override
    public void writeShort(int v) {
        if (!this.isWriting) {
            this.flipBuffer();
        }
        if (this.buffer.remaining() < 2) {
            throw new IllegalStateException();
        }
        this.buffer.putShort((short)v);
    }

    @Override
    public short readShort() {
        if (this.isWriting) {
            this.flipBuffer();
        }
        if (this.buffer.position() + 2 > this.buffer.limit()) {
            throw new RuntimeException();
        }
        return this.buffer.getShort();
    }

    @Override
    public void writeInt(int v) {
        if (!this.isWriting) {
            this.flipBuffer();
        }
        if (this.buffer.remaining() < 4) {
            throw new IllegalStateException();
        }
        this.buffer.putInt(v);
    }

    @Override
    public int readInt() {
        if (this.isWriting) {
            this.flipBuffer();
        }
        if (this.buffer.position() + 4 > this.buffer.limit()) {
            throw new RuntimeException();
        }
        return this.buffer.getInt();
    }

    @Override
    public void writeLong(long v) {
        if (!this.isWriting) {
            this.flipBuffer();
        }
        if (this.buffer.remaining() < 8) {
            throw new IllegalStateException();
        }
        this.buffer.putLong(v);
    }

    @Override
    public long readLong() {
        if (this.isWriting) {
            this.flipBuffer();
        }
        if (this.buffer.position() + 8 > this.buffer.limit()) {
            throw new RuntimeException();
        }
        return this.buffer.getLong();
    }

    @Override
    public void writeFloat(float v) {
        if (!this.isWriting) {
            this.flipBuffer();
        }
        if (this.buffer.remaining() < 4) {
            throw new IllegalStateException();
        }
        this.buffer.putFloat(v);
    }

    @Override
    public float readFloat() {
        if (this.isWriting) {
            this.flipBuffer();
        }
        if (this.buffer.position() + 4 > this.buffer.limit()) {
            throw new RuntimeException();
        }
        return this.buffer.getFloat();
    }

    @Override
    public void writeDouble(double v) {
        if (!this.isWriting) {
            this.flipBuffer();
        }
        if (this.buffer.remaining() < 8) {
            throw new IllegalStateException();
        }
        this.buffer.putDouble(v);
    }

    @Override
    public double readDouble() {
        if (this.isWriting) {
            this.flipBuffer();
        }
        if (this.buffer.position() + 8 > this.buffer.limit()) {
            throw new RuntimeException();
        }
        return this.buffer.getDouble();
    }

    @Override
    public void writeBoolean(boolean v) {
        if (!this.isWriting) {
            this.flipBuffer();
        }
        this.writeByte(v ? 1 : 0);
    }

    @Override
    public boolean readBoolean() {
        if (this.isWriting) {
            this.flipBuffer();
        }
        return this.readUByte() != 0;
    }

    @Override
    public byte[] toArray() {
        if (!this.isWriting) {
            this.flipBuffer();
        }
        if (this.buffer.position() == 0 && this.buffer.limit() == this.buffer.capacity()) {
            return this.buffer.array();
        }
        byte[] array = new byte[this.buffer.position()];
        System.arraycopy(this.buffer.array(), 0, array, 0, this.buffer.position());
        return array;
    }

    @Override
    public void skipBytes(int n) {
        if (this.isWriting) {
            this.flipBuffer();
        }
        if (n > this.buffer.remaining()) {
            throw new IllegalStateException("Not enough bytes to skip");
        }
        this.buffer.position(this.buffer.position() + n);
    }

    @Override
    public boolean isEmpty() {
        return this.getSizeForRead() == 0;
    }

    @Override
    public void skipAllBytes() {
        if (this.isWriting) {
            this.flipBuffer();
        }
        this.buffer.position(this.buffer.limit());
    }

    @Override
    public int indexOf(int limit, byte val) {
        if (this.isWriting) {
            this.flipBuffer();
        }
        for (int i = this.buffer.position(); i < Math.min(limit, this.buffer.limit()); ++i) {
            if (this.buffer.get(i) != val) continue;
            return i;
        }
        return -1;
    }

    @Override
    public DataIO readSubData(int length) {
        if (this.isWriting) {
            this.flipBuffer();
        }
        ByteBufferDataIO res = new ByteBufferDataIO(length);
        for (int i = 0; i < length && this.buffer.hasRemaining(); ++i) {
            res.writeByte(this.buffer.get());
        }
        return res;
    }

    @Override
    public void writeHexBytes(String hex) {
        byte[] bytes;
        if (!this.isWriting) {
            this.flipBuffer();
        }
        if ((bytes = HexUtils.hexToBytes(hex)).length > this.buffer.remaining()) {
            throw new IllegalStateException();
        }
        this.buffer.put(bytes);
    }

    @Override
    public void write(DataInOut data) {
        if (!this.isWriting) {
            this.flipBuffer();
        }
        int r = this.write(data.data, data.readPos, data.writePos - data.readPos);
        assert (r == data.getSizeForRead());
        data.readPos = 0;
        data.writePos = 0;
    }

    @Override
    public void write(DataInOutStatic data) {
        if (!this.isWriting) {
            this.flipBuffer();
        }
        int r = this.write(data.getData(), data.getReadPos(), data.getWritePos() - data.getReadPos());
        assert (r == data.getSizeForRead());
        data.setReadPos(0);
        data.setWritePos(0);
    }

    @Override
    public void write(DataIn data) {
        if (!this.isWriting) {
            this.flipBuffer();
        }
        this.write(data.toArray());
    }

    @Override
    public int readUByte() {
        return this.buffer.get();
    }

    @Override
    public void writeByte(int b) {
        this.buffer.put((byte)(b & 0xFF));
    }
}

