/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.dataio;

import io.aether.utils.HexUtils;
import io.aether.utils.dataio.DataIO;
import org.jetbrains.annotations.NotNull;

public class DataInOutStatic
implements DataIO {
    public final byte[] data;
    public int writePos;
    public int readPos;

    @Override
    public void skipBytes(int n) {
        this.readPos += n;
        if (this.data.length < this.readPos) {
            throw new IllegalStateException("data.length(" + this.data.length + ") < readPos(" + this.readPos + ")");
        }
    }

    public DataInOutStatic(int initSize) {
        this(new byte[initSize], 0, 0);
    }

    public DataInOutStatic(byte[] ar) {
        this(ar, 0, ar.length);
    }

    public DataInOutStatic(byte[] ar, int readPos, int writePos) {
        this.data = ar;
        this.readPos = readPos;
        this.writePos = writePos;
    }

    public String toString() {
        return HexUtils.toHexString(this.data, this.readPos, this.writePos);
    }

    public byte[] getData() {
        return this.data;
    }

    public int getReadPos() {
        return this.readPos;
    }

    public void setReadPos(int readPos) {
        this.readPos = readPos;
    }

    public int getWritePos() {
        return this.writePos;
    }

    public void setWritePos(int writePos) {
        assert (writePos <= this.data.length);
        this.writePos = writePos;
    }

    @Override
    public int getSizeForWrite() {
        return this.data.length - this.writePos;
    }

    @Override
    public boolean isWritable() {
        return this.writePos < this.data.length;
    }

    @Override
    public void clear() {
        this.writePos = 0;
        this.readPos = 0;
    }

    @Override
    public int getSizeForRead() {
        return this.writePos - this.readPos;
    }

    @Override
    public int read(byte[] b, int offset, int len) {
        int a = this.getSizeForRead();
        int l = Math.min(Math.min(len, b.length), a);
        if (l > 0) {
            System.arraycopy(this.data, this.readPos, b, offset, l);
            this.readPos += l;
        }
        return l;
    }

    @Override
    public void write(byte @NotNull [] b) {
        if (b.length > this.data.length - this.writePos) {
            throw new IllegalStateException();
        }
        System.arraycopy(b, 0, this.data, this.writePos, b.length);
        this.writePos += b.length;
    }

    @Override
    public int write(byte @NotNull [] b, int off, int len) {
        int l = Math.min(len, this.data.length - this.writePos);
        System.arraycopy(b, off, this.data, this.writePos, l);
        this.writePos += l;
        return l;
    }

    @Override
    public int readInt() {
        if (this.readPos + 4 > this.writePos) {
            throw new RuntimeException();
        }
        int res = 0;
        for (int i = 0; i < 4; ++i) {
            res |= Byte.toUnsignedInt(this.data[this.readPos++]) << 8 * i;
        }
        return res;
    }

    @Override
    public long readLong() {
        if (this.readPos + 8 > this.writePos) {
            throw new RuntimeException();
        }
        long res = 0L;
        for (int i = 0; i < 8; ++i) {
            res |= Byte.toUnsignedLong(this.data[this.readPos++]) << 8 * i;
        }
        return res;
    }

    @Override
    public int readUByte() {
        if (this.readPos >= this.writePos) {
            throw new IllegalStateException("Read position [" + this.readPos + "] > write position [" + this.writePos + "]");
        }
        return Byte.toUnsignedInt(this.data[this.readPos++]);
    }

    @Override
    public byte[] toArray() {
        if (this.readPos == 0 && this.writePos == this.data.length) {
            return this.data;
        }
        return DataIO.super.toArray();
    }

    @Override
    public int indexOf(int limit, byte val) {
        for (int i = this.readPos; i < this.writePos && i < limit; ++i) {
            if (this.data[i] != val) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void writeByte(int v) {
        this.data[this.writePos++] = (byte)v;
    }

    public int total() {
        return this.data.length;
    }

    public static DataInOutStatic ofBytes(String s) {
        s = s.replaceAll("\\[", "");
        s = s.replaceAll("]", "");
        String[] ss = s.split(", ");
        byte[] bb = new byte[ss.length];
        for (int i = 0; i < bb.length; ++i) {
            bb[i] = Byte.parseByte(ss[i].trim());
        }
        return new DataInOutStatic(bb);
    }
}

