/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.flow;

import io.aether.utils.RU;
import io.aether.utils.flow.Flow;
import io.aether.utils.flow.FlowCompletedBoolean;
import io.aether.utils.interfaces.ABiConsumerBool2O;
import io.aether.utils.interfaces.AComparatorInt;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.interfaces.AConsumerBoolean;
import io.aether.utils.interfaces.AFunction;
import io.aether.utils.interfaces.AFunctionBool2O;
import io.aether.utils.interfaces.APredicateBoolean;
import io.aether.utils.interfaces.ARunnable;
import io.aether.utils.interfaces.ASupplierBoolean;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanIterable;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import it.unimi.dsi.fastutil.booleans.BooleanListIterator;
import it.unimi.dsi.fastutil.booleans.BooleanOpenHashSet;
import it.unimi.dsi.fastutil.booleans.BooleanSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface FlowBoolean
extends BooleanIterator,
BooleanIterable {
    public static final boolean[] EMPTY_AR = new boolean[0];
    public static final FlowBoolean EMPTY = new FlowCompletedBoolean(){

        public boolean hasNext() {
            return false;
        }

        public boolean nextBoolean() {
            return false;
        }

        @Override
        public int count() {
            return 0;
        }

        @Override
        public boolean @NotNull [] toArray() {
            return EMPTY_AR;
        }

        @Override
        @NotNull
        public BooleanList toList() {
            return new BooleanArrayList();
        }

        @Override
        @NotNull
        public <K, V> Map<K, V> toMap(AFunctionBool2O<K> keyFactory, AFunctionBool2O<V> valFactory) {
            return new Object2ObjectOpenHashMap();
        }
    };

    default public Flow<Boolean> box() {
        final FlowBoolean self = this;
        return new Flow<Boolean>(){

            @Override
            public boolean hasNext() {
                return self.hasNext();
            }

            @Override
            public Boolean next() {
                return self.nextBoolean();
            }
        };
    }

    @NotNull
    public static FlowBoolean of(@NotNull FlowBoolean stream) {
        return stream;
    }

    @NotNull
    public static FlowBoolean of(final boolean ... array) {
        if (array.length == 0) {
            return FlowBoolean.of();
        }
        return new FlowCompletedBoolean(){
            int pos;

            public boolean hasNext() {
                return this.pos < array.length;
            }

            public boolean nextBoolean() {
                return array[this.pos++];
            }

            @Override
            public boolean @NotNull [] toArray() {
                return array;
            }

            @Override
            public void foreach(AConsumer<Boolean> c) {
                for (boolean v : array) {
                    c.accept(v);
                }
            }

            @Override
            public int count() {
                return array.length;
            }

            @Override
            @NotNull
            public BooleanList toList() {
                return new BooleanArrayList(array);
            }

            @Override
            @NotNull
            public ASupplierBoolean toSupplier() {
                return new ASupplierBoolean(){
                    int pos;

                    @Override
                    public boolean get2() {
                        if (this.pos == array.length) {
                            throw new NoSuchElementException();
                        }
                        return array[this.pos++];
                    }
                };
            }
        };
    }

    @NotNull
    public static FlowBoolean of(@NotNull BooleanIterable iterable) {
        if (iterable instanceof BooleanSet) {
            return FlowBoolean.of((BooleanSet)iterable);
        }
        if (iterable instanceof BooleanList) {
            return FlowBoolean.of((BooleanList)iterable);
        }
        return FlowBoolean.of(iterable.iterator());
    }

    @NotNull
    public static FlowBoolean of(final @NotNull BooleanSet collection) {
        if (collection.isEmpty()) {
            return FlowBoolean.of();
        }
        final BooleanIterator it = collection.iterator();
        return new FlowCompletedBoolean(){

            @Override
            public int count() {
                return collection.size();
            }

            public boolean hasNext() {
                return it.hasNext();
            }

            public boolean nextBoolean() {
                return it.nextBoolean();
            }

            @Override
            @NotNull
            public BooleanSet toSet() {
                return collection;
            }
        };
    }

    @NotNull
    public static FlowBoolean of(final @NotNull BooleanList collection) {
        if (collection.isEmpty()) {
            return FlowBoolean.of();
        }
        final BooleanListIterator it = collection.iterator();
        return new FlowCompletedBoolean(){

            @Override
            public int count() {
                return collection.size();
            }

            public boolean hasNext() {
                return it.hasNext();
            }

            public boolean nextBoolean() {
                return it.nextBoolean();
            }

            @Override
            @NotNull
            public BooleanList toList() {
                return collection;
            }
        };
    }

    @NotNull
    public static FlowBoolean of(final @NotNull BooleanIterator iterator) {
        if (!iterator.hasNext()) {
            return FlowBoolean.of();
        }
        return new FlowBoolean(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public boolean nextBoolean() {
                return iterator.nextBoolean();
            }
        };
    }

    public static FlowBoolean of() {
        return EMPTY;
    }

    public static void quickSort(int[] source, int leftBorder, int rightBorder, AComparatorInt comparator) {
        int leftMarker = leftBorder;
        int rightMarker = rightBorder;
        int pivot = source[(leftMarker + rightMarker) / 2];
        while (true) {
            if (comparator.compare(source[leftMarker], pivot) < 0) {
                ++leftMarker;
                continue;
            }
            while (comparator.compare(source[rightMarker], pivot) > 0) {
                --rightMarker;
            }
            if (leftMarker <= rightMarker) {
                if (leftMarker < rightMarker) {
                    int tmp = source[leftMarker];
                    source[leftMarker] = source[rightMarker];
                    source[rightMarker] = tmp;
                }
                ++leftMarker;
                --rightMarker;
            }
            if (leftMarker > rightMarker) break;
        }
        if (leftMarker < rightBorder) {
            FlowBoolean.quickSort(source, leftMarker, rightBorder, comparator);
        }
        if (leftBorder < rightMarker) {
            FlowBoolean.quickSort(source, leftBorder, rightMarker, comparator);
        }
    }

    @NotNull
    default public BooleanIterator iterator() {
        return this;
    }

    default public boolean random() {
        boolean[] ar = this.toArray();
        return ar[Flow.RANDOM.nextInt(ar.length)];
    }

    default public boolean anyMatch(APredicateBoolean p) {
        while (this.hasNext()) {
            if (!p.test(this.nextBoolean())) continue;
            return true;
        }
        return false;
    }

    default public boolean noneMatch(APredicateBoolean p) {
        while (this.hasNext()) {
            if (!p.test(this.nextBoolean())) continue;
            return false;
        }
        return true;
    }

    default public FlowBoolean add(final boolean value) {
        final FlowBoolean oit = this;
        return new FlowBoolean(){
            private boolean index;

            public boolean hasNext() {
                return !this.index || oit.hasNext();
            }

            public boolean nextBoolean() {
                if (!this.index) {
                    this.index = true;
                    return value;
                }
                return oit.nextBoolean();
            }
        };
    }

    default public boolean allMatch(APredicateBoolean p) {
        while (this.hasNext()) {
            if (p.test(this.nextBoolean())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    default public <E> Flow<E> mapToObj(final @NotNull AFunctionBool2O<E> f) {
        final FlowBoolean self = this;
        return new Flow<E>(){

            @Override
            public boolean hasNext() {
                return self.hasNext();
            }

            @Override
            public E next() {
                return f.apply(self.nextBoolean());
            }
        };
    }

    @NotNull
    default public FlowBoolean apply(final AConsumerBoolean c) {
        final FlowBoolean self = this;
        return new FlowBoolean(){

            public boolean hasNext() {
                return self.hasNext();
            }

            public boolean nextBoolean() {
                boolean v = self.nextBoolean();
                c.accept(v);
                return v;
            }
        };
    }

    default public FlowBoolean addAllEls(final boolean ... values) {
        final FlowBoolean oit = this;
        return new FlowBoolean(){
            private int index;

            public boolean hasNext() {
                return this.index < values.length || oit.hasNext();
            }

            public boolean nextBoolean() {
                if (this.index < values.length) {
                    return values[this.index++];
                }
                return oit.nextBoolean();
            }
        };
    }

    default public FlowBoolean addAll(FlowBoolean values) {
        return this.addAll((BooleanIterator)values);
    }

    default public FlowBoolean addAll(final BooleanIterator values) {
        if (!values.hasNext()) {
            return this;
        }
        final FlowBoolean oit = this;
        return new FlowBoolean(){

            public boolean hasNext() {
                return values.hasNext() || oit.hasNext();
            }

            public boolean nextBoolean() {
                if (values.hasNext()) {
                    return values.nextBoolean();
                }
                return oit.nextBoolean();
            }
        };
    }

    default public FlowBoolean addAll(BooleanIterable values) {
        return this.addAll(values.iterator());
    }

    default public void foreach(AConsumer<Boolean> c) {
        while (this.hasNext()) {
            c.accept(this.nextBoolean());
        }
    }

    @NotNull
    default public FlowBoolean flatMap(final @NotNull ABiConsumerBool2O<AConsumerBoolean> f) {
        final FlowBoolean oit = this;
        final BooleanArrayList list = new BooleanArrayList();
        final AConsumerBoolean cc = arg_0 -> ((BooleanArrayList)list).add(arg_0);
        return new FlowBoolean(){
            int pos;

            public boolean hasNext() {
                while (list.isEmpty()) {
                    if (!oit.hasNext()) {
                        return false;
                    }
                    f.accept(oit.nextBoolean(), cc);
                }
                return true;
            }

            public boolean nextBoolean() {
                boolean res = list.getBoolean(this.pos++);
                if (this.pos == list.size()) {
                    this.pos = 0;
                    list.clear();
                }
                return res;
            }
        };
    }

    default public boolean @NotNull [] toArray() {
        boolean[] res = new boolean[10];
        int i = 0;
        while (this.hasNext()) {
            if (i == res.length) {
                res = Arrays.copyOf(res, (int)((double)res.length * 1.5));
            }
            res[i++] = this.nextBoolean();
        }
        return Arrays.copyOf(res, i);
    }

    default public <E extends Collection<Boolean>> E toCollection(@NotNull E collection) {
        while (this.hasNext()) {
            collection.add(this.nextBoolean());
        }
        return (E)collection;
    }

    default public <E extends BooleanCollection> E toCollection(@NotNull E collection) {
        while (this.hasNext()) {
            collection.add(this.nextBoolean());
        }
        return collection;
    }

    @NotNull
    default public FlowBoolean filter(final @Nullable APredicateBoolean predicate) {
        if (predicate == null) {
            return this;
        }
        final FlowBoolean oit = this;
        return new FlowBoolean(){
            boolean last;
            boolean hasNext;

            public boolean hasNext() {
                if (this.hasNext) {
                    return true;
                }
                while (oit.hasNext()) {
                    this.last = oit.nextBoolean();
                    if (!predicate.test(this.last)) continue;
                    this.hasNext = true;
                    return true;
                }
                return false;
            }

            public boolean nextBoolean() {
                assert (this.hasNext);
                this.hasNext = false;
                return this.last;
            }
        };
    }

    @NotNull
    default public FlowBoolean filterNot(final @Nullable APredicateBoolean predicate) {
        if (predicate == null) {
            return this;
        }
        final FlowBoolean oit = this;
        return new FlowBoolean(){
            boolean last;
            boolean hasNext;

            public boolean hasNext() {
                if (this.hasNext) {
                    return true;
                }
                while (oit.hasNext()) {
                    this.last = oit.nextBoolean();
                    if (predicate.test(this.last)) continue;
                    this.hasNext = true;
                    return true;
                }
                return false;
            }

            public boolean nextBoolean() {
                assert (this.hasNext);
                this.hasNext = false;
                return this.last;
            }
        };
    }

    @NotNull
    default public FlowBoolean ifEmpty(final ARunnable task) {
        if (task == null) {
            return this;
        }
        final FlowBoolean oit = this;
        return new FlowBoolean(){
            boolean first = true;

            public boolean hasNext() {
                boolean res = oit.hasNext();
                if (!res && this.first) {
                    task.run();
                }
                this.first = false;
                return res;
            }

            public boolean nextBoolean() {
                return oit.nextBoolean();
            }
        };
    }

    @NotNull
    default public FlowBoolean ifEmpty(Exception error) {
        return this.ifEmpty(() -> {
            throw error;
        });
    }

    @NotNull
    default public FlowBoolean ignoreError(final Class<? extends Exception> ee) {
        if (ee == null) {
            return this;
        }
        final FlowBoolean oit = this;
        return new FlowBoolean(){
            boolean last;
            boolean hasNext;

            public boolean hasNext() {
                if (this.hasNext) {
                    return true;
                }
                while (oit.hasNext()) {
                    try {
                        this.last = oit.nextBoolean();
                        this.hasNext = true;
                        return true;
                    }
                    catch (Exception ex) {
                        if (ee.isInstance(ex)) continue;
                        RU.error(ex);
                    }
                }
                return false;
            }

            public boolean nextBoolean() {
                assert (this.hasNext);
                this.hasNext = false;
                return this.last;
            }
        };
    }

    @NotNull
    default public BooleanIterable toIterable() {
        return () -> this;
    }

    @NotNull
    default public BooleanList toList() {
        return new BooleanArrayList(this.toArray());
    }

    @NotNull
    default public BooleanSet toSet() {
        return new BooleanOpenHashSet(this.toArray());
    }

    default public void to(AConsumerBoolean consumer) {
        while (this.hasNext()) {
            consumer.accept(this.nextBoolean());
        }
    }

    default public <E> E streamTo(AFunction<FlowBoolean, E> consumer) {
        return consumer.apply(this);
    }

    @NotNull
    default public ASupplierBoolean toSupplier() {
        return () -> {
            if (this.hasNext()) {
                return this.nextBoolean();
            }
            throw new NoSuchElementException();
        };
    }

    @NotNull
    default public <K, V> Map<K, V> toMap(AFunctionBool2O<K> keyFactory, AFunctionBool2O<V> valFactory) {
        Object2ObjectOpenHashMap res = new Object2ObjectOpenHashMap();
        while (this.hasNext()) {
            boolean val = this.nextBoolean();
            res.put(keyFactory.apply(val), valFactory.apply(val));
        }
        return res;
    }

    default public String join(String delimer) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        while (this.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(delimer);
            }
            sb.append(this.nextBoolean());
        }
        return sb.toString();
    }

    default public String join(AFunctionBool2O<Object> preparer, String delimer) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        while (this.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(delimer);
            }
            sb.append(preparer.apply(this.nextBoolean()));
        }
        return sb.toString();
    }

    default public boolean getFirstOr(boolean def) {
        if (this.hasNext()) {
            return this.nextBoolean();
        }
        return def;
    }

    default public boolean getFirst() {
        if (this.hasNext()) {
            return this.nextBoolean();
        }
        throw new NoSuchElementException();
    }

    default public boolean getFirst(APredicateBoolean p) {
        return this.filter(p).getFirst();
    }

    default public String join() {
        StringBuilder sb = new StringBuilder();
        while (this.hasNext()) {
            sb.append(this.nextBoolean());
        }
        return sb.toString();
    }

    default public String join(String delim, String prefix, String postfix) {
        StringBuilder sb = new StringBuilder(prefix);
        boolean first = true;
        while (this.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(delim);
            }
            sb.append(this.nextBoolean());
        }
        sb.append(postfix);
        return sb.toString();
    }
}

