/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.flow;

import io.aether.utils.AString;
import io.aether.utils.RU;
import io.aether.utils.flow.Flow;
import io.aether.utils.flow.FlowCompletedByte;
import io.aether.utils.flow.FlowInt;
import io.aether.utils.flow.FlowLong;
import io.aether.utils.interfaces.AComparatorByte;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.interfaces.AConsumerByte;
import io.aether.utils.interfaces.AFunction;
import io.aether.utils.interfaces.AFunctionB2L;
import io.aether.utils.interfaces.AFunctionB2O;
import io.aether.utils.interfaces.AFunctionL2I;
import io.aether.utils.interfaces.AFunctionL2O;
import io.aether.utils.interfaces.APredicateByte;
import io.aether.utils.interfaces.ARunnable;
import io.aether.utils.interfaces.ASupplierByte;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteIterable;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteList;
import it.unimi.dsi.fastutil.bytes.ByteListIterator;
import it.unimi.dsi.fastutil.bytes.ByteOpenHashSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface FlowByte
extends ByteIterator,
ByteIterable {
    public static final byte[] EMPTY_AR = new byte[0];
    public static final FlowByte EMPTY = new FlowCompletedByte(){

        public boolean hasNext() {
            return false;
        }

        public byte nextByte() {
            return 0;
        }

        @Override
        public int count() {
            return 0;
        }

        @Override
        public byte @NotNull [] toArray() {
            return EMPTY_AR;
        }

        @Override
        @NotNull
        public ByteList toList() {
            return new ByteArrayList();
        }

        @Override
        @NotNull
        public <K, V> Map<K, V> toMap(AFunctionB2O<K> keyFactory, AFunctionB2O<V> valFactory) {
            return new Object2ObjectOpenHashMap();
        }
    };

    default public Flow<Byte> box() {
        final FlowByte self = this;
        return new Flow<Byte>(){

            @Override
            public boolean hasNext() {
                return self.hasNext();
            }

            @Override
            public Byte next() {
                return self.nextByte();
            }
        };
    }

    @NotNull
    public static FlowByte of(@NotNull FlowByte stream) {
        return stream;
    }

    @NotNull
    public static FlowByte of(final byte ... array) {
        if (array.length == 0) {
            return FlowByte.of();
        }
        return new FlowCompletedByte(){
            int pos;

            public boolean hasNext() {
                return this.pos < array.length;
            }

            public byte nextByte() {
                return array[this.pos++];
            }

            @Override
            public byte @NotNull [] toArray() {
                return array;
            }

            @Override
            public void foreach(AConsumer<Byte> c) {
                for (byte v : array) {
                    c.accept(v);
                }
            }

            @Override
            public int count() {
                return array.length;
            }

            @Override
            @NotNull
            public ByteList toList() {
                return new ByteArrayList(array);
            }

            @Override
            @NotNull
            public ASupplierByte toSupplier() {
                return new ASupplierByte(){
                    int pos;

                    @Override
                    public byte get2() {
                        if (this.pos == array.length) {
                            throw new NoSuchElementException();
                        }
                        return array[this.pos++];
                    }
                };
            }
        };
    }

    @NotNull
    public static FlowByte of(@NotNull ByteIterable iterable) {
        if (iterable instanceof ByteSet) {
            return FlowByte.of((ByteSet)iterable);
        }
        if (iterable instanceof ByteList) {
            return FlowByte.of((ByteList)iterable);
        }
        return FlowByte.of(iterable.iterator());
    }

    @NotNull
    public static FlowByte of(final @NotNull ByteSet collection) {
        if (collection.isEmpty()) {
            return FlowByte.of();
        }
        final ByteIterator it = collection.iterator();
        return new FlowCompletedByte(){

            @Override
            public int count() {
                return collection.size();
            }

            public boolean hasNext() {
                return it.hasNext();
            }

            public byte nextByte() {
                return it.nextByte();
            }

            @Override
            @NotNull
            public ByteSet toSet() {
                return collection;
            }
        };
    }

    @NotNull
    public static FlowByte of(final @NotNull ByteList collection) {
        if (collection.isEmpty()) {
            return FlowByte.of();
        }
        final ByteListIterator it = collection.iterator();
        return new FlowCompletedByte(){

            @Override
            public int count() {
                return collection.size();
            }

            public boolean hasNext() {
                return it.hasNext();
            }

            public byte nextByte() {
                return it.nextByte();
            }

            @Override
            @NotNull
            public ByteList toList() {
                return collection;
            }
        };
    }

    @NotNull
    public static FlowByte of(final @NotNull ByteIterator iterator) {
        if (!iterator.hasNext()) {
            return FlowByte.of();
        }
        return new FlowByte(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public byte nextByte() {
                return iterator.nextByte();
            }
        };
    }

    public static FlowByte of() {
        return EMPTY;
    }

    public static void quickSort(byte[] source, int leftBorder, int rightBorder, AComparatorByte comparator) {
        int leftMarker = leftBorder;
        int rightMarker = rightBorder;
        byte pivot = source[(leftMarker + rightMarker) / 2];
        while (true) {
            if (comparator.compare(source[leftMarker], pivot) < 0) {
                ++leftMarker;
                continue;
            }
            while (comparator.compare(source[rightMarker], pivot) > 0) {
                --rightMarker;
            }
            if (leftMarker <= rightMarker) {
                if (leftMarker < rightMarker) {
                    byte tmp = source[leftMarker];
                    source[leftMarker] = source[rightMarker];
                    source[rightMarker] = tmp;
                }
                ++leftMarker;
                --rightMarker;
            }
            if (leftMarker > rightMarker) break;
        }
        if (leftMarker < rightBorder) {
            FlowByte.quickSort(source, leftMarker, rightBorder, comparator);
        }
        if (leftBorder < rightMarker) {
            FlowByte.quickSort(source, leftBorder, rightMarker, comparator);
        }
    }

    @NotNull
    default public ByteIterator iterator() {
        return this;
    }

    default public boolean anyMatch(APredicateByte p) {
        while (this.hasNext()) {
            if (!p.test(this.nextByte())) continue;
            return true;
        }
        return false;
    }

    default public boolean noneMatch(APredicateByte p) {
        while (this.hasNext()) {
            if (!p.test(this.nextByte())) continue;
            return false;
        }
        return true;
    }

    default public FlowByte add(final byte value) {
        final FlowByte oit = this;
        return new FlowByte(){
            private boolean index;

            public boolean hasNext() {
                return !this.index || oit.hasNext();
            }

            public byte nextByte() {
                if (!this.index) {
                    this.index = true;
                    return value;
                }
                return oit.nextByte();
            }
        };
    }

    default public boolean noneMatchValue(byte p) {
        while (this.hasNext()) {
            if (p != this.nextByte()) continue;
            return false;
        }
        return true;
    }

    default public boolean anyMatchValue(byte p) {
        while (this.hasNext()) {
            if (p != this.nextByte()) continue;
            return true;
        }
        return false;
    }

    default public boolean allMatch(APredicateByte p) {
        while (this.hasNext()) {
            if (p.test(this.nextByte())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    default public <E> Flow<E> map(final @NotNull AFunctionL2O<E> f) {
        final FlowByte self = this;
        return new Flow<E>(){

            @Override
            public boolean hasNext() {
                return self.hasNext();
            }

            @Override
            public E next() {
                return f.apply(self.nextByte());
            }
        };
    }

    @NotNull
    default public FlowLong map(final @NotNull AFunctionB2L f) {
        final FlowByte self = this;
        return new FlowLong(){

            public boolean hasNext() {
                return self.hasNext();
            }

            public long nextLong() {
                return f.apply(self.nextByte());
            }
        };
    }

    @NotNull
    default public FlowByte apply(final AConsumerByte c) {
        final FlowByte self = this;
        return new FlowByte(){

            public boolean hasNext() {
                return self.hasNext();
            }

            public byte nextByte() {
                byte v = self.nextByte();
                c.accept(v);
                return v;
            }
        };
    }

    default public FlowByte addAllEls(final byte ... values) {
        final FlowByte oit = this;
        return new FlowByte(){
            private int index;

            public boolean hasNext() {
                return this.index < values.length || oit.hasNext();
            }

            public byte nextByte() {
                if (this.index < values.length) {
                    return values[this.index++];
                }
                return oit.nextByte();
            }
        };
    }

    default public FlowByte addAll(FlowByte values) {
        return this.addAll((ByteIterator)values);
    }

    default public FlowByte addAll(final ByteIterator values) {
        if (!values.hasNext()) {
            return this;
        }
        final FlowByte oit = this;
        return new FlowByte(){

            public boolean hasNext() {
                return values.hasNext() || oit.hasNext();
            }

            public byte nextByte() {
                if (values.hasNext()) {
                    return values.nextByte();
                }
                return oit.nextByte();
            }
        };
    }

    default public FlowByte addAll(ByteIterable values) {
        return this.addAll(values.iterator());
    }

    default public void foreach(AConsumer<Byte> c) {
        while (this.hasNext()) {
            c.accept(this.nextByte());
        }
    }

    default public byte @NotNull [] toArray() {
        byte[] res = new byte[10];
        int i = 0;
        while (this.hasNext()) {
            if (i == res.length) {
                res = Arrays.copyOf(res, (int)((double)res.length * 1.5));
            }
            res[i++] = this.nextByte();
        }
        return Arrays.copyOf(res, i);
    }

    default public <E extends Collection<Byte>> E toCollection(@NotNull E collection) {
        while (this.hasNext()) {
            collection.add(this.nextByte());
        }
        return (E)collection;
    }

    default public <E extends ByteCollection> E toCollection(@NotNull E collection) {
        while (this.hasNext()) {
            collection.add(this.nextByte());
        }
        return collection;
    }

    @NotNull
    default public FlowByte filter(final @Nullable APredicateByte predicate) {
        if (predicate == null) {
            return this;
        }
        final FlowByte oit = this;
        return new FlowByte(){
            byte last;
            boolean hasNext;

            public boolean hasNext() {
                if (this.hasNext) {
                    return true;
                }
                while (oit.hasNext()) {
                    this.last = oit.nextByte();
                    if (!predicate.test(this.last)) continue;
                    this.hasNext = true;
                    return true;
                }
                return false;
            }

            public byte nextByte() {
                assert (this.hasNext);
                this.hasNext = false;
                return this.last;
            }
        };
    }

    @NotNull
    default public FlowByte filterNot(final @Nullable APredicateByte predicate) {
        if (predicate == null) {
            return this;
        }
        final FlowByte oit = this;
        return new FlowByte(){
            byte last;
            boolean hasNext;

            public boolean hasNext() {
                if (this.hasNext) {
                    return true;
                }
                while (oit.hasNext()) {
                    this.last = oit.nextByte();
                    if (predicate.test(this.last)) continue;
                    this.hasNext = true;
                    return true;
                }
                return false;
            }

            public byte nextByte() {
                assert (this.hasNext);
                this.hasNext = false;
                return this.last;
            }
        };
    }

    @NotNull
    default public FlowByte ifEmpty(final ARunnable task) {
        if (task == null) {
            return this;
        }
        final FlowByte oit = this;
        return new FlowByte(){
            boolean first = true;

            public boolean hasNext() {
                boolean res = oit.hasNext();
                if (!res && this.first) {
                    task.run();
                }
                this.first = false;
                return res;
            }

            public byte nextByte() {
                return oit.nextByte();
            }
        };
    }

    @NotNull
    default public FlowByte ifEmpty(Exception error) {
        return this.ifEmpty(() -> {
            throw error;
        });
    }

    @NotNull
    default public FlowByte ignoreError(final Class<? extends Exception> ee) {
        if (ee == null) {
            return this;
        }
        final FlowByte oit = this;
        return new FlowByte(){
            byte last;
            boolean hasNext;

            public boolean hasNext() {
                if (this.hasNext) {
                    return true;
                }
                while (oit.hasNext()) {
                    try {
                        this.last = oit.nextByte();
                        this.hasNext = true;
                        return true;
                    }
                    catch (Exception ex) {
                        if (ee.isInstance(ex)) continue;
                        RU.error(ex);
                    }
                }
                return false;
            }

            public byte nextByte() {
                assert (this.hasNext);
                this.hasNext = false;
                return this.last;
            }
        };
    }

    @NotNull
    default public FlowByte sort(@NotNull AComparatorByte comparator) {
        byte[] arr = this.toArray();
        FlowByte.quickSort(arr, 0, arr.length, comparator);
        return FlowByte.of(arr);
    }

    @NotNull
    default public ByteIterable toIterable() {
        return () -> this;
    }

    @NotNull
    default public ByteList toList() {
        return new ByteArrayList(this.toArray());
    }

    @NotNull
    default public ByteSet toSet() {
        return new ByteOpenHashSet(this.toArray());
    }

    default public void to(AConsumerByte consumer) {
        while (this.hasNext()) {
            consumer.accept(this.nextByte());
        }
    }

    default public <E> E streamTo(AFunction<FlowByte, E> consumer) {
        return consumer.apply(this);
    }

    @NotNull
    default public ASupplierByte toSupplier() {
        return () -> {
            if (this.hasNext()) {
                return this.nextByte();
            }
            throw new NoSuchElementException();
        };
    }

    @NotNull
    default public <K, V> Map<K, V> toMap(AFunctionB2O<K> keyFactory, AFunctionB2O<V> valFactory) {
        Object2ObjectOpenHashMap res = new Object2ObjectOpenHashMap();
        while (this.hasNext()) {
            byte val = this.nextByte();
            res.put(keyFactory.apply(val), valFactory.apply(val));
        }
        return res;
    }

    @NotNull
    default public <V> Int2ObjectMap<V> toMapI2O(AFunctionL2I keyFactory, AFunctionL2O<V> valFactory) {
        Int2ObjectOpenHashMap res = new Int2ObjectOpenHashMap();
        while (this.hasNext()) {
            byte val = this.nextByte();
            res.put(keyFactory.apply(val), valFactory.apply(val));
        }
        return res;
    }

    @NotNull
    default public <K> Object2IntMap<K> toMapO2I(AFunctionL2O<K> keyFactory, AFunctionL2I valFactory) {
        Object2IntOpenHashMap res = new Object2IntOpenHashMap();
        while (this.hasNext()) {
            byte val = this.nextByte();
            res.put(keyFactory.apply(val), valFactory.apply(val));
        }
        return res;
    }

    @NotNull
    default public <V> Long2ObjectMap<V> toMapL2O(AFunctionB2L keyFactory, AFunctionB2O<V> valFactory) {
        Long2ObjectOpenHashMap res = new Long2ObjectOpenHashMap();
        while (this.hasNext()) {
            byte val = this.nextByte();
            res.put(keyFactory.apply(val), valFactory.apply(val));
        }
        return res;
    }

    default public String join(String delimer) {
        return this.join(AString.of(), delimer).toString();
    }

    default public AString join(AString sb, String delimer) {
        boolean first = true;
        while (this.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.add(delimer);
            }
            sb.add(this.nextByte());
        }
        return sb;
    }

    default public FlowByte distinct() {
        return this.filter(new APredicateByte(){
            private final ByteSet old = new ByteOpenHashSet();

            @Override
            public boolean test2(byte value) {
                return this.old.add(value);
            }
        });
    }

    default public String join(AFunctionL2O<Object> preparer, String delimer) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        while (this.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(delimer);
            }
            sb.append(preparer.apply(this.nextByte()));
        }
        return sb.toString();
    }

    default public byte getFirstOr(byte def) {
        if (this.hasNext()) {
            return this.nextByte();
        }
        return def;
    }

    default public byte getFirst() {
        if (this.hasNext()) {
            return this.nextByte();
        }
        throw new NoSuchElementException();
    }

    default public byte getFirst(APredicateByte p) {
        return this.filter(p).getFirst();
    }

    default public String join() {
        StringBuilder sb = new StringBuilder();
        while (this.hasNext()) {
            sb.append(this.nextByte());
        }
        return sb.toString();
    }

    default public String join(String delimer, String prefix, String postfix) {
        StringBuilder sb = new StringBuilder(prefix);
        boolean first = true;
        while (this.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(delimer);
            }
            sb.append(this.nextByte());
        }
        sb.append(postfix);
        return sb.toString();
    }

    default public byte min(AComparatorByte comparator) {
        byte min = 127;
        while (this.hasNext()) {
            byte v = this.nextByte();
            if (comparator.compare(min, v) <= 0) continue;
            min = v;
        }
        return min;
    }

    default public byte max(AComparatorByte comparator) {
        byte max = -128;
        while (this.hasNext()) {
            byte v = this.nextByte();
            if (comparator.compare(max, v) >= 0) continue;
            max = v;
        }
        return max;
    }

    default public FlowInt mapToUInt() {
        final FlowByte self = this;
        return new FlowInt(){

            public int nextInt() {
                return Byte.toUnsignedInt(self.nextByte());
            }

            public boolean hasNext() {
                return self.hasNext();
            }
        };
    }
}

